/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.alchemy;

import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.abstract_traits.IDraggingTrait;
import com.beansgalaxy.backpacks.traits.abstract_traits.ISlotSelectorTrait;
import com.beansgalaxy.backpacks.traits.alchemy.AlchemyClient;
import com.beansgalaxy.backpacks.traits.alchemy.AlchemyMutable;
import com.beansgalaxy.backpacks.traits.generic.ChestLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import net.minecraft.class_5253;
import net.minecraft.class_9334;
import net.minecraft.class_9381;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class AlchemyTraits
extends ChestLikeTraits
implements ISlotSelectorTrait,
IDraggingTrait {
    public static final String NAME = "alchemy";

    public AlchemyTraits(ModSound sound, int size) {
        super(sound, size);
    }

    @Override
    public String name() {
        return NAME;
    }

    public AlchemyClient client() {
        return AlchemyClient.INSTANCE;
    }

    @Override
    public boolean canItemFit(ComponentHolder holder, class_1799 inserted) {
        class_1792 item = inserted.method_7909();
        boolean isPotion = item instanceof class_1812 || class_1802.field_20417.equals(item) || class_1802.field_8103.equals(item) || class_1802.field_50140.equals(item);
        return isPotion && super.canItemFit(holder, inserted);
    }

    @Override
    public AlchemyMutable mutable(ComponentHolder holder) {
        return new AlchemyMutable(this, holder);
    }

    @Override
    public void use(class_1937 level, class_1657 player, class_1268 hand, ComponentHolder holder, CallbackInfoReturnable<class_1271<class_1799>> cir) {
        if (this.isEmpty(holder)) {
            return;
        }
        AlchemyMutable mutable = this.mutable(holder);
        int selectedSlot = mutable.getSelectedSlot(player);
        class_1799 selected = mutable.getItemStacks().get(selectedSlot);
        class_1792 item = selected.method_7909();
        if (class_1802.field_20417.equals(item)) {
            if (!player.method_7332(false)) {
                return;
            }
            class_4174 foodproperties = (class_4174)selected.method_57824(class_9334.field_50075);
            if (foodproperties == null) {
                return;
            }
            AlchemyTraits.useHoneyBottle(level, player, selected, foodproperties, item);
        } else if (class_1802.field_8103.equals(item)) {
            AlchemyTraits.useMilkBucketItem(mutable, level, player, item, selected);
        } else {
            class_1844 potioncontents = (class_1844)selected.method_57824(class_9334.field_49651);
            if (potioncontents != null) {
                AlchemyTraits.usePotionLikeItem(potioncontents, level, player, selected, item);
            } else {
                Integer ominousAmplifier = (Integer)selected.method_57824(class_9334.field_50238);
                if (ominousAmplifier != null) {
                    double random1;
                    double random0;
                    int j;
                    class_243 movement = player.method_18798().method_18805(2.0, 0.5, 2.0);
                    class_9381 effect = class_9381.method_58256((class_2396)class_2398.field_11226, (int)class_5253.class_5254.method_58144((int)255, (int)4797256));
                    for (j = 0; j < 15; ++j) {
                        random0 = level.field_9229.method_43058();
                        random1 = level.field_9229.method_43058();
                        double y = class_3532.method_16436((double)random0, (double)(player.method_23318() + (double)player.method_17682()), (double)player.method_23318());
                        double centered0 = random0 - 0.5;
                        double xSpeed = movement.field_1352 + centered0 * 0.1;
                        double ySpeed = movement.field_1351 - random1 * 0.2;
                        double centered1 = random1 - 0.5;
                        double zSpeed = movement.field_1350 + centered1 * 0.1;
                        level.method_8406((class_2394)effect, player.method_23317(), y, player.method_23321(), xSpeed, ySpeed, zSpeed);
                        if (!level.field_9229.method_43056()) continue;
                        level.method_8406((class_2394)class_2398.field_11251, player.method_23317() + centered1, y, player.method_23321() + centered0, xSpeed, random0 * 0.1, zSpeed);
                    }
                    for (j = 0; j < 5; ++j) {
                        random0 = level.field_9229.method_43058();
                        random1 = level.field_9229.method_43058();
                        double centered0 = random0 - 0.5;
                        double centered1 = random1 - 0.5;
                        double y = class_3532.method_16436((double)random0, (double)(player.method_23318() + (double)player.method_17682()), (double)player.method_23318());
                        level.method_8406((class_2394)class_2398.field_11251, player.method_23317() + centered1, y, player.method_23321() + centered0, 0.0, random0 * 0.1, 0.0);
                    }
                    selected.method_7910(level, (class_1309)player);
                }
            }
        }
        if (selected.method_7960()) {
            mutable.limitSelectedSlot(selectedSlot);
        }
        mutable.push();
        class_1799 backpack = player.method_5998(hand);
        cir.setReturnValue((Object)class_1271.method_29237((Object)backpack, (boolean)level.field_9236));
    }

    private static void useHoneyBottle(class_1937 level, class_1657 player, class_1799 selected, class_4174 foodproperties, class_1792 item) {
        player.method_18866(level, selected, foodproperties);
        player.method_43077(class_3417.field_15081);
        if (player instanceof class_3222) {
            class_3222 serverplayer = (class_3222)player;
            class_174.field_1198.method_8821(serverplayer, selected);
            serverplayer.method_7259(class_3468.field_15372.method_14956((Object)item));
            player.method_6016(class_1294.field_5899);
        }
        class_2680 blockstate = class_2246.field_21211.method_9564();
        class_2388 particleOption = new class_2388(class_2398.field_11217, blockstate);
        double eyeY = player.method_5829().field_1325;
        double lowY = (player.method_23318() + eyeY + eyeY) * 0.334;
        double rad = Math.PI / 180;
        double yRot = (double)(-player.method_5791()) * rad;
        double xRot = (double)(-player.method_36455()) * rad;
        double x = player.method_23317() + Math.sin(yRot) * 0.5 * Math.cos(xRot);
        double z = player.method_23321() + Math.cos(yRot) * 0.5 * Math.cos(xRot);
        double yO = Math.sin(xRot) * 0.3 - 0.2;
        class_243 movement = player.method_18798().method_18805(2.0, 1.0, 2.0);
        for (int j = 0; j < 5; ++j) {
            double random = level.field_9229.method_43058();
            double y = class_3532.method_16436((double)(random * random), (double)lowY, (double)eyeY) + yO;
            double xySpeed = random - 0.5;
            double xSpeed = movement.field_1352 + xySpeed;
            double ySpeed = movement.field_1351 - random * 0.4;
            double zSpeed = movement.field_1350 + xySpeed;
            level.method_8406((class_2394)particleOption, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    private static void useMilkBucketItem(AlchemyMutable mutable, class_1937 level, class_1657 player, class_1792 item, class_1799 selected) {
        class_1799 consumedStack = item.method_7861(selected.method_46651(1), level, (class_1309)player);
        if (!player.method_56992()) {
            selected.method_7934(1);
            List<class_1799> itemStacks = mutable.getItemStacks();
            if (!consumedStack.method_7960()) {
                for (int i = 0; i < itemStacks.size(); ++i) {
                    class_1799 nonEdible = itemStacks.get(i);
                    if (!class_1799.method_31577((class_1799)nonEdible, (class_1799)consumedStack)) continue;
                    class_1799 removed = itemStacks.remove(i);
                    consumedStack.method_7933(removed.method_7947());
                    mutable.limitSelectedSlot(i);
                }
                if (!consumedStack.method_7960()) {
                    itemStacks.addFirst(consumedStack);
                    mutable.setSelectedSlot(player, mutable.getSelectedSlot(player));
                    mutable.growSelectedSlot(0);
                }
            }
        }
        player.method_43077(class_3417.field_14810);
        class_243 movement = player.method_18798().method_18805(1.75, 0.5, 1.75);
        for (int j = 0; j < 6; ++j) {
            double random = level.field_9229.method_43058();
            double centered = random - 0.5;
            double xySpeed = centered * (Math.abs(movement.field_1352) + Math.abs(movement.field_1350)) * 0.5;
            double xSpeed = movement.field_1352 + xySpeed;
            double ySpeed = movement.field_1351;
            double zSpeed = movement.field_1350 + xySpeed;
            double centered1 = level.field_9229.method_43058() - 0.5;
            double centered2 = level.field_9229.method_43058() - 0.5;
            double top = (double)player.method_17682() + player.method_23318();
            level.method_8406((class_2394)class_2398.field_28013, player.method_23317() + centered1, top, player.method_23321() + centered2, xSpeed + xySpeed, ySpeed, zSpeed + xySpeed);
            double y = class_3532.method_16436((double)random, (double)player.method_23318(), (double)player.method_23320());
            level.method_8406((class_2394)class_2398.field_46911, player.method_23317() + centered2, y, player.method_23321() + centered1, xSpeed, ySpeed, zSpeed);
        }
        class_9381 particleOption = class_9381.method_58256((class_2396)class_2398.field_11226, (int)class_5253.class_5254.method_58144((int)100, (int)0xFFFFFF));
        for (int j = 0; j < 10; ++j) {
            double random = level.field_9229.method_43058();
            double y = class_3532.method_16436((double)Math.sqrt(random), (double)player.method_23318(), (double)player.method_23320());
            double xySpeed = (random - 0.5) * 0.1;
            level.method_8406((class_2394)particleOption, player.method_23317(), y, player.method_23321(), xySpeed, -random * 0.2, xySpeed);
        }
        class_9381 alphaOption = class_9381.method_58256((class_2396)class_2398.field_11226, (int)class_5253.class_5254.method_58144((int)200, (int)0xFFFFFF));
        for (int j = 0; j < 8; ++j) {
            double random = level.field_9229.method_43058();
            double y = class_3532.method_16436((double)random, (double)player.method_23318(), (double)player.method_23320());
            double centered = random - 0.5;
            double xySpeed = centered * 10.0;
            level.method_8406((class_2394)alphaOption, player.method_23317(), y, player.method_23321(), xySpeed, -random * 0.2, xySpeed);
        }
    }

    private static void usePotionLikeItem(class_1844 potioncontents, class_1937 level, class_1657 player, class_1799 selected, class_1792 item) {
        Optional potion = potioncontents.comp_2378();
        Boolean waterLike = potion.map(holder -> class_1847.field_8999.equals(holder) || class_1847.field_8967.equals(holder) || class_1847.field_8985.equals(holder) || class_1847.field_8991.equals(holder)).orElse(false);
        class_243 movement = player.method_18798().method_18805(2.0, 0.5, 2.0);
        if (waterLike.booleanValue()) {
            player.method_46395();
            player.method_43077(class_3417.field_14810);
            for (int j = 0; j < 4; ++j) {
                double random = level.field_9229.method_43058();
                double y = class_3532.method_16436((double)Math.sqrt(random), (double)player.method_23318(), (double)player.method_23320());
                double centered = random - 0.5;
                double xySpeed = centered * 0.1;
                double centered1 = level.field_9229.method_43058() - 0.5;
                double centered2 = level.field_9229.method_43058() - 0.5;
                double xSpeed = movement.field_1352 + xySpeed;
                double ySpeed = movement.field_1351 - random * 0.2;
                double zSpeed = movement.field_1350 + xySpeed;
                level.method_8406((class_2394)class_2398.field_18306, player.method_23317() + centered1, y, player.method_23321() + centered2, xSpeed, ySpeed, zSpeed);
            }
            class_9381 particleOption = class_9381.method_58256((class_2396)class_2398.field_11226, (int)class_5253.class_5254.method_58144((int)100, (int)-13083194));
            for (int j = 0; j < 10; ++j) {
                double random = level.field_9229.method_43058();
                double y = class_3532.method_16436((double)Math.sqrt(random), (double)player.method_23318(), (double)player.method_23320());
                double xySpeed = (random - 0.5) * 0.1;
                double xSpeed = movement.field_1352 + xySpeed;
                double ySpeed = movement.field_1351 - random * 0.2;
                double zSpeed = movement.field_1350 + xySpeed;
                level.method_8406((class_2394)particleOption, player.method_23317(), y, player.method_23321(), xSpeed, ySpeed, zSpeed);
                level.method_8406((class_2394)class_2398.field_11202, player.method_23317(), y, player.method_23321(), xSpeed, ySpeed, zSpeed);
            }
            class_9381 alphaOption = class_9381.method_58256((class_2396)class_2398.field_11226, (int)class_5253.class_5254.method_58144((int)200, (int)-13083194));
            for (int j = 0; j < 8; ++j) {
                double random = level.field_9229.method_43058();
                double y = class_3532.method_16436((double)(random * random), (double)player.method_23318(), (double)player.method_23320());
                double centered = random - 0.5;
                double xySpeed = centered * 10.0;
                double xSpeed = movement.field_1352 + xySpeed;
                double ySpeed = movement.field_1351 - random * 0.2;
                double zSpeed = movement.field_1350 + xySpeed;
                level.method_8406((class_2394)alphaOption, player.method_23317(), y, player.method_23321(), xSpeed, ySpeed, zSpeed);
                level.method_8406((class_2394)class_2398.field_11202, player.method_23317(), y, player.method_23321(), xSpeed, ySpeed, zSpeed);
            }
        } else {
            potioncontents.method_57402(effect -> {
                for (int j = 0; j < 20; ++j) {
                    double random = level.field_9229.method_43058();
                    double y = class_3532.method_16436((double)(random * random), (double)player.method_23318(), (double)player.method_23320());
                    double xySpeed = random - 0.5;
                    double xSpeed = movement.field_1352 + xySpeed;
                    double ySpeed = movement.field_1351 - random * 0.2;
                    double zSpeed = movement.field_1350 + xySpeed;
                    level.method_8406(effect.method_58148(), player.method_23317(), y, player.method_23321(), xSpeed, ySpeed, zSpeed);
                }
            });
        }
        selected.method_7910(level, (class_1309)player);
        player.method_43077(class_3417.field_15081);
    }

    public String toString() {
        return "AlchemyTraits{size=" + this.size() + ", sound=" + String.valueOf((Object)this.sound()) + "}";
    }

    @Override
    public TraitComponentKind<? extends GenericTraits> kind() {
        return Traits.ALCHEMY;
    }
}

