/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.bundle;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.network.serverbound.TraitMenuClick;
import com.beansgalaxy.backpacks.screen.TraitMenu;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5630;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import net.minecraft.class_8002;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class BundleMenu<T extends BundleLikeTraits>
extends TraitMenu<T> {
    int rows;
    int columns;
    int size;
    @Nullable
    private tSlot hoveredSlot = null;

    public BundleMenu(class_310 minecraft, int screenLeft, int screenTop, int screenHeight, int screenWidth, class_1735 slot, ComponentHolder holder, T traits) {
        super(minecraft, screenLeft, screenTop, screenHeight, screenWidth, slot, holder, traits);
        this.updateSize();
        double offset = (double)slot.field_7872 * 0.1 - 2.0;
        int drift = (int)((double)(this.rows - 1) * offset);
        this.topPos -= drift + 2;
    }

    protected boolean hasSpace() {
        return ((BundleLikeTraits)this.traits).fullness(this.holder).compareTo(Fraction.ONE) != 0;
    }

    private void updateSize() {
        List<class_1799> stacks = this.holder.get(ITraitData.ITEM_STACKS);
        this.size = stacks == null ? 0 : stacks.size();
        int sudoSize = this.size + (this.hasSpace() ? 1 : 0);
        int forRow = 1;
        int columns = Math.min(sudoSize, 4);
        int rows = 1;
        for (int i = columns; i <= sudoSize; ++i) {
            if (i <= columns * rows) continue;
            if (forRow == 2) {
                ++columns;
                forRow = 0;
                continue;
            }
            ++rows;
            ++forRow;
        }
        this.columns = columns;
        this.rows = rows;
    }

    @Override
    protected int getWidth() {
        return this.columns * 16 + 16;
    }

    @Override
    protected int getHeight() {
        return this.rows * 16 + 8;
    }

    @Override
    public void menuClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (this.hoveredSlot != null) {
            class_746 player = this.minecraft.field_1724;
            class_1703 containerMenu = player.field_7512;
            TraitMenuClick.Kind clickType = this.getClickType(button);
            TraitMenuClick.send(containerMenu.field_7763, this.slot, this.hoveredSlot.index, clickType);
            class_5630 access = class_5630.method_59666(() -> ((class_1703)containerMenu).method_34255(), arg_0 -> ((class_1703)containerMenu).method_34254(arg_0));
            ((BundleLikeTraits)this.traits).menuClick(this.holder, this.hoveredSlot.index, clickType, access, (class_1657)player);
            cir.setReturnValue((Object)true);
        }
        this.updateSize();
    }

    private TraitMenuClick.Kind getClickType(int button) {
        boolean eitherShiftDown;
        boolean bl = eitherShiftDown = class_3675.method_15987((long)this.minecraft.method_22683().method_4490(), (int)340) || class_3675.method_15987((long)this.minecraft.method_22683().method_4490(), (int)344);
        if (eitherShiftDown) {
            return TraitMenuClick.Kind.SHIFT;
        }
        if (button == 1) {
            return TraitMenuClick.Kind.RIGHT;
        }
        return TraitMenuClick.Kind.LEFT;
    }

    @Override
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.hoveredSlot == null) {
            return;
        }
        if (keyCode == 81) {
            class_746 player = this.minecraft.field_1724;
            class_1703 containerMenu = player.field_7512;
            TraitMenuClick.Kind clickType = TraitMenuClick.Kind.DROP;
            TraitMenuClick.send(containerMenu.field_7763, this.slot, this.hoveredSlot.index, clickType);
            class_5630 access = class_5630.method_59666(() -> ((class_1703)containerMenu).method_34255(), arg_0 -> ((class_1703)containerMenu).method_34254(arg_0));
            ((BundleLikeTraits)this.traits).menuClick(this.holder, this.hoveredSlot.index, clickType, access, (class_1657)player);
            this.updateSize();
        }
    }

    @Override
    protected void menuRender(class_465<?> screen, class_332 gui, int mouseX, int mouseY) {
        class_8002.method_47946((class_332)gui, (int)8, (int)4, (int)(this.getWidth() - 16), (int)(this.getHeight() - 8), (int)0);
        this.renderItems(gui, mouseX, mouseY);
    }

    private void renderItems(class_332 gui, int mouseX, int mouseY) {
        this.updateSize();
        List<class_1799> stacks = this.holder.get(ITraitData.ITEM_STACKS);
        this.hoveredSlot = null;
        block0: for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.columns; ++x) {
                boolean isHovered;
                int i = y * this.columns + x;
                int x1 = x * 16 + 8;
                int y1 = y * 16 + 4;
                int x2 = x1 + 16;
                int y2 = y1 + 16;
                boolean bl = isHovered = mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2;
                if (isHovered) {
                    this.hoveredSlot = new tSlot(i, x1, x2, y1, y2);
                }
                if (i == this.size || stacks == null) continue block0;
                class_327 font = this.minecraft.field_1772;
                class_1799 stack = stacks.get(i);
                CommonClient.renderItem(this.minecraft, gui, stack, x1 + 8, y1 + 8, 15, false);
                CommonClient.renderItemDecorations(gui, font, stack, x1 + 8, y1 + 8, 15);
                if (!isHovered) continue;
                List lines = class_437.method_25408((class_310)this.minecraft, (class_1799)stack);
                Optional image = stack.method_32347();
                Integer imageHeight = image.map(class_5684::method_32663).map(class_5684::method_32661).orElse(0);
                int linesSize = lines.size();
                int linesHeight = linesSize < 2 ? 12 : 14 + (linesSize - 1) * 10;
                int height = imageHeight + linesHeight;
                gui.method_51437(font, lines, image, -4, -height + 10);
            }
        }
        if (this.hoveredSlot != null) {
            gui.method_51737(this.hoveredSlot.x1, this.hoveredSlot.y1, this.hoveredSlot.x2, this.hoveredSlot.y2, 30, 0x60FFFFFF);
        }
    }

    record tSlot(int index, int x1, int x2, int y1, int y2) {
    }
}

