/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.bundle;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.network.serverbound.TinyHotbarClick;
import com.beansgalaxy.backpacks.network.serverbound.TinyMenuClick;
import com.beansgalaxy.backpacks.network.serverbound.TinyMenuInteract;
import com.beansgalaxy.backpacks.screen.BackpackScreen;
import com.beansgalaxy.backpacks.screen.TinyClickType;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.util.SplitText;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5630;
import net.minecraft.class_746;
import net.minecraft.class_8002;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;

public class BundleScreen
extends BackpackScreen {
    protected final BundleLikeTraits traits;
    protected BundleTraitSlot lastSlot = null;

    public static void openScreen(class_1657 player, ViewableBackpack backpack, BundleLikeTraits traits) {
        class_310 minecraft = class_310.method_1551();
        BundleScreen screen = new BundleScreen(player, backpack, traits);
        minecraft.method_1507((class_437)screen);
        backpack.onOpen(player);
        TinyMenuInteract.send(backpack.getId(), true);
    }

    protected BundleScreen(class_1657 player, ViewableBackpack backpack, BundleLikeTraits traits) {
        super(player.field_7498, player.method_31548(), backpack);
        this.traits = traits;
    }

    public int traitTop() {
        return this.field_2800 + 84;
    }

    @Override
    protected void repopulateSlots(@NotNull class_332 gui, int pMouseX, int pMouseY, float pPartialTick) {
        int size;
        boolean hasSpace;
        class_1799 carried = this.getCarried();
        List<class_1799> stacks = this.backpack.get(ITraitData.ITEM_STACKS);
        if (stacks == null) {
            hasSpace = true;
            size = 1;
        } else {
            hasSpace = this.traits.fullness(stacks).compareTo(Fraction.ONE) != 0;
            size = stacks.size() + (hasSpace ? 1 : 0) + (carried.method_7960() ? 0 : 1);
        }
        int guiScaledWidth = this.field_22787.method_22683().method_4486();
        int maxWidth = guiScaledWidth / 2 - 126;
        boolean forCol = false;
        int columns = Math.min(size, 4);
        int rows = 1;
        for (int i = columns; i <= size; ++i) {
            if (i <= columns * rows) continue;
            if (forCol && maxWidth > 0) {
                ++columns;
                maxWidth -= 18;
            } else {
                ++rows;
            }
            forCol = !forCol;
        }
        this.clearSlots();
        int width = columns * 18;
        int right = this.field_2776 - 18;
        int left = right - width;
        int top = this.traitTop() - 11 - (rows - 1) / 2 * 10;
        int i = hasSpace ? -1 : 0;
        class_5250 title = class_2561.method_43473();
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                class_1799 stack;
                BundleTraitSlot slot = new BundleTraitSlot(left + x * 18, top + y * 18, i);
                if (slot.method_25405(pMouseX, pMouseY) && !(stack = slot.getItem()).method_7960()) {
                    List tooltipFromItem = class_437.method_25408((class_310)this.field_22787, (class_1799)stack);
                    title = (class_2561)tooltipFromItem.getFirst();
                }
                this.addSlot(slot);
                if (++i != size - (carried.method_7960() ? 0 : 1)) continue;
                this.lastSlot = slot;
            }
        }
        int fontWidth = this.field_22793.method_27525((class_5348)title);
        int fontHeight = 10;
        class_4587 pose = gui.method_51448();
        pose.method_22903();
        pose.method_46416(0.0f, 0.0f, 100.0f);
        if (fontWidth > width) {
            int height;
            class_5481 text = title.method_30937();
            SplitText splitText = new SplitText(text);
            splitText.split();
            ArrayList<class_5481> split = new ArrayList<class_5481>();
            int newWidth = splitText.noCropWidth(this.field_22793, width, split);
            left = left + width - newWidth;
            width = newWidth;
            int splitRow = height = split.size() * 10;
            for (class_5481 sequence : split) {
                int seqWidth = this.field_22793.method_30880(sequence);
                gui.method_35720(this.field_22787.field_1772, sequence, right - seqWidth, top - splitRow, -1);
                splitRow -= 10;
            }
            fontHeight = height;
        } else {
            gui.method_27535(this.field_22787.field_1772, (class_2561)title, right - fontWidth, top - 10, -1);
        }
        pose.method_22909();
        this.traitX = left + width;
        this.traitY = top - fontHeight;
        this.traitW = width;
        this.traitH = rows * 18 + fontHeight;
        class_8002.method_47946((class_332)gui, (int)(left - 1), (int)(top - 1 - fontHeight), (int)(width + 2), (int)(rows * 18 + 3 + fontHeight), (int)1);
        for (BackpackScreen.TraitSlot slot : this.slots) {
            slot.method_25394(gui, pMouseX, pMouseY, pPartialTick);
        }
    }

    @Override
    protected final void tinyMenuClick(int index, TinyClickType clickType, class_5630 carriedAccess, class_746 player) {
        this.traits.tinyMenuClick(this.backpack, index, clickType, carriedAccess, (class_1657)player);
        TinyMenuClick.send(this.backpack, index, clickType);
    }

    @Override
    protected final void tinyHotbarClick(TinyClickType clickType, class_1723 menu, class_746 player, int index) {
        this.traits.tinyHotbarClick(this.backpack, index, clickType, menu, (class_1657)player);
        TinyHotbarClick.send(this.backpack, index, clickType);
    }

    private int lastSlotIndex() {
        List<class_1799> stacks = this.backpack.get(ITraitData.ITEM_STACKS);
        return stacks == null ? 0 : stacks.size();
    }

    public class BundleTraitSlot
    extends BackpackScreen.TraitSlot {
        public BundleTraitSlot(int pX, int pY, int index) {
            super(pX, pY, index);
        }

        @Override
        public class_1799 getItem() {
            List<class_1799> stacks = BundleScreen.this.backpack.get(ITraitData.ITEM_STACKS);
            if (stacks == null || this.index == -1) {
                return class_1799.field_8037;
            }
            return this.index < stacks.size() ? stacks.get(this.index) : class_1799.field_8037;
        }

        protected void method_48579(class_332 gui, int i, int i1, float v) {
            class_1799 stack = this.getItem();
            boolean hovered = this.method_49606();
            int x = this.method_46426() + 9;
            int y = this.method_46427() + 9;
            if (!stack.method_7960()) {
                class_310 minecraft = class_310.method_1551();
                CommonClient.renderItem(minecraft, gui, stack, x, y, 50, false);
                CommonClient.renderItemDecorations(gui, BundleScreen.this.field_22793, stack, x, y, 50);
                if (hovered) {
                    gui.method_51737(x - 8, y - 8, x + 8, y + 8, 100, -2130706433);
                }
            } else if (hovered) {
                if (this == BundleScreen.this.slots.getFirst()) {
                    gui.method_51737(x - 8, y - 8, x + 8, y + 8, 100, -2130706433);
                } else if (BundleScreen.this.lastSlot != null) {
                    int x1 = BundleScreen.this.lastSlot.method_46426() + 9;
                    int y1 = BundleScreen.this.lastSlot.method_46427() + 9;
                    gui.method_51737(x1 - 8, y1 - 8, x1 + 8, y1 + 8, 100, -2130706433);
                }
            }
        }

        @Override
        public void hotbarClick(int hotbarSlot) {
            class_746 player = ((BundleScreen)BundleScreen.this).field_22787.field_1724;
            final class_1703 menu = player.field_7512;
            class_5630 carriedAccess = new class_5630(){

                public class_1799 method_32327() {
                    return menu.method_34255();
                }

                public boolean method_32332(class_1799 p_150452_) {
                    menu.method_34254(p_150452_);
                    return true;
                }
            };
            if (this.index == -1) {
                BundleScreen.this.tinyHotbarClick(TinyClickType.SHIFT, player.field_7498, player, hotbarSlot);
                return;
            }
            int lastSlot = BundleScreen.this.lastSlotIndex();
            if (this.index >= lastSlot) {
                BundleScreen.this.tinyHotbarClick(TinyClickType.I_SHIFT, player.field_7498, player, hotbarSlot);
            } else {
                TinyClickType clickType = TinyClickType.getHotbar(hotbarSlot);
                BundleScreen.this.tinyMenuClick(this.index, clickType, carriedAccess, player);
            }
        }
    }
}

