/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.generic;

import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.network.serverbound.TraitMenuClick;
import com.beansgalaxy.backpacks.screen.TinyClickType;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.backpack.BackpackMutable;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.traits.generic.MutableChestLike;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.apache.commons.lang3.math.Fraction;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class ChestLikeTraits
extends BundleLikeTraits {
    public ChestLikeTraits(ModSound sound, int size) {
        super(sound, size);
    }

    @Override
    public Fraction fullness(ComponentHolder holder) {
        List<class_1799> stacks = holder.get(ITraitData.ITEM_STACKS);
        if (stacks == null) {
            return Fraction.ZERO;
        }
        return Fraction.getFraction((int)stacks.size(), (int)this.size());
    }

    @Override
    public boolean isFull(ComponentHolder holder) {
        List<class_1799> stacks = holder.get(ITraitData.ITEM_STACKS);
        if (stacks == null || stacks.isEmpty() || stacks.size() < this.size()) {
            return false;
        }
        for (class_1799 stack : stacks) {
            int count;
            int maxStackSize = stack.method_7914();
            if (maxStackSize == (count = stack.method_7947())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stackedOnOther(ComponentHolder backpack, class_1799 other, class_1735 slot, class_5536 click, class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        if (!class_5536.field_27014.equals((Object)click)) {
            return;
        }
        MutableBundleLike mutable = this.mutable(backpack);
        ModSound sound = this.sound();
        if (other.method_7960()) {
            class_1799 stack = mutable.removeItem(other, player);
            if (stack.method_7960() || !slot.method_7680(stack)) {
                return;
            }
            slot.method_7673(stack);
            sound.atClient(player, ModSound.Type.REMOVE);
        } else if (slot.method_7674(player)) {
            if (mutable.addItem(other, 0) != null) {
                sound.atClient(player, ModSound.Type.INSERT);
            }
        } else {
            return;
        }
        mutable.push(cir);
    }

    @Override
    public boolean canItemFit(ComponentHolder holder, class_1799 inserted) {
        return !inserted.method_7960() && super.canItemFit(holder, inserted);
    }

    @Override
    public abstract MutableChestLike<?> mutable(ComponentHolder var1);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChestLikeTraits)) {
            return false;
        }
        ChestLikeTraits that = (ChestLikeTraits)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.size() == that.size() && Objects.equals((Object)this.sound(), (Object)that.sound());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.sound(), this.size()});
    }

    @Override
    public void tinyMenuClick(ComponentHolder holder, int index, TinyClickType clickType, class_5630 carriedAccess, class_1657 player) {
        List<class_1799> stacks;
        int add;
        int size;
        class_1799 stack;
        MutableBundleLike mutable = this.mutable(holder);
        if (clickType.isHotbar()) {
            class_1661 inventory = player.method_31548();
            class_1799 hotbarStack = (class_1799)inventory.field_7547.get(clickType.hotbarSlot);
            class_1799 stack2 = mutable.removeItem(index);
            if (!hotbarStack.method_7960()) {
                int add2 = mutable.toAdd(hotbarStack);
                if (add2 < hotbarStack.method_7947()) {
                    return;
                }
                mutable.addItem(hotbarStack, index);
            }
            this.sound().at((class_1297)player, ModSound.Type.REMOVE);
            inventory.field_7547.set(clickType.hotbarSlot, (Object)stack2);
            mutable.push();
            return;
        }
        if (clickType.isShift()) {
            class_1799 hotbar;
            class_1661 inventory = player.method_31548();
            stack = mutable.removeItem(index);
            size = inventory.field_7547.size();
            int i = 9;
            do {
                if (i == size) {
                    i = 0;
                }
                if (class_1799.method_31577((class_1799)stack, (class_1799)(hotbar = (class_1799)inventory.field_7547.get(i)))) {
                    add = Math.min(hotbar.method_7914() - hotbar.method_7947(), stack.method_7947());
                    hotbar.method_7933(add);
                    stack.method_7934(add);
                }
                if (!stack.method_7960()) continue;
                mutable.push();
                this.sound().at((class_1297)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
            do {
                if (i == size) {
                    i = 0;
                }
                if ((hotbar = (class_1799)inventory.field_7547.get(i)).method_7960()) {
                    add = Math.min(stack.method_7914(), stack.method_7947());
                    inventory.field_7547.set(i, (Object)stack.method_46651(add));
                    stack.method_7934(add);
                }
                if (!stack.method_7960()) continue;
                mutable.push();
                this.sound().at((class_1297)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
        }
        if (clickType.isAction()) {
            if (index == -1) {
                return;
            }
            stacks = mutable.stacks.get();
            if (index >= stacks.size()) {
                return;
            }
            stack = stacks.get(index);
            BackpackTraits.runIfEquipped(player, (storageTraits, slot) -> {
                class_1799 backpack = player.method_6118(slot);
                BackpackMutable itemStorage = storageTraits.mutable(ComponentHolder.of(backpack));
                if (this.canItemFit(holder, stack) && itemStorage.addItem(stack) != null) {
                    mutable.push();
                    this.sound().atClient(player, ModSound.Type.INSERT);
                    itemStorage.push();
                }
                return stack.method_7960();
            });
        }
        if (clickType.isDrop()) {
            class_1799 stack3 = mutable.removeItem(index);
            player.method_7328(stack3, true);
            mutable.push();
            return;
        }
        stacks = mutable.getItemStacks();
        class_1799 carried = carriedAccess.method_32327();
        if (index == -1) {
            if (clickType.isRight()) {
                if (mutable.addItem(carried.method_46651(1)) != null) {
                    carried.method_7934(1);
                    mutable.push();
                    this.sound().at((class_1297)player, ModSound.Type.INSERT);
                }
            } else if (mutable.addItem(carried) != null) {
                mutable.push();
                this.sound().at((class_1297)player, ModSound.Type.INSERT);
            }
            return;
        }
        size = stacks.size();
        if (index >= size) {
            if (clickType.isRight()) {
                if (mutable.addItem(carried.method_46651(1), size) != null) {
                    carried.method_7934(1);
                    mutable.push();
                    this.sound().atClient(player, ModSound.Type.INSERT);
                }
            } else if (mutable.addItem(carried, size) != null) {
                mutable.push();
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
            return;
        }
        class_1799 stack4 = stacks.get(index);
        if (stack4.method_7960() && carried.method_7960()) {
            return;
        }
        if (!stack4.method_7960() && !carried.method_7960()) {
            if (class_1799.method_31577((class_1799)stack4, (class_1799)carried)) {
                int toAdd = mutable.toAdd(carried);
                if (toAdd == 0) {
                    return;
                }
                if (clickType.isRight()) {
                    stack4.method_7933(1);
                    carried.method_7934(1);
                } else {
                    add = Math.min(stack4.method_7914() - stack4.method_7947(), toAdd);
                    stack4.method_7933(add);
                    carried.method_7934(add);
                }
                this.sound().atClient(player, ModSound.Type.INSERT);
            } else if (mutable.addItem(carried, index) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
        } else if (clickType.isRight()) {
            int count = class_3532.method_15386((float)((float)stack4.method_7947() / 2.0f));
            class_1799 split = stack4.method_7971(count);
            carriedAccess.method_32332(split);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (carried.method_7960()) {
            class_1799 removed = mutable.removeItem(index);
            carriedAccess.method_32332(removed);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (mutable.addItem(carried, index + 1) != null) {
            this.sound().atClient(player, ModSound.Type.INSERT);
        }
        mutable.push();
    }

    @Override
    public void tinyHotbarClick(ComponentHolder holder, int slotId, TinyClickType clickType, class_1723 menu, class_1657 player) {
        if (TinyClickType.I_SHIFT.equals((Object)clickType)) {
            class_1735 slot = menu.method_7611(slotId);
            class_1799 hotbar = slot.method_7677();
            MutableBundleLike mutable = this.mutable(holder);
            if (mutable.addItem(hotbar, mutable.getItemStacks().size()) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
                mutable.push();
            }
            return;
        }
        super.tinyHotbarClick(holder, slotId, clickType, menu, player);
    }

    @Override
    public void onPlayerInteract(class_1309 owner, class_1657 player, class_1799 backpack, CallbackInfoReturnable<class_1269> cir) {
        cir.setReturnValue((Object)class_1269.field_5812);
    }

    @Override
    public void menuClick(ComponentHolder holder, int index, TraitMenuClick.Kind clickType, class_5630 carriedAccess, class_1657 player) {
        List<class_1799> stacks;
        int size;
        class_1799 stack;
        MutableBundleLike mutable = this.mutable(holder);
        if (clickType.isShift()) {
            int add;
            class_1799 hotbar;
            class_1661 inventory = player.method_31548();
            stack = mutable.removeItem(index);
            size = inventory.field_7547.size();
            int i = 9;
            do {
                if (i == size) {
                    i = 0;
                }
                if (class_1799.method_31577((class_1799)stack, (class_1799)(hotbar = (class_1799)inventory.field_7547.get(i)))) {
                    add = Math.min(hotbar.method_7914() - hotbar.method_7947(), stack.method_7947());
                    hotbar.method_7933(add);
                    stack.method_7934(add);
                }
                if (!stack.method_7960()) continue;
                mutable.push();
                this.sound().at((class_1297)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
            do {
                if (i == size) {
                    i = 0;
                }
                if ((hotbar = (class_1799)inventory.field_7547.get(i)).method_7960()) {
                    add = Math.min(stack.method_7914(), stack.method_7947());
                    inventory.field_7547.set(i, (Object)stack.method_46651(add));
                    stack.method_7934(add);
                }
                if (!stack.method_7960()) continue;
                mutable.push();
                this.sound().at((class_1297)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
        }
        if (clickType.isAction()) {
            if (index == -1) {
                return;
            }
            stacks = mutable.stacks.get();
            if (index >= stacks.size()) {
                return;
            }
            stack = stacks.get(index);
            BackpackTraits.runIfEquipped(player, (storageTraits, slot) -> {
                class_1799 backpack = player.method_6118(slot);
                BackpackMutable itemStorage = storageTraits.mutable(ComponentHolder.of(backpack));
                if (this.canItemFit(holder, stack) && itemStorage.addItem(stack) != null) {
                    mutable.push();
                    this.sound().atClient(player, ModSound.Type.INSERT);
                    itemStorage.push();
                }
                return stack.method_7960();
            });
        }
        if (clickType.isDrop()) {
            BackData backData = BackData.get(player);
            if (backData.isMenuKeyDown()) {
                stack = mutable.removeItem(index);
            } else {
                class_1799 item = mutable.getItemStacks().get(index);
                stack = item.method_46651(1);
                item.method_7934(1);
            }
            player.method_7328(stack, true);
            mutable.push();
            return;
        }
        stacks = mutable.getItemStacks();
        class_1799 carried = carriedAccess.method_32327();
        size = stacks.size();
        if (index >= size) {
            if (clickType.isRight()) {
                if (mutable.addItem(carried.method_46651(1), size) != null) {
                    carried.method_7934(1);
                    mutable.push();
                    this.sound().atClient(player, ModSound.Type.INSERT);
                }
            } else if (mutable.addItem(carried, size) != null) {
                mutable.push();
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
            return;
        }
        class_1799 stack2 = stacks.get(index);
        if (stack2.method_7960() && carried.method_7960()) {
            return;
        }
        if (!stack2.method_7960() && !carried.method_7960()) {
            if (class_1799.method_31577((class_1799)stack2, (class_1799)carried)) {
                int toAdd = mutable.toAdd(carried);
                if (toAdd == 0) {
                    return;
                }
                if (clickType.isRight()) {
                    stack2.method_7933(1);
                    carried.method_7934(1);
                } else {
                    stack2.method_7933(toAdd);
                    carried.method_7934(toAdd);
                }
                this.sound().atClient(player, ModSound.Type.INSERT);
            } else if (clickType.isRight()) {
                if (mutable.addItem(carried.method_46651(1), index) != null) {
                    carried.method_7934(1);
                    this.sound().atClient(player, ModSound.Type.INSERT);
                }
            } else if (mutable.addItem(carried, index) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
        } else if (clickType.isRight()) {
            int count = class_3532.method_15386((float)((float)Math.min(stack2.method_7914(), stack2.method_7947()) / 2.0f));
            class_1799 split = stack2.method_7971(count);
            carriedAccess.method_32332(split);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (carried.method_7960()) {
            class_1799 removed = mutable.removeItem(index);
            carriedAccess.method_32332(removed);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (mutable.addItem(carried, index + 1) != null) {
            this.sound().atClient(player, ModSound.Type.INSERT);
        }
        mutable.push();
    }
}

