/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.generic;

import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableItemStorage;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.apache.commons.lang3.math.Fraction;

public class MutableBundleLike<T extends BundleLikeTraits>
implements MutableItemStorage {
    public final ITraitData<List<class_1799>> stacks;
    protected final ComponentHolder holder;
    protected final T traits;

    public MutableBundleLike(T traits, ComponentHolder holder) {
        this.holder = holder;
        this.traits = traits;
        this.stacks = ITraitData.ITEM_STACKS.get(holder);
    }

    public List<class_1799> getItemStacks() {
        return this.stacks.get();
    }

    @Override
    public ModSound sound() {
        return ((GenericTraits)this.traits).sound();
    }

    @Override
    public void push() {
        this.stacks.push();
        this.holder.setChanged();
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    public class_1799 removeItem(int slot) {
        if (slot < 0) {
            return class_1799.field_8037;
        }
        class_1799 returned = class_1799.field_8037;
        List<class_1799> stacks = this.getItemStacks();
        if (stacks.size() > slot) {
            class_1799 stack = stacks.get(slot);
            int maxCount = stack.method_7914();
            if (stack.method_7947() > maxCount) {
                stack.method_7934(maxCount);
                returned = stack.method_46651(maxCount);
            } else {
                returned = stacks.remove(slot);
                this.limitSelectedSlot(slot);
            }
        }
        return returned;
    }

    @Override
    public void moveItemsTo(MutableItemStorage to, class_1657 player, boolean fullStack) {
        int selectedSlot = this.getSelectedSlot(player);
        class_1799 stack = this.getItemStacks().get(selectedSlot);
        int toAdd = to.getMaxAmountToAdd(stack);
        if (toAdd > 0) {
            class_1799 moved;
            if (!fullStack) {
                moved = stack.method_46651(1);
                stack.method_7934(1);
            } else {
                int count = stack.method_7947();
                if (count < toAdd) {
                    int min = Math.min(count, toAdd);
                    moved = stack.method_46651(min);
                    stack.method_7934(min);
                } else {
                    moved = this.removeItem(selectedSlot);
                }
            }
            to.addItem(moved);
            this.push();
            to.push();
            this.sound().at((class_1297)player, ModSound.Type.REMOVE);
        }
    }

    @Override
    public class_1799 addItem(class_1799 inserted) {
        if (!((BundleLikeTraits)this.traits).canItemFit(this.holder, inserted)) {
            return null;
        }
        int spaceLeft = this.getMaxAmountToAdd(inserted);
        int toInsert = Math.min(inserted.method_7947(), spaceLeft);
        if (toInsert == 0) {
            return null;
        }
        List<class_1799> stacks = this.getItemStacks();
        int i = stacks.size();
        while (i > 0) {
            class_1799 stored = stacks.get(--i);
            if (inserted.method_7960() || toInsert < 1) {
                return class_1799.field_8037;
            }
            if (!class_1799.method_31577((class_1799)stored, (class_1799)inserted)) continue;
            stored.method_7933(toInsert);
            inserted.method_7934(toInsert);
            return class_1799.field_8037;
        }
        if (!inserted.method_7960()) {
            class_1799 split = inserted.method_7971(toInsert);
            this.getItemStacks().addFirst(split);
            this.growSelectedSlot(0);
        }
        return inserted;
    }

    public class_1799 addItem(class_1799 inserted, int slot) {
        if (!((BundleLikeTraits)this.traits).canItemFit(this.holder, inserted)) {
            return null;
        }
        int spaceLeft = this.getMaxAmountToAdd(inserted);
        int toInsert = Math.min(inserted.method_7947(), spaceLeft);
        if (toInsert == 0) {
            return null;
        }
        List<class_1799> stacks = this.getItemStacks();
        int i = stacks.size();
        while (i > 0) {
            class_1799 stored = stacks.get(--i);
            if (inserted.method_7960() || toInsert < 1) {
                return class_1799.field_8037;
            }
            if (!class_1799.method_31577((class_1799)stored, (class_1799)inserted)) continue;
            class_1799 removed = stacks.remove(i);
            int size = stacks.size();
            stacks.add(Math.min(slot, size), removed);
            removed.method_7933(toInsert);
            inserted.method_7934(toInsert);
            return class_1799.field_8037;
        }
        if (!inserted.method_7960()) {
            int selectedSlot = Math.min(slot, this.getItemStacks().size());
            class_1799 split = inserted.method_7971(toInsert);
            this.getItemStacks().add(selectedSlot, split);
            this.growSelectedSlot(selectedSlot);
        }
        return inserted;
    }

    @Override
    public int getMaxAmountToAdd(class_1799 stack) {
        Fraction size = Fraction.getFraction((int)((BundleLikeTraits)this.traits).size(), (int)1);
        Fraction weight = Traits.getWeight(this.getItemStacks());
        Fraction weightLeft = size.subtract(weight);
        return Math.max(weightLeft.divideBy(Traits.getItemWeight(stack)).intValue(), 0);
    }

    public class_1799 removeItem(class_1799 other, class_1657 player) {
        return this.removeItem(0);
    }

    public int getSelectedSlot(class_1657 player) {
        return 0;
    }

    public void growSelectedSlot(int slot) {
    }

    @Override
    public Fraction fullness() {
        List<class_1799> stacks = this.stacks.get();
        if (stacks == null) {
            return Fraction.ZERO;
        }
        return Traits.getWeight(stacks, ((BundleLikeTraits)this.traits).size());
    }

    public int toAdd(class_1799 carried) {
        if (!((BundleLikeTraits)this.traits).canItemFit(this.holder, carried)) {
            return 0;
        }
        int spaceLeft = this.getMaxAmountToAdd(carried);
        return Math.min(carried.method_7947(), spaceLeft);
    }

    public void limitSelectedSlot(int index) {
    }
}

