/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.generic;

import com.beansgalaxy.backpacks.traits.generic.ChestLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.traits.generic.MutableItemStorage;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.apache.commons.lang3.math.Fraction;

public class MutableChestLike<T extends ChestLikeTraits>
extends MutableBundleLike<T> {
    public MutableChestLike(T traits, ComponentHolder holder) {
        super(traits, holder);
    }

    @Override
    public List<class_1799> getItemStacks() {
        return (List)this.stacks.get();
    }

    @Override
    public ModSound sound() {
        return ((ChestLikeTraits)this.traits).sound();
    }

    @Override
    public void push() {
        this.stacks.push();
        this.holder.setChanged();
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    public class_1799 removeItem(int slot) {
        if (slot < 0) {
            return class_1799.field_8037;
        }
        class_1799 returned = class_1799.field_8037;
        List<class_1799> stacks = this.getItemStacks();
        if (stacks.size() > slot) {
            class_1799 stack = stacks.get(slot);
            int maxCount = stack.method_7914();
            if (stack.method_7947() > maxCount) {
                stack.method_7934(maxCount);
                returned = stack.method_46651(maxCount);
            } else {
                returned = stacks.remove(slot);
                this.limitSelectedSlot(slot);
            }
        }
        return returned;
    }

    @Override
    public void moveItemsTo(MutableItemStorage to, class_1657 player, boolean fullStack) {
        int selectedSlot = this.getSelectedSlot(player);
        class_1799 stack = this.getItemStacks().get(selectedSlot);
        int toAdd = to.getMaxAmountToAdd(stack);
        if (toAdd > 0) {
            class_1799 moved;
            if (!fullStack) {
                moved = stack.method_46651(1);
                stack.method_7934(1);
            } else {
                int count = stack.method_7947();
                if (count < toAdd) {
                    moved = stack.method_46651(count);
                    stack.method_7934(count);
                } else {
                    moved = this.removeItem(selectedSlot);
                }
            }
            to.addItem(moved);
            this.push();
            to.push();
            this.sound().at((class_1297)player, ModSound.Type.REMOVE);
        }
    }

    @Override
    public class_1799 addItem(class_1799 inserted) {
        if (!((ChestLikeTraits)this.traits).canItemFit(this.holder, inserted)) {
            return null;
        }
        int spaceLeft = this.getMaxAmountToAdd(inserted);
        int toInsert = Math.min(inserted.method_7947(), spaceLeft);
        if (toInsert == 0) {
            return null;
        }
        List<class_1799> stacks = this.getItemStacks();
        int i = stacks.size();
        while (i > 0) {
            class_1799 stored = stacks.get(--i);
            if (inserted.method_7960() || toInsert < 1) {
                return class_1799.field_8037;
            }
            if (!class_1799.method_31577((class_1799)stored, (class_1799)inserted)) continue;
            int count = Math.min(toInsert, stored.method_7914() - stored.method_7947());
            stored.method_7933(count);
            inserted.method_7934(count);
            toInsert -= count;
        }
        if (!inserted.method_7960()) {
            class_1799 split = inserted.method_7971(toInsert);
            this.getItemStacks().addFirst(split);
            this.growSelectedSlot(0);
        }
        return inserted;
    }

    @Override
    public class_1799 addItem(class_1799 inserted, int slot) {
        if (!((ChestLikeTraits)this.traits).canItemFit(this.holder, inserted)) {
            return null;
        }
        int spaceLeft = this.getMaxAmountToAdd(inserted);
        int toInsert = Math.min(inserted.method_7947(), spaceLeft);
        if (toInsert == 0) {
            return null;
        }
        List<class_1799> stacks = this.getItemStacks();
        int i = stacks.size();
        while (i > 0) {
            int maxStackSize;
            class_1799 stored = stacks.get(--i);
            if (inserted.method_7960() || toInsert < 1) {
                return class_1799.field_8037;
            }
            if (!class_1799.method_31577((class_1799)stored, (class_1799)inserted)) continue;
            int totalCount = stored.method_7947() + toInsert;
            if (totalCount > (maxStackSize = stored.method_7914())) {
                int count = totalCount - maxStackSize;
                class_1799 removed = stored.method_46651(count);
                stored.method_7939(maxStackSize);
                int selectedSlot = Math.min(slot, stacks.size());
                stacks.add(selectedSlot, removed);
                inserted.method_7934(toInsert);
                this.growSelectedSlot(selectedSlot);
                continue;
            }
            class_1799 removed = stacks.remove(i);
            int size = stacks.size();
            stacks.add(Math.min(slot, size), removed);
            removed.method_7933(toInsert);
            inserted.method_7934(toInsert);
        }
        if (!inserted.method_7960()) {
            int selectedSlot = Math.min(slot, this.getItemStacks().size());
            class_1799 split = inserted.method_7971(toInsert);
            this.getItemStacks().add(selectedSlot, split);
            this.growSelectedSlot(selectedSlot);
        }
        return inserted;
    }

    @Override
    public int getMaxAmountToAdd(class_1799 inserted) {
        List<class_1799> stacks = this.getItemStacks();
        int remainingStacks = ((ChestLikeTraits)this.traits).size() - stacks.size();
        if (remainingStacks > 0) {
            return inserted.method_7914() * remainingStacks;
        }
        int toAdd = 0;
        for (class_1799 stored : stacks) {
            if (!class_1799.method_31577((class_1799)stored, (class_1799)inserted)) continue;
            toAdd += inserted.method_7914() - inserted.method_7947();
        }
        return toAdd;
    }

    @Override
    public class_1799 removeItem(class_1799 other, class_1657 player) {
        return this.removeItem(0);
    }

    @Override
    public int getSelectedSlot(class_1657 player) {
        return 0;
    }

    @Override
    public void growSelectedSlot(int slot) {
    }

    @Override
    public Fraction fullness() {
        List stacks = (List)this.stacks.get();
        if (stacks == null) {
            return Fraction.ZERO;
        }
        return Fraction.getFraction((int)stacks.size(), (int)((ChestLikeTraits)this.traits).size());
    }
}

