/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.lunch_box;

import com.beansgalaxy.backpacks.network.serverbound.TinyMenuInteract;
import com.beansgalaxy.backpacks.screen.BackpackScreen;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.bundle.BundleScreen;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8002;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;

public class LunchBoxScreen
extends BundleScreen {
    boolean hoverNonEdible = false;

    public static void openScreen(ViewableBackpack backpack, BundleLikeTraits traits, class_1657 player) {
        LunchBoxScreen screen = new LunchBoxScreen(backpack, traits, player);
        class_310 minecraft = class_310.method_1551();
        minecraft.method_1507((class_437)screen);
        backpack.onOpen((class_1657)minecraft.field_1724);
        TinyMenuInteract.send(backpack.getId(), true);
    }

    protected LunchBoxScreen(ViewableBackpack backpack, BundleLikeTraits traits, class_1657 player) {
        super(player, backpack, traits);
    }

    @Override
    protected void repopulateSlots(@NotNull class_332 gui, int pMouseX, int pMouseY, float pPartialTick) {
        int size;
        int stacksSize;
        boolean hasSpace;
        class_1799 carried = this.getCarried();
        List<class_1799> stacks = this.backpack.get(ITraitData.ITEM_STACKS);
        List<class_1799> nonEdibles = this.backpack.get(ITraitData.NON_EDIBLES);
        boolean carriedEmpty = carried.method_7960();
        if (stacks == null) {
            hasSpace = true;
            stacksSize = 1;
            size = 1;
        } else {
            hasSpace = this.traits.fullness(stacks).compareTo(Fraction.ONE) != 0;
            stacksSize = stacks.size();
            size = stacksSize + (hasSpace ? 1 : 0) + (carriedEmpty ? 0 : 1);
        }
        int guiScaledWidth = this.field_22787.method_22683().method_4486();
        int maxWidth = guiScaledWidth / 2 - 126;
        int nonEdibleSize = nonEdibles == null ? 0 : nonEdibles.size();
        boolean forCol = false;
        int columns = Math.min(size + nonEdibleSize, 4);
        int rows = 1;
        for (int i = columns; i <= size + nonEdibleSize; ++i) {
            if (i <= columns * rows) continue;
            if (forCol && maxWidth > 0) {
                ++columns;
                maxWidth -= 18;
            } else {
                ++rows;
            }
            forCol = !forCol;
        }
        this.clearSlots();
        this.hoverNonEdible = false;
        boolean hoverOverAny = false;
        int width = columns * 18;
        int left = this.field_2776 - 18 - width;
        int top = this.traitTop() - 11 - (rows - 1) / 2 * 10;
        int i = hasSpace ? -1 : 0;
        boolean shouldHoverNonEdibles = nonEdibles != null && carriedEmpty;
        class_5250 title = class_2561.method_43473();
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                boolean mouseOver;
                BundleScreen.BundleTraitSlot slot;
                int nonEdiblesStart = size - 1;
                if (i < nonEdiblesStart) {
                    slot = new LunchBoxSlot(left + x * 18, top + y * 18, i, shouldHoverNonEdibles);
                    if (i == stacksSize) {
                        this.lastSlot = slot;
                    }
                } else {
                    int index = i - nonEdiblesStart;
                    BundleScreen.BundleTraitSlot bundleTraitSlot = slot = index == 0 ? new StartNonEdibles(left + x * 18, top + y * 18, index, shouldHoverNonEdibles, carriedEmpty) : new NonEdiblesSlot(left + x * 18, top + y * 18, index);
                }
                if (mouseOver = slot.method_25405(pMouseX, pMouseY)) {
                    hoverOverAny = true;
                }
                if (!shouldHoverNonEdibles && mouseOver) {
                    List tooltipFromItem = class_437.method_25408((class_310)this.field_22787, (class_1799)slot.getItem());
                    title = (class_2561)tooltipFromItem.getFirst();
                }
                this.addSlot(slot);
                ++i;
            }
        }
        if (hoverOverAny && shouldHoverNonEdibles) {
            List tooltipFromItem = class_437.method_25408((class_310)this.field_22787, (class_1799)nonEdibles.get(0));
            title = (class_2561)tooltipFromItem.getFirst();
        }
        int fontWidth = this.field_22793.method_27525((class_5348)title);
        int fontHeight = 9;
        class_4587 pose = gui.method_51448();
        pose.method_22903();
        pose.method_46416(0.0f, 0.0f, 100.0f);
        if (fontWidth > width) {
            int height;
            List split = this.field_22793.method_1728((class_5348)title, width);
            int splitRow = height = split.size() * 9;
            for (class_5481 sequence : split) {
                gui.method_35720(this.field_22787.field_1772, sequence, left + 1, top - splitRow, -1);
                splitRow -= 9;
            }
            fontHeight = height;
        } else {
            gui.method_27535(this.field_22787.field_1772, (class_2561)title, left + 1, top - 9, -1);
        }
        pose.method_22909();
        this.traitX = left + width;
        this.traitY = top - fontHeight;
        this.traitW = width;
        this.traitH = rows * 18 + fontHeight;
        class_8002.method_47946((class_332)gui, (int)left, (int)(top - 1 - fontHeight), (int)width, (int)(rows * 18 + 2 + fontHeight), (int)1);
        for (BackpackScreen.TraitSlot slot : this.slots) {
            slot.method_25394(gui, pMouseX, pMouseY, pPartialTick);
        }
    }

    private class LunchBoxSlot
    extends BundleScreen.BundleTraitSlot {
        private final boolean shouldHoverNonEdibles;

        public LunchBoxSlot(int pX, int pY, int index, boolean shouldHoverNonEdibles) {
            super(pX, pY, index);
            this.shouldHoverNonEdibles = shouldHoverNonEdibles;
        }

        public boolean method_49606() {
            boolean hovered = super.method_49606();
            if (this.shouldHoverNonEdibles && hovered) {
                LunchBoxScreen.this.hoverNonEdible = true;
            }
            return hovered && !this.shouldHoverNonEdibles;
        }
    }

    private class StartNonEdibles
    extends NonEdiblesSlot {
        private final boolean shouldHoverNonEdibles;
        private final boolean carriedEmpty;

        public StartNonEdibles(int pX, int pY, int index, boolean shouldHoverNonEdibles, boolean carriedEmpty) {
            super(pX, pY, index);
            this.shouldHoverNonEdibles = shouldHoverNonEdibles;
            this.carriedEmpty = carriedEmpty;
        }

        public boolean method_49606() {
            return this.shouldHoverNonEdibles ? LunchBoxScreen.this.hoverNonEdible || super.method_49606() : this.carriedEmpty && super.method_49606();
        }

        @Override
        protected void method_48579(class_332 gui, int i, int i1, float v) {
            if (this.field_22762 && !this.shouldHoverNonEdibles && !this.carriedEmpty && LunchBoxScreen.this.lastSlot != null) {
                int x1 = LunchBoxScreen.this.lastSlot.method_46426() + 9;
                int y1 = LunchBoxScreen.this.lastSlot.method_46427() + 9;
                gui.method_51737(x1 - 8, y1 - 8, x1 + 8, y1 + 8, 100, -1996488705);
            }
            super.method_48579(gui, i, i1, v);
        }
    }

    private class NonEdiblesSlot
    extends BundleScreen.BundleTraitSlot {
        public NonEdiblesSlot(int pX, int pY, int index) {
            super(pX, pY, index);
        }

        @Override
        public class_1799 getItem() {
            List<class_1799> stacks = LunchBoxScreen.this.backpack.get(ITraitData.NON_EDIBLES);
            if (stacks == null || this.index == -1) {
                return class_1799.field_8037;
            }
            return this.index < stacks.size() ? stacks.get(this.index) : class_1799.field_8037;
        }
    }
}

