/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util;

import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ComponentHolder {
    public static ComponentHolder of(class_1735 slot) {
        return new SlotTraitHolder(slot);
    }

    public static ComponentHolder of(class_1799 stack) {
        return new ItemStackTraitHolder(stack);
    }

    public static ComponentHolder of(class_1799 stack, class_1657 player) {
        return new StackReturningTraitHolder(stack, player);
    }

    @Nullable
    public <T> T remove(class_9331<? extends T> var1);

    public <T> void set(class_9331<? super T> var1, T var2);

    @Nullable
    public <T> T get(class_9331<? extends T> var1);

    default public boolean has(class_9331<?> type) {
        return this.get(type) != null;
    }

    default public void setChanged() {
    }

    @NotNull
    default public <T> T getOrElse(class_9331<? extends T> type, Supplier<T> orElse) {
        T t = this.get(type);
        return t == null ? orElse.get() : t;
    }

    default public <T> T getOrDefault(class_9331<T> type, T defau) {
        T t = this.get(type);
        if (t == null) {
            return defau;
        }
        return t;
    }

    public static class SlotTraitHolder
    implements ComponentHolder {
        private final class_1735 slot;

        public SlotTraitHolder(class_1735 slot) {
            this.slot = slot;
        }

        @Override
        @Nullable
        public <T> T remove(class_9331<? extends T> type) {
            return (T)this.slot.method_7677().method_57381(type);
        }

        @Override
        public <T> void set(class_9331<? super T> type, T trait) {
            this.slot.method_7677().method_57379(type, trait);
        }

        @Override
        @Nullable
        public <T> T get(class_9331<? extends T> type) {
            return (T)this.slot.method_7677().method_57824(type);
        }
    }

    public static class ItemStackTraitHolder
    implements ComponentHolder {
        private final class_1799 stack;

        private ItemStackTraitHolder(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        @Nullable
        public <T> T remove(class_9331<? extends T> type) {
            return (T)this.stack.method_57381(type);
        }

        @Override
        public <T> void set(class_9331<? super T> type, T trait) {
            this.stack.method_57379(type, trait);
        }

        @Override
        public <T> T get(class_9331<? extends T> type) {
            return (T)this.stack.method_57824(type);
        }
    }

    public static class StackReturningTraitHolder
    implements ComponentHolder {
        private final class_1799 stack;
        private final class_1657 player;

        public StackReturningTraitHolder(class_1799 stack, class_1657 player) {
            this.stack = stack;
            this.player = player;
        }

        @Override
        @Nullable
        public <T> T remove(class_9331<? extends T> type) {
            int count = this.stack.method_7947();
            if (count > 1) {
                class_1799 copy = this.stack.method_46651(1);
                Object remove = copy.method_57381(type);
                if (remove == null) {
                    return null;
                }
                this.player.method_7270(copy);
                this.stack.method_7934(1);
                return (T)remove;
            }
            return (T)this.stack.method_57381(type);
        }

        @Override
        public <T> void set(class_9331<? super T> type, T data) {
            int count = this.stack.method_7947();
            if (count > 1) {
                class_1799 copy = this.stack.method_46651(1);
                copy.method_57379(type, data);
                this.player.method_7270(copy);
                this.stack.method_7934(1);
            } else {
                this.stack.method_57379(type, data);
            }
        }

        @Override
        public <T> T get(class_9331<? extends T> pComponent) {
            return (T)this.stack.method_57824(pComponent);
        }
    }
}

