/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util;

import com.beansgalaxy.backpacks.components.equipable.EquipmentModel;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2960;

public class OptionalEitherMapCodec<L, R>
extends MapCodec<Optional<Either<L, R>>> {
    private static final String MODEL = "equipment_model";
    private static final String TEXTURE = "backpack_texture";
    private static final MapCodec<Either<EquipmentModel, class_2960>> EITHER = Codec.mapEither((MapCodec)EquipmentModel.CODEC.fieldOf("equipment_model"), (MapCodec)class_2960.field_25139.fieldOf("backpack_texture"));
    private final MapCodec<Either<L, R>> either;
    private final String leftKey;
    private final String rightKey;

    public OptionalEitherMapCodec(String leftKey, Codec<L> left, String rightKey, Codec<R> right) {
        this.leftKey = leftKey;
        this.rightKey = rightKey;
        this.either = Codec.mapEither((MapCodec)left.fieldOf(leftKey), (MapCodec)right.fieldOf(rightKey));
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return this.either.keys(ops);
    }

    public <T> DataResult<Optional<Either<L, R>>> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object model = input.get(this.leftKey);
        Object texture = input.get(this.rightKey);
        if (model == null && texture == null) {
            return DataResult.success(Optional.empty());
        }
        DataResult decode = this.either.decode(ops, input);
        return decode.map(Optional::of).setPartial(Optional::empty);
    }

    public <T> RecordBuilder<T> encode(Optional<Either<L, R>> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        if (input.isPresent()) {
            return this.either.encode(input.get(), ops, prefix);
        }
        return prefix;
    }
}

