/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_5481;

public class SplitText {
    private final class_5481 sequence;
    private final List<class_5481> lines = new ArrayList<class_5481>();
    private ImmutableList.Builder<Sink> current = ImmutableList.builder();
    class_5481 SPACE = class_5481.method_30747((String)" ", (class_2583)class_2583.field_24360);

    public SplitText(class_5481 sequence) {
        this.sequence = sequence;
    }

    public List<class_5481> split() {
        this.sequence.accept((pPositionInCurrentSequence, pStyle, pCodePoint) -> {
            if (Character.isWhitespace(pCodePoint)) {
                this.dump();
            } else {
                this.current.add((Object)new Sink(pStyle, pCodePoint));
            }
            return true;
        });
        this.buildCurrent(this.lines::add);
        return this.lines;
    }

    private void dump() {
        this.buildCurrent(this.lines::add);
        this.current = ImmutableList.builder();
    }

    private void buildCurrent(Consumer<class_5481> addText) {
        ImmutableList build = this.current.build();
        if (build.isEmpty() || this.onlyWhiteSpace((ImmutableList<Sink>)build)) {
            return;
        }
        class_5481 formatted = charSink -> {
            for (int i = 0; i < build.size(); ++i) {
                Sink sink = (Sink)build.get(i);
                if (charSink.accept(i, sink.style, sink.code)) continue;
                return false;
            }
            return true;
        };
        addText.accept(formatted);
    }

    private boolean onlyWhiteSpace(ImmutableList<Sink> build) {
        for (Sink sink : build) {
            if (Character.isWhitespace(sink.code)) continue;
            return false;
        }
        return true;
    }

    public int noCropWidth(class_327 font, int width, List<class_5481> list) {
        if (this.lines.isEmpty()) {
            return width;
        }
        int size = this.lines.size();
        if (size > 2) {
            return this.smartArrange(font, width, list);
        }
        class_5481 sequence = size == 1 ? this.lines.getFirst() : class_5481.method_34909((class_5481[])new class_5481[]{this.lines.get(0), this.SPACE, this.lines.get(1)});
        list.add(sequence);
        int fWidth = font.method_30880(sequence);
        return Math.max(fWidth, width);
    }

    private int simpleArrange(class_327 font, int width, List<class_5481> list) {
        class_5481 currentLine = this.lines.getFirst();
        for (int i = 1; i < this.lines.size(); ++i) {
            class_5481 line = this.lines.get(i);
            class_5481[] class_5481Array = new class_5481[]{currentLine, this.SPACE, line};
            class_5481 pair = class_5481.method_34909((class_5481[])class_5481Array);
            int pairWidth = font.method_30880(pair);
            if ((double)pairWidth > (double)width * 1.2) {
                int currentWidth = font.method_30880(currentLine);
                if (currentWidth > width) {
                    width = currentWidth;
                }
                list.add(currentLine);
                currentLine = line;
                continue;
            }
            currentLine = pair;
        }
        int currentWidth = font.method_30880(currentLine);
        if (currentWidth > width) {
            width = currentWidth;
        }
        list.add(currentLine);
        return width;
    }

    private int smartArrange(class_327 font, int width, List<class_5481> list) {
        int max = this.lines.stream().mapToInt(arg_0 -> ((class_327)font).method_30880(arg_0)).max().orElse(0);
        int newWidth = Math.max(width, max);
        int sWidth = font.method_30880(this.SPACE) / 2;
        Iterator iterator = Lists.reverse(this.lines).iterator();
        ArrayList aggressive = Lists.newArrayList((Object[])new class_5481[]{(class_5481)iterator.next()});
        class_5481 current = (class_5481)iterator.next();
        class_5481 next = (class_5481)iterator.next();
        while (!class_5481.field_26385.equals((Object)current)) {
            class_5481 pair;
            int c;
            int nWidth = font.method_30880(next);
            int cWidth = font.method_30880(current);
            int lWidth = font.method_30880((class_5481)aggressive.getFirst());
            int nextWidth = nWidth + sWidth + cWidth;
            int lastWidth = lWidth + sWidth + cWidth;
            int target = (nextWidth + lastWidth + cWidth + newWidth) / 4;
            int n = Math.abs(nextWidth - target);
            int l = Math.abs(lastWidth - target) - 7;
            int min = Math.min(l, Math.min(c = Math.abs(cWidth - target), n));
            if (min == l) {
                pair = class_5481.method_34909((class_5481[])new class_5481[]{current, this.SPACE, (class_5481)aggressive.getFirst()});
                aggressive.set(0, pair);
                current = next;
                next = iterator.hasNext() ? (class_5481)iterator.next() : class_5481.field_26385;
                continue;
            }
            if (min == n) {
                if (class_5481.field_26385.equals((Object)next)) {
                    aggressive.add(current);
                    break;
                }
                pair = class_5481.method_34909((class_5481[])new class_5481[]{next, this.SPACE, current});
                aggressive.add(pair);
                if (!iterator.hasNext()) break;
                current = (class_5481)iterator.next();
                next = iterator.hasNext() ? (class_5481)iterator.next() : class_5481.field_26385;
                continue;
            }
            aggressive.set(0, current);
            current = next;
            next = iterator.hasNext() ? (class_5481)iterator.next() : class_5481.field_26385;
        }
        int maxWidth = newWidth;
        for (int i = aggressive.size() - 1; i >= 0; --i) {
            class_5481 sequence = (class_5481)aggressive.get(i);
            int seqWidth = font.method_30880(sequence);
            if (seqWidth > maxWidth) {
                maxWidth = seqWidth;
            }
            list.add(sequence);
        }
        return maxWidth;
    }

    private int aggressiveArrange(class_327 font, int width, List<class_5481> list) {
        int i;
        int max = this.lines.stream().mapToInt(arg_0 -> ((class_327)font).method_30880(arg_0)).max().orElse(0);
        int newWidth = Math.max(width, max);
        ArrayList<class_5481> aggressive = new ArrayList<class_5481>();
        class_5481 currentLine = this.lines.getLast();
        for (i = this.lines.size() - 2; i >= 0; --i) {
            class_5481 line = this.lines.get(i);
            class_5481 pair = class_5481.method_34909((class_5481[])new class_5481[]{line, this.SPACE, currentLine});
            int pairWidth = font.method_30880(pair);
            if (pairWidth < newWidth) {
                currentLine = pair;
                continue;
            }
            newWidth = pairWidth;
            aggressive.add(pair);
            if (--i < 0) {
                currentLine = null;
                break;
            }
            currentLine = this.lines.get(i);
        }
        if (currentLine != null) {
            int currentWidth = font.method_30880(currentLine);
            if (currentWidth > newWidth) {
                newWidth = currentWidth;
            }
            aggressive.add(currentLine);
        }
        for (i = aggressive.size() - 1; i >= 0; --i) {
            list.add((class_5481)aggressive.get(i));
        }
        return newWidth;
    }

    private record Sink(class_2583 style, int code) {
    }
}

