/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util;

import com.beansgalaxy.backpacks.access.ViewableAccessor;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import java.util.HashSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ViewableBackpack
implements ComponentHolder {
    private final HashSet<class_1657> viewers = new HashSet();
    public float headPitch = 0.0f;
    public float lastPitch = 0.0f;
    public float velocity = 0.0f;
    public float lastDelta = 0.0f;
    public int wobble = 8;

    @Nullable
    public static ViewableBackpack get(class_1309 livingEntity) {
        if (livingEntity instanceof ViewableAccessor) {
            ViewableAccessor access = (ViewableAccessor)livingEntity;
            return access.beans_Backpacks_3$getViewable();
        }
        return null;
    }

    public static ViewableBackpack get(BackpackEntity backpack) {
        return backpack.viewable;
    }

    public void onOpen(class_1657 player) {
        if (!player.method_37908().field_9236) {
            this.viewers.add(player);
            int size = this.viewers.size();
            if (size == 1) {
                this.setOpen(true);
                this.playSound(ModSound.Type.OPEN);
            }
        }
    }

    public void onClose(class_1657 player) {
        this.viewers.remove(player);
        int size = this.viewers.size();
        if (size == 0) {
            this.setOpen(false);
            this.playSound(ModSound.Type.CLOSE);
        }
    }

    public void updateOpen() {
        float impulse = 22.0f;
        float resonance = 9.0f;
        float height = 18.0f;
        float closing = 20.0f;
        this.velocity = this.isOpen() ? (this.headPitch == 0.0f ? impulse : (this.velocity += this.lastPitch * resonance + height)) : (this.velocity > 0.0f ? (this.headPitch == 0.0f ? this.velocity * 0.5f - 0.2f : 0.0f) : (this.velocity - 0.1f) * closing);
        float resistance = 0.3f;
        this.velocity *= resistance;
        float newPitch = this.headPitch - this.velocity * 0.1f;
        if (newPitch > 0.0f) {
            newPitch = 0.0f;
        }
        this.lastPitch = this.headPitch;
        this.headPitch = newPitch;
    }

    public float fallDistance() {
        return 0.0f;
    }

    @Override
    @Nullable
    public <T> T remove(class_9331<? extends T> type) {
        return this.holder().remove(type);
    }

    @Override
    public <T> void set(class_9331<? super T> type, T trait) {
        this.holder().set(type, trait);
    }

    @Override
    @Nullable
    public <T> T get(class_9331<? extends T> type) {
        return this.holder().get(type);
    }

    public abstract void setOpen(boolean var1);

    public abstract boolean isOpen();

    public abstract void playSound(ModSound.Type var1);

    @NotNull
    public abstract class_1297 entity();

    public int getId() {
        return this.entity().method_5628();
    }

    protected abstract ComponentHolder holder();

    public abstract class_1799 toStack();

    public abstract boolean shouldClose();
}

