/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.client.gui;

import io.enderdev.alchemistry.Alchemistry;
import io.enderdev.alchemistry.client.container.ContainerEvaporator;
import io.enderdev.alchemistry.client.gui.GuiBase;
import io.enderdev.alchemistry.client.gui.misc.GuiModifiers;
import io.enderdev.alchemistry.client.gui.wrappers.CapabilityFluidDisplayWrapper;
import io.enderdev.alchemistry.tiles.AbstractMachine;
import io.enderdev.alchemistry.tiles.TileEvaporator;
import io.enderdev.alchemistry.utils.BlockMeta;
import io.enderdev.alchemistry.utils.extensions.StringKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0014J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ \u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0014J \u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/enderdev/alchemistry/client/gui/GuiEvaporator;", "Lio/enderdev/alchemistry/client/gui/GuiBase;", "Lio/enderdev/alchemistry/tiles/TileEvaporator;", "playerInv", "Lnet/minecraft/entity/player/InventoryPlayer;", "tile", "<init>", "(Lnet/minecraft/entity/player/InventoryPlayer;Lio/enderdev/alchemistry/tiles/TileEvaporator;)V", "hasHeatSources", "", "heatText", "Lkotlin/Function1;", "", "", "mouseClick", "Lio/enderdev/alchemistry/client/gui/misc/GuiModifiers$MouseClickData;", "renderTooltips", "", "mouseX", "", "mouseY", "drawGuiContainerForegroundLayer", "getColor", "Ljava/awt/Color;", "heat", "drawGuiContainerBackgroundLayer", "partialTicks", "", "mouseClicked", "mouseButton", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nGuiEvaporator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiEvaporator.kt\nio/enderdev/alchemistry/client/gui/GuiEvaporator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,69:1\n1563#2:70\n1634#2,3:71\n11228#3:74\n11563#3,3:75\n*S KotlinDebug\n*F\n+ 1 GuiEvaporator.kt\nio/enderdev/alchemistry/client/gui/GuiEvaporator\n*L\n30#1:70\n30#1:71,3\n35#1:74\n35#1:75,3\n*E\n"})
public final class GuiEvaporator
extends GuiBase<TileEvaporator> {
    private final boolean hasHeatSources;
    @NotNull
    private final Function1<Double, String> heatText;
    @Nullable
    private GuiModifiers.MouseClickData mouseClick;

    public GuiEvaporator(@NotNull InventoryPlayer playerInv, @NotNull TileEvaporator tile) {
        Intrinsics.checkNotNullParameter((Object)playerInv, (String)"playerInv");
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        super(new ContainerEvaporator(playerInv, tile), (AbstractMachine)tile, "evaporator");
        this.hasHeatSources = !(TileEvaporator.Companion.getHeatSources().length == 0);
        this.heatText = GuiEvaporator::heatText$lambda$0;
        this.getDisplayData().add(new CapabilityFluidDisplayWrapper(44, 21, 16, 70, (Function0<? extends IFluidTank>)((Function0)new PropertyReference0Impl(tile){

            public Object get() {
                return ((TileEvaporator)this.receiver).getInputTank();
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        Pair<BlockMeta, Double>[] $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Pair<BlockMeta, Double>[] $this$map$iv;
        boolean $i$f$map;
        Object object;
        super.renderTooltips(mouseX, mouseY);
        int width = this.field_146289_q.func_78256_a((String)this.heatText.invoke((Object)((TileEvaporator)this.getTile()).getHeat()));
        if (this.isHovered(this.field_147003_i + 65, this.field_147009_r + 64, width, this.field_146289_q.field_78288_b, mouseX, mouseY)) {
            object = new Integer[]{1, 2};
            List tooltipLines = CollectionsKt.mutableListOf((Object[])object);
            if (this.hasHeatSources) {
                tooltipLines.add(3);
            }
            object = tooltipLines;
            GuiEvaporator guiEvaporator = this;
            $i$f$map = false;
            void var7_9 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void it;
                int n = ((Number)t).intValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringKt.translate("tile.evaporator.heat_explanation." + (int)it, new Object[0]));
            }
            guiEvaporator.func_146283_a((List)destination$iv$iv, mouseX, mouseY);
        }
        if (this.mouseClick != null) {
            GuiModifiers.MouseClickData mouseClickData = this.mouseClick;
            Intrinsics.checkNotNull((Object)mouseClickData);
            if (mouseClickData.getBtn() == 0) {
                int n = this.field_146289_q.field_78288_b;
                GuiModifiers.MouseClickData mouseClickData2 = this.mouseClick;
                Intrinsics.checkNotNull((Object)mouseClickData2);
                int n2 = mouseClickData2.getX();
                GuiModifiers.MouseClickData mouseClickData3 = this.mouseClick;
                Intrinsics.checkNotNull((Object)mouseClickData3);
                if (this.isHovered(this.field_147003_i + 65, this.field_147009_r + 64, width, n, n2, mouseClickData3.getY())) {
                    $this$map$iv = TileEvaporator.Companion.getHeatSources();
                    String string = this.getDisplayName() + ' ' + StringKt.translate("tile.evaporator.heat_sources", new Object[0]);
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList($this$map$iv.length);
                    $i$f$mapTo = false;
                    int n3 = $this$mapTo$iv$iv.length;
                    for (int i = 0; i < n3; ++i) {
                        Pair<BlockMeta, Double> item$iv$iv;
                        Pair<BlockMeta, Double> pair = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        BlockMeta block = (BlockMeta)pair.component1();
                        double value = ((Number)pair.component2()).doubleValue();
                        collection.add(TuplesKt.to((Object)block.getGUIRenderer((GuiScreen)this), (Object)CollectionsKt.listOf((Object)TuplesKt.to((Object)(Alchemistry.INSTANCE.getDECIMAL_FORMAT().format(value) + 'x'), (Object)this.getColor(value)))));
                    }
                    object = new String[1];
                    Object[] objectArray = new Object[]{""};
                    object[0] = StringKt.translate("tile.evaporator.heat", objectArray);
                    GuiScreen guiScreen = (GuiScreen)this;
                    Function1[] function1Array = new Function1[]{};
                    Object object2 = object;
                    Collection collection = (List)destination$iv$iv;
                    String string2 = string;
                    GuiModifiers gui = new GuiModifiers(string2, collection, (String[])object2, function1Array, guiScreen);
                    this.field_146297_k.func_147108_a((GuiScreen)gui);
                }
            }
        }
        this.mouseClick = null;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        double heat = ((TileEvaporator)this.getTile()).getHeat();
        this.field_146289_q.func_78276_b((String)this.heatText.invoke((Object)heat), 65, 64, this.getColor(heat).getRGB());
    }

    @NotNull
    public final Color getColor(double heat) {
        int r = RangesKt.coerceIn((int)MathKt.roundToInt((double)((double)Color.DARK_GRAY.getRed() * heat)), (int)0, (int)255);
        int b = RangesKt.coerceIn((int)MathKt.roundToInt((double)((double)Color.DARK_GRAY.getBlue() / heat)), (int)0, (int)255);
        return new Color(r, Color.DARK_GRAY.getGreen(), b);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.drawProgressBar(70, 75, 175, 0, 36, 16);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.mouseClick = new GuiModifiers.MouseClickData(mouseX, mouseY, mouseButton);
    }

    private static final String heatText$lambda$0(double heat) {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)Alchemistry.INSTANCE.getDECIMAL_FORMAT().format(heat), (String)"format(...)");
        return StringKt.translate("tile.evaporator.heat", objectArray);
    }
}

