/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.compat.groovyscript.content;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.api.INamed;
import com.cleanroommc.groovyscript.api.documentation.annotations.Example;
import com.cleanroommc.groovyscript.api.documentation.annotations.MethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RegistryDescription;
import com.cleanroommc.groovyscript.sandbox.GroovyLogImpl;
import io.enderdev.alchemistry.chemistry.CompoundPair;
import io.enderdev.alchemistry.chemistry.CompoundRegistry;
import io.enderdev.alchemistry.chemistry.ElementRegistry;
import io.enderdev.alchemistry.proxy.CommonProxy;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RegistryDescription(linkGenerator="alchemistry")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0007J8\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00130\u0013H\u0007JF\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0014\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00130\u0013H\u0007J.\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0014\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00130\u0013H\u0007J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lio/enderdev/alchemistry/compat/groovyscript/content/Content;", "Lcom/cleanroommc/groovyscript/api/INamed;", "<init>", "()V", "createElement", "", "atomicNumber", "", "name", "", "abbreviation", "red", "green", "blue", "createCompoundInternal", "meta", "color", "Ljava/awt/Color;", "components", "Ljava/util/ArrayList;", "", "createCompound", "getAliases", "", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Content.kt\nio/enderdev/alchemistry/compat/groovyscript/content/Content\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1563#2:115\n1634#2,3:116\n1869#2,2:119\n*S KotlinDebug\n*F\n+ 1 Content.kt\nio/enderdev/alchemistry/compat/groovyscript/content/Content\n*L\n55#1:115\n55#1:116,3\n75#1:119,2\n*E\n"})
public final class Content
implements INamed {
    @MethodDescription(example={@Example(value="200, 'Advanced Hydrogen', 'Ah', 255, 255, 255", commented=true)}, type=MethodDescription.Type.ADDITION)
    public final void createElement(int atomicNumber, @NotNull String name, @NotNull String abbreviation, int red, int green, int blue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)abbreviation, (String)"abbreviation");
        if (CommonProxy.Companion.getStage() != CommonProxy.LoadingStage.PRE_INIT) {
            GroovyLogImpl.LOG.info("Element creation is only allowed during preInit stage.", new Object[0]);
            return;
        }
        if (ElementRegistry.INSTANCE.getAllElements().isEmpty()) {
            ElementRegistry.INSTANCE.init();
        }
        String string = ((Object)StringsKt.trim((CharSequence)name)).toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String parsedName = StringsKt.replace$default((String)string2, (String)" ", (String)"_", (boolean)false, (int)4, null);
        if (ElementRegistry.INSTANCE.get(atomicNumber) == null) {
            ElementRegistry.add$default(ElementRegistry.INSTANCE, atomicNumber, parsedName, abbreviation, new Color(RangesKt.coerceIn((int)red, (int)0, (int)255), RangesKt.coerceIn((int)green, (int)0, (int)255), RangesKt.coerceIn((int)blue, (int)0, (int)255)), 0, 0, 48, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @GroovyBlacklist
    public final void createCompoundInternal(int meta, @NotNull String name, @Nullable Color color, @NotNull ArrayList<ArrayList<Object>> components) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        if (CommonProxy.Companion.getStage() != CommonProxy.LoadingStage.PRE_INIT) {
            GroovyLogImpl.LOG.info("Compound creation is only allowed during preInit stage.", new Object[0]);
            return;
        }
        if (ElementRegistry.INSTANCE.getAllElements().isEmpty()) {
            ElementRegistry.INSTANCE.init();
        }
        if (CompoundRegistry.INSTANCE.compounds().isEmpty()) {
            CompoundRegistry.INSTANCE.init();
        }
        String string = ((Object)StringsKt.trim((CharSequence)name)).toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String parsedName = StringsKt.replace$default((String)string2, (String)" ", (String)"_", (boolean)false, (int)4, null);
        if (CompoundRegistry.INSTANCE.get(parsedName) == null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = components;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                ArrayList arrayList = (ArrayList)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (x.size() != 2) {
                    GroovyLogImpl.LOG.error("Invalid component format for " + parsedName, new Object[0]);
                    return;
                }
                Object e = x.get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
                if (ElementRegistry.INSTANCE.get((String)e) == null) {
                    Object e2 = x.get(0);
                    Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.String");
                    if (CompoundRegistry.INSTANCE.get((String)e2) == null) {
                        GroovyLogImpl.LOG.error("Unknown component " + x.get(0) + " for " + parsedName, new Object[0]);
                        GroovyLogImpl.LOG.error("If you are using a custom element or compound, make sure it is created before this compound.", new Object[0]);
                        return;
                    }
                }
                Object e3 = x.get(0);
                Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type kotlin.String");
                String string3 = (String)e3;
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                String string4 = string3.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                String string5 = StringsKt.replace$default((String)string4, (String)" ", (String)"_", (boolean)false, (int)4, null);
                Object e4 = x.get(1);
                Intrinsics.checkNotNull(e4, (String)"null cannot be cast to non-null type kotlin.Int");
                collection.add(new CompoundPair(string5, (int)((Integer)e4)));
            }
            List parsedComponents = (List)destination$iv$iv;
            Color realColor = color;
            if (color == null) {
                int r = 0;
                int g = 0;
                int b = 0;
                int c = 0;
                Iterable $this$forEach$iv = parsedComponents;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CompoundPair it = (CompoundPair)element$iv;
                    boolean bl = false;
                    Color color2 = it.getCompound().getColor();
                    r += color2.getRed() * it.getQuantity();
                    g += color2.getGreen() * it.getQuantity();
                    b += color2.getBlue() * it.getQuantity();
                    c += it.getQuantity();
                }
                double size = c;
                realColor = new Color(MathKt.roundToInt((double)((double)r / size)), MathKt.roundToInt((double)((double)g / size)), MathKt.roundToInt((double)((double)b / size)));
            }
            CompoundRegistry.INSTANCE.addExternal(meta, parsedName, realColor, parsedComponents);
        }
    }

    @MethodDescription(example={@Example(value="200, 'Advanced Hydrogen Molecule', 205, 205, 205, [['advanced_hydrogen', 1],['advanced_hydrogen', 1],['advanced_hydrogen', 1]]", commented=true)}, type=MethodDescription.Type.ADDITION)
    public final void createCompound(int meta, @NotNull String name, int red, int green, int blue, @NotNull ArrayList<ArrayList<Object>> components) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        this.createCompoundInternal(meta, name, new Color(RangesKt.coerceIn((int)red, (int)0, (int)255), RangesKt.coerceIn((int)green, (int)0, (int)255), RangesKt.coerceIn((int)blue, (int)0, (int)255)), components);
    }

    @MethodDescription(example={@Example(value="201, 'Whatever Molecule', [['advanced_hydrogen', 4],['advanced_hydrogen', 1],['oxygen', 6]]", commented=true)}, type=MethodDescription.Type.ADDITION)
    public final void createCompound(int meta, @NotNull String name, @NotNull ArrayList<ArrayList<Object>> components) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        this.createCompoundInternal(meta, name, null, components);
    }

    @NotNull
    public List<String> getAliases() {
        Object[] objectArray = new String[]{"content", "Content"};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

