/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.tiles;

import io.enderdev.alchemistry.recipes.IRecipe;
import io.enderdev.alchemistry.recipes.register.AbstractRecipeRegister;
import io.enderdev.alchemistry.tiles.TileBase;
import io.enderdev.alchemistry.tiles.tags.IGuiTile;
import io.enderdev.alchemistry.tiles.tags.IItemTile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006B\u0015\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010&\u001a\u00020'H&J\b\u0010(\u001a\u00020'H&J\b\u0010)\u001a\u00020'H&J\b\u0010*\u001a\u00020\u0019H&J\b\u0010+\u001a\u00020\u0019H&J\b\u0010,\u001a\u00020'H\u0016J\b\u0010-\u001a\u00020'H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0016J\u0010\u00101\u001a\u00020'2\u0006\u00100\u001a\u00020/H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001e\u0010 \u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00062"}, d2={"Lio/enderdev/alchemistry/tiles/AbstractMachine;", "T", "Lio/enderdev/alchemistry/recipes/IRecipe;", "Lio/enderdev/alchemistry/tiles/TileBase;", "Lnet/minecraft/util/ITickable;", "Lio/enderdev/alchemistry/tiles/tags/IGuiTile;", "Lio/enderdev/alchemistry/tiles/tags/IItemTile;", "recipeRegister", "Lio/enderdev/alchemistry/recipes/register/AbstractRecipeRegister;", "<init>", "(Lio/enderdev/alchemistry/recipes/register/AbstractRecipeRegister;)V", "", "getRecipeRegister", "()Ljava/util/List;", "recipeTime", "", "getRecipeTime", "()I", "energyPerTick", "getEnergyPerTick", "progressTicks", "getProgressTicks", "setProgressTicks", "(I)V", "isPaused", "", "()Z", "setPaused", "(Z)V", "needsPower", "getNeedsPower", "setNeedsPower", "currentRecipe", "getCurrentRecipe", "()Lio/enderdev/alchemistry/recipes/IRecipe;", "setCurrentRecipe", "(Lio/enderdev/alchemistry/recipes/IRecipe;)V", "Lio/enderdev/alchemistry/recipes/IRecipe;", "updateRecipe", "", "onProcessComplete", "onWorkTick", "shouldTick", "shouldProcess", "onIdleTick", "update", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "compound", "readFromNBT", "alchemistry"})
public abstract class AbstractMachine<T extends IRecipe>
extends TileBase
implements ITickable,
IGuiTile,
IItemTile {
    @NotNull
    private final List<T> recipeRegister;
    private int progressTicks;
    private boolean isPaused;
    private boolean needsPower;
    @Nullable
    private T currentRecipe;

    public AbstractMachine(@NotNull AbstractRecipeRegister<T> recipeRegister) {
        Intrinsics.checkNotNullParameter(recipeRegister, (String)"recipeRegister");
        this.recipeRegister = recipeRegister.getRecipes();
    }

    @NotNull
    public final List<T> getRecipeRegister() {
        return this.recipeRegister;
    }

    public abstract int getRecipeTime();

    public abstract int getEnergyPerTick();

    public final int getProgressTicks() {
        return this.progressTicks;
    }

    public final void setProgressTicks(int n) {
        this.progressTicks = n;
    }

    public final boolean isPaused() {
        return this.isPaused;
    }

    public final void setPaused(boolean bl) {
        this.isPaused = bl;
    }

    public final boolean getNeedsPower() {
        return this.needsPower;
    }

    public final void setNeedsPower(boolean bl) {
        this.needsPower = bl;
    }

    @Nullable
    public final T getCurrentRecipe() {
        return this.currentRecipe;
    }

    public final void setCurrentRecipe(@Nullable T t) {
        this.currentRecipe = t;
    }

    public abstract void updateRecipe();

    public abstract void onProcessComplete();

    public abstract void onWorkTick();

    public abstract boolean shouldTick();

    public abstract boolean shouldProcess();

    public void onIdleTick() {
        this.updateRecipe();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.markDirtyGUIEvery(5);
        if (this.isPaused || this.needsPower ^ this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return;
        }
        if (!this.shouldTick()) {
            this.progressTicks = 0;
            return;
        }
        this.onIdleTick();
        if (this.currentRecipe == null || !this.shouldProcess()) {
            this.progressTicks = 0;
            return;
        }
        this.onWorkTick();
        int n = this.progressTicks;
        this.progressTicks = n + 1;
        if (n == this.getRecipeTime()) {
            this.progressTicks = 0;
            this.onProcessComplete();
        }
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        compound.func_74757_a("IsPaused", this.isPaused);
        compound.func_74757_a("NeedsPower", this.needsPower);
        compound.func_74768_a("ProgressTicks", this.progressTicks);
        return compound;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.isPaused = compound.func_74767_n("IsPaused");
        this.needsPower = compound.func_74767_n("NeedsPower");
        this.progressTicks = compound.func_74762_e("ProgressTicks");
    }

    @Override
    public int getGuiHeight() {
        return IGuiTile.super.getGuiHeight();
    }

    @Override
    public int getGuiWidth() {
        return IGuiTile.super.getGuiWidth();
    }
}

