/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.tiles;

import io.enderdev.alchemistry.ConfigHandler;
import io.enderdev.alchemistry.recipes.AtomizerRecipe;
import io.enderdev.alchemistry.recipes.register.AtomizerRegister;
import io.enderdev.alchemistry.tiles.AbstractMachine;
import io.enderdev.alchemistry.tiles.TileStackHandler;
import io.enderdev.alchemistry.tiles.tags.EnergyTileImpl;
import io.enderdev.alchemistry.tiles.tags.IEnergyTile;
import io.enderdev.alchemistry.tiles.tags.IFluidTile;
import io.enderdev.alchemistry.utils.extensions.IItemHandlerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\t\u0010 \u001a\u00020\fH\u0096\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010!\u001a\u00020\"X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lio/enderdev/alchemistry/tiles/TileAtomizer;", "Lio/enderdev/alchemistry/tiles/AbstractMachine;", "Lio/enderdev/alchemistry/recipes/AtomizerRecipe;", "Lio/enderdev/alchemistry/tiles/tags/IFluidTile;", "Lio/enderdev/alchemistry/tiles/tags/IEnergyTile;", "<init>", "()V", "inputTank", "Lnet/minecraftforge/fluids/FluidTank;", "getInputTank", "()Lnet/minecraftforge/fluids/FluidTank;", "energyPerTick", "", "getEnergyPerTick", "()I", "recipeTime", "getRecipeTime", "fluidTanks", "Lnet/minecraftforge/fluids/capability/templates/FluidHandlerConcatenate;", "getFluidTanks", "()Lnet/minecraftforge/fluids/capability/templates/FluidHandlerConcatenate;", "updateRecipe", "", "onProcessComplete", "onWorkTick", "shouldTick", "", "shouldProcess", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "compound", "readFromNBT", "energyCapacity", "energyStorage", "Lnet/minecraftforge/energy/IEnergyStorage;", "getEnergyStorage", "()Lnet/minecraftforge/energy/IEnergyStorage;", "setEnergyStorage", "(Lnet/minecraftforge/energy/IEnergyStorage;)V", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nTileAtomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileAtomizer.kt\nio/enderdev/alchemistry/tiles/TileAtomizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n295#2,2:84\n*S KotlinDebug\n*F\n+ 1 TileAtomizer.kt\nio/enderdev/alchemistry/tiles/TileAtomizer\n*L\n48#1:84,2\n*E\n"})
public final class TileAtomizer
extends AbstractMachine<AtomizerRecipe>
implements IFluidTile,
IEnergyTile {
    private final /* synthetic */ EnergyTileImpl $$delegate_0;
    @NotNull
    private final FluidTank inputTank;

    public TileAtomizer() {
        super(AtomizerRegister.Companion.getINSTANCE());
        this.$$delegate_0 = new EnergyTileImpl(ConfigHandler.ATOMIZER.energyCapacity);
        this.initInventoryCapability(0, 1);
        this.inputTank = new FluidTank(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean canFillFluidType(FluidStack with) {
                if (this.fluid == null) return true;
                FluidStack fluidStack = this.fluid;
                Intrinsics.checkNotNull((Object)fluidStack);
                FluidStack fluidStack2 = with;
                if (!Intrinsics.areEqual((Object)fluidStack.getFluid(), (Object)(fluidStack2 != null ? fluidStack2.getFluid() : null))) return false;
                return true;
            }

            protected void onContentsChanged() {
                this.markDirtyGUI();
            }
        };
        this.inputTank.setTileEntity((TileEntity)this);
        this.inputTank.setCanFill(true);
        this.inputTank.setCanDrain(false);
    }

    @NotNull
    public final FluidTank getInputTank() {
        return this.inputTank;
    }

    @Override
    public int getEnergyPerTick() {
        return ConfigHandler.ATOMIZER.energyPerTick;
    }

    @Override
    public int getRecipeTime() {
        return ConfigHandler.ATOMIZER.processingTicks;
    }

    @Override
    @Nullable
    public FluidHandlerConcatenate getFluidTanks() {
        IFluidHandler[] iFluidHandlerArray = new IFluidHandler[]{this.inputTank};
        return new FluidHandlerConcatenate(iFluidHandlerArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateRecipe() {
        block4: {
            Object v2;
            TileAtomizer tileAtomizer;
            block3: {
                void $this$firstOrNull$iv;
                block5: {
                    if (this.inputTank.getFluid() == null) break block4;
                    if (this.getCurrentRecipe() == null) break block5;
                    Object t = this.getCurrentRecipe();
                    Intrinsics.checkNotNull(t);
                    if (ItemStack.func_77989_b((ItemStack)((AtomizerRecipe)t).getOutput(), (ItemStack)this.getOutput().getStackInSlot(0))) break block4;
                }
                Iterable iterable = this.getRecipeRegister();
                tileAtomizer = this;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AtomizerRecipe it = (AtomizerRecipe)element$iv;
                    boolean bl = false;
                    FluidStack fluidStack = this.inputTank.getFluid();
                    if (!Intrinsics.areEqual((Object)it.getInput().getFluid(), (Object)(fluidStack != null ? fluidStack.getFluid() : null))) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            tileAtomizer.setCurrentRecipe(v2);
        }
        if (this.inputTank.getFluid() == null) {
            this.setCurrentRecipe(null);
        }
    }

    @Override
    public void onProcessComplete() {
        TileStackHandler tileStackHandler = this.getOutput();
        Object t = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t);
        ItemStack itemStack = ((AtomizerRecipe)t).getOutput().func_77946_l();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        tileStackHandler.setOrIncrement(0, itemStack);
        Object t2 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t2);
        this.inputTank.drainInternal(((AtomizerRecipe)t2).getInput().amount, true);
    }

    @Override
    public void onWorkTick() {
        this.getEnergyStorage().extractEnergy(this.getEnergyPerTick(), false);
    }

    @Override
    public boolean shouldTick() {
        return this.inputTank.getFluidAmount() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldProcess() {
        Object t = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t);
        ItemStack recipeOutput = ((AtomizerRecipe)t).getOutput();
        if (this.getEnergyStorage().getEnergyStored() < this.getEnergyPerTick()) return false;
        int n = this.inputTank.getFluidAmount();
        Object t2 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t2);
        if (n < ((AtomizerRecipe)t2).getInput().amount) return false;
        if (!ItemStack.func_179545_c((ItemStack)IItemHandlerKt.get((IItemHandler)this.getOutput(), 0), (ItemStack)recipeOutput)) {
            if (!IItemHandlerKt.get((IItemHandler)this.getOutput(), 0).func_190926_b()) return false;
        }
        if (IItemHandlerKt.get((IItemHandler)this.getOutput(), 0).func_190916_E() + recipeOutput.func_190916_E() > recipeOutput.func_77976_d()) return false;
        return true;
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        compound.func_74782_a("InputTankNBT", (NBTBase)this.inputTank.writeToNBT(new NBTTagCompound()));
        return compound;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.inputTank.readFromNBT(compound.func_74775_l("InputTankNBT"));
    }

    @Override
    @NotNull
    public IEnergyStorage getEnergyStorage() {
        return this.$$delegate_0.getEnergyStorage();
    }

    @Override
    public void setEnergyStorage(@NotNull IEnergyStorage iEnergyStorage) {
        Intrinsics.checkNotNullParameter((Object)iEnergyStorage, (String)"<set-?>");
        this.$$delegate_0.setEnergyStorage(iEnergyStorage);
    }

    @Override
    public int energyCapacity() {
        return this.$$delegate_0.energyCapacity();
    }
}

