/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.tiles;

import io.enderdev.alchemistry.ConfigHandler;
import io.enderdev.alchemistry.recipes.CombinerRecipe;
import io.enderdev.alchemistry.recipes.IRecipe;
import io.enderdev.alchemistry.recipes.register.CombinerRegister;
import io.enderdev.alchemistry.tiles.AbstractMachine;
import io.enderdev.alchemistry.tiles.TileStackHandler;
import io.enderdev.alchemistry.tiles.tags.EnergyTileImpl;
import io.enderdev.alchemistry.tiles.tags.IEnergyTile;
import io.enderdev.alchemistry.utils.extensions.IItemHandlerKt;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u0007H\u0016J\b\u0010#\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020\u0007H\u0002J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'H\u0016J\t\u0010)\u001a\u00020\u0017H\u0096\u0001R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0018\u0010*\u001a\u00020+X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lio/enderdev/alchemistry/tiles/TileChemicalCombiner;", "Lio/enderdev/alchemistry/tiles/AbstractMachine;", "Lio/enderdev/alchemistry/recipes/CombinerRecipe;", "Lio/enderdev/alchemistry/tiles/tags/IEnergyTile;", "<init>", "()V", "recipeIsLocked", "", "getRecipeIsLocked", "()Z", "setRecipeIsLocked", "(Z)V", "clientRecipeTarget", "Lio/enderdev/alchemistry/tiles/TileStackHandler;", "getClientRecipeTarget", "()Lio/enderdev/alchemistry/tiles/TileStackHandler;", "owner", "", "getOwner", "()Ljava/lang/String;", "setOwner", "(Ljava/lang/String;)V", "energyPerTick", "", "getEnergyPerTick", "()I", "recipeTime", "getRecipeTime", "initInventoryInputCapability", "", "updateRecipe", "onProcessComplete", "onWorkTick", "onIdleTick", "shouldTick", "shouldProcess", "hasCurrentRecipeStage", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "writeToNBT", "energyCapacity", "energyStorage", "Lnet/minecraftforge/energy/IEnergyStorage;", "getEnergyStorage", "()Lnet/minecraftforge/energy/IEnergyStorage;", "setEnergyStorage", "(Lnet/minecraftforge/energy/IEnergyStorage;)V", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nTileChemicalCombiner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileChemicalCombiner.kt\nio/enderdev/alchemistry/tiles/TileChemicalCombiner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1#2:132\n1878#3,3:133\n*S KotlinDebug\n*F\n+ 1 TileChemicalCombiner.kt\nio/enderdev/alchemistry/tiles/TileChemicalCombiner\n*L\n61#1:133,3\n*E\n"})
public final class TileChemicalCombiner
extends AbstractMachine<CombinerRecipe>
implements IEnergyTile {
    private final /* synthetic */ EnergyTileImpl $$delegate_0;
    private boolean recipeIsLocked;
    @NotNull
    private final TileStackHandler clientRecipeTarget;
    @NotNull
    private String owner = "";

    public TileChemicalCombiner() {
        super(CombinerRegister.Companion.getINSTANCE());
        this.$$delegate_0 = new EnergyTileImpl(ConfigHandler.COMBINER.energyCapacity);
        this.initInventoryCapability(9, 1);
        this.clientRecipeTarget = new TileStackHandler(this){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }
        };
    }

    public final boolean getRecipeIsLocked() {
        return this.recipeIsLocked;
    }

    public final void setRecipeIsLocked(boolean bl) {
        this.recipeIsLocked = bl;
    }

    @NotNull
    public final TileStackHandler getClientRecipeTarget() {
        return this.clientRecipeTarget;
    }

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    public final void setOwner(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.owner = string;
    }

    @Override
    public int getEnergyPerTick() {
        return ConfigHandler.COMBINER.energyPerTick;
    }

    @Override
    public int getRecipeTime() {
        return ConfigHandler.COMBINER.processingTicks;
    }

    @Override
    public void initInventoryInputCapability() {
        int n = this.getInputSlots();
        this.setInput(new TileStackHandler(this, n){
            final /* synthetic */ TileChemicalCombiner this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $receiver);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                if (this.this$0.getRecipeIsLocked()) {
                    Object object = (CombinerRecipe)this.this$0.getCurrentRecipe();
                    if (object == null || (object = ((CombinerRecipe)object).getInputs()) == null || (object = (ItemStack)((ArrayList)object).get(slot)) == null) {
                        object = ItemStack.field_190927_a;
                    }
                    if (ItemStack.func_179545_c((ItemStack)object, (ItemStack)stack)) {
                    } else {
                        return stack;
                    }
                }
                ItemStack itemStack = super.insertItem(slot, stack, simulate);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"insertItem(...)");
                return itemStack;
            }

            protected void onContentsChanged(int slot) {
                if (!this.this$0.getRecipeIsLocked()) {
                    this.this$0.updateRecipe();
                }
            }
        });
    }

    @Override
    public void updateRecipe() {
        if (this.recipeIsLocked) {
            return;
        }
        this.setCurrentRecipe((IRecipe)CombinerRecipe.Companion.matchInputs((IItemHandler)this.getInput()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onProcessComplete() {
        block3: {
            Object object;
            CombinerRecipe combinerRecipe = (CombinerRecipe)this.getCurrentRecipe();
            if (combinerRecipe != null) {
                CombinerRecipe it = combinerRecipe;
                boolean bl = false;
                TileStackHandler tileStackHandler = this.getOutput();
                ItemStack itemStack = it.getOutput().func_77946_l();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
                tileStackHandler.setOrIncrement(0, itemStack);
            }
            if ((object = (CombinerRecipe)this.getCurrentRecipe()) == null || (object = ((CombinerRecipe)object).getInputs()) == null) break block3;
            Iterable $this$forEachIndexed$iv = (Iterable)object;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void stack;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ItemStack itemStack = (ItemStack)item$iv;
                int index = n;
                boolean bl = false;
                if (stack.func_190926_b()) continue;
                this.getInput().decrementSlot(index, stack.func_190916_E());
            }
        }
    }

    @Override
    public void onWorkTick() {
        this.getEnergyStorage().extractEnergy(this.getEnergyPerTick(), false);
    }

    @Override
    public void onIdleTick() {
        super.onIdleTick();
        if (this.recipeIsLocked) {
            CombinerRecipe combinerRecipe = (CombinerRecipe)this.getCurrentRecipe();
            if (combinerRecipe == null || (combinerRecipe = combinerRecipe.getOutput()) == null || (combinerRecipe = combinerRecipe.func_77946_l()) == null) {
                combinerRecipe = ItemStack.field_190927_a;
            }
            this.clientRecipeTarget.setStackInSlot(0, (ItemStack)combinerRecipe);
        }
    }

    @Override
    public boolean shouldTick() {
        return this.getEnergyStorage().getEnergyStored() >= this.getEnergyPerTick();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldProcess() {
        Object t = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t);
        if (!Intrinsics.areEqual((Object)((CombinerRecipe)t).getGamestage(), (Object)"")) {
            if (!this.hasCurrentRecipeStage()) return false;
        }
        Object t2 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t2);
        int n = ((CombinerRecipe)t2).getOutput().func_190916_E() + IItemHandlerKt.get((IItemHandler)this.getOutput(), 0).func_190916_E();
        Object t3 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t3);
        if (n > ((CombinerRecipe)t3).getOutput().func_77976_d()) return false;
        ItemStack itemStack = IItemHandlerKt.get((IItemHandler)this.getOutput(), 0);
        Object t4 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t4);
        if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)((CombinerRecipe)t4).getOutput())) {
            if (!IItemHandlerKt.get((IItemHandler)this.getOutput(), 0).func_190926_b()) return false;
        }
        Object t5 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t5);
        if (!((CombinerRecipe)t5).matchesHandlerStacks(this.getInput())) return false;
        if (!this.recipeIsLocked) return true;
        CombinerRecipe combinerRecipe = CombinerRecipe.Companion.matchInputs((IItemHandler)this.getInput());
        if (combinerRecipe == null || (combinerRecipe = combinerRecipe.getOutput()) == null) {
            combinerRecipe = ItemStack.field_190927_a;
        }
        Object t6 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t6);
        if (!ItemStack.func_77989_b((ItemStack)combinerRecipe, (ItemStack)((CombinerRecipe)t6).getOutput())) return false;
        return true;
    }

    private final boolean hasCurrentRecipeStage() {
        boolean bl;
        if (Loader.isModLoaded((String)"gamestages")) {
            PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            EntityPlayerMP entityPlayerMP = playerList.func_152612_a(this.owner);
            if (entityPlayerMP == null) {
                return false;
            }
            EntityPlayerMP playerOwner = entityPlayerMP;
            CombinerRecipe combinerRecipe = (CombinerRecipe)this.getCurrentRecipe();
            bl = GameStageHelper.hasStage((EntityPlayer)((EntityPlayer)playerOwner), (String)(combinerRecipe != null ? combinerRecipe.getGamestage() : null));
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.recipeIsLocked = compound.func_74767_n("RecipeIsLocked");
        String string = compound.func_74779_i("Owner");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.owner = string;
        if (this.recipeIsLocked) {
            ItemStackHandler tempItemHandler = new ItemStackHandler(9);
            NBTTagList recipeInputsList = compound.func_150295_c("RecipeInputs", 10);
            int n = recipeInputsList.func_74745_c();
            for (int i = 0; i < n; ++i) {
                tempItemHandler.setStackInSlot(i, new ItemStack(recipeInputsList.func_150305_b(i)));
            }
            ItemStack recipeTarget = new ItemStack(compound.func_74775_l("RecipeTarget"));
            this.setCurrentRecipe((IRecipe)CombinerRecipe.Companion.matchOutput(recipeTarget));
            CombinerRecipe combinerRecipe = (CombinerRecipe)this.getCurrentRecipe();
            if (combinerRecipe == null || (combinerRecipe = combinerRecipe.getOutput()) == null || (combinerRecipe = combinerRecipe.func_77946_l()) == null) {
                combinerRecipe = ItemStack.field_190927_a;
            }
            this.clientRecipeTarget.setStackInSlot(0, (ItemStack)combinerRecipe);
        } else {
            this.clientRecipeTarget.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.func_74757_a("RecipeIsLocked", this.recipeIsLocked);
        compound.func_74778_a("Owner", this.owner);
        if (this.recipeIsLocked && this.getCurrentRecipe() != null) {
            NBTTagList recipeInputs = new NBTTagList();
            Object t = this.getCurrentRecipe();
            Intrinsics.checkNotNull(t);
            int n = ((Collection)((CombinerRecipe)t).getInputs()).size();
            for (int i = 0; i < n; ++i) {
                NBTTagCompound recipeInputEntry = new NBTTagCompound();
                Object t2 = this.getCurrentRecipe();
                Intrinsics.checkNotNull(t2);
                ItemStack tempStack = ((CombinerRecipe)t2).getInputs().get(i).func_77946_l();
                tempStack.func_77955_b(recipeInputEntry);
                recipeInputs.func_74742_a((NBTBase)recipeInputEntry);
            }
            compound.func_74782_a("RecipeInputs", (NBTBase)recipeInputs);
        }
        compound.func_74782_a("RecipeTarget", (NBTBase)IItemHandlerKt.get((IItemHandler)this.clientRecipeTarget, 0).serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    @NotNull
    public IEnergyStorage getEnergyStorage() {
        return this.$$delegate_0.getEnergyStorage();
    }

    @Override
    public void setEnergyStorage(@NotNull IEnergyStorage iEnergyStorage) {
        Intrinsics.checkNotNullParameter((Object)iEnergyStorage, (String)"<set-?>");
        this.$$delegate_0.setEnergyStorage(iEnergyStorage);
    }

    @Override
    public int energyCapacity() {
        return this.$$delegate_0.energyCapacity();
    }
}

