/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.tiles;

import io.enderdev.alchemistry.ConfigHandler;
import io.enderdev.alchemistry.recipes.DissolverRecipe;
import io.enderdev.alchemistry.recipes.IRecipe;
import io.enderdev.alchemistry.recipes.ProbabilitySet;
import io.enderdev.alchemistry.recipes.register.DissolverRegister;
import io.enderdev.alchemistry.tiles.AbstractMachine;
import io.enderdev.alchemistry.tiles.TileStackHandler;
import io.enderdev.alchemistry.tiles.tags.EnergyTileImpl;
import io.enderdev.alchemistry.tiles.tags.IEnergyTile;
import io.enderdev.alchemistry.utils.extensions.IItemHandlerKt;
import io.enderdev.alchemistry.utils.extensions.ItemStackKt;
import io.enderdev.alchemistry.utils.extensions.ListKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0006\u0010\u0015\u001a\u00020\u0013J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001f\u001a\u00020\rH\u0096\u0001R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0018\u0010 \u001a\u00020!X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lio/enderdev/alchemistry/tiles/TileChemicalDissolver;", "Lio/enderdev/alchemistry/tiles/AbstractMachine;", "Lio/enderdev/alchemistry/recipes/DissolverRecipe;", "Lio/enderdev/alchemistry/tiles/tags/IEnergyTile;", "<init>", "()V", "outputSuccessful", "", "outputBuffer", "", "Lnet/minecraft/item/ItemStack;", "outputThisTick", "energyPerTick", "", "getEnergyPerTick", "()I", "recipeTime", "getRecipeTime", "initInventoryInputCapability", "", "updateRecipe", "tryOutput", "onProcessComplete", "onIdleTick", "onWorkTick", "shouldTick", "shouldProcess", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "writeToNBT", "energyCapacity", "energyStorage", "Lnet/minecraftforge/energy/IEnergyStorage;", "getEnergyStorage", "()Lnet/minecraftforge/energy/IEnergyStorage;", "setEnergyStorage", "(Lnet/minecraftforge/energy/IEnergyStorage;)V", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nTileChemicalDissolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileChemicalDissolver.kt\nio/enderdev/alchemistry/tiles/TileChemicalDissolver\n+ 2 DissolverRecipe.kt\nio/enderdev/alchemistry/recipes/DissolverRecipe\n*L\n1#1,126:1\n28#2:127\n18#2,3:128\n*S KotlinDebug\n*F\n+ 1 TileChemicalDissolver.kt\nio/enderdev/alchemistry/tiles/TileChemicalDissolver\n*L\n80#1:127\n81#1:128,3\n*E\n"})
public final class TileChemicalDissolver
extends AbstractMachine<DissolverRecipe>
implements IEnergyTile {
    private final /* synthetic */ EnergyTileImpl $$delegate_0;
    private boolean outputSuccessful = true;
    @NotNull
    private List<ItemStack> outputBuffer = new ArrayList();
    @NotNull
    private ItemStack outputThisTick;

    public TileChemicalDissolver() {
        super(DissolverRegister.Companion.getINSTANCE());
        this.$$delegate_0 = new EnergyTileImpl(ConfigHandler.DISSOLVER.energyCapacity);
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.outputThisTick = itemStack;
        this.initInventoryCapability(1, 12);
    }

    @Override
    public int getEnergyPerTick() {
        return ConfigHandler.DISSOLVER.energyPerTick;
    }

    @Override
    public int getRecipeTime() {
        return ConfigHandler.DISSOLVER.processingTicks;
    }

    @Override
    public void initInventoryInputCapability() {
        int n = this.getInputSlots();
        this.setInput(new TileStackHandler(this, n){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                ItemStack itemStack = !this.getStackInSlot(slot).func_190926_b() || DissolverRecipe.Companion.match(stack, false) != null ? super.insertItem(slot, stack, simulate) : stack;
                Intrinsics.checkNotNull((Object)itemStack);
                return itemStack;
            }
        });
    }

    @Override
    public void updateRecipe() {
        this.setCurrentRecipe((IRecipe)DissolverRecipe.Companion.match(IItemHandlerKt.get((IItemHandler)this.getInput(), 0), true));
    }

    public final void tryOutput() {
        int i;
        if (this.outputSuccessful) {
            if (!((Collection)this.outputBuffer).isEmpty()) {
                ItemStack itemStack = this.outputBuffer.get(0).func_77979_a(ConfigHandler.DISSOLVER.speed);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"splitStack(...)");
                this.outputThisTick = itemStack;
            } else {
                ItemStack itemStack = ItemStack.field_190927_a;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                this.outputThisTick = itemStack;
            }
            if (!((Collection)this.outputBuffer).isEmpty() && this.outputBuffer.get(0).func_190926_b()) {
                this.outputBuffer.remove(0);
            }
            this.outputSuccessful = false;
        }
        int n = this.getOutput().getSlots();
        for (i = 0; i < n; ++i) {
            if (!ItemStackKt.canMergeWith(this.outputThisTick, IItemHandlerKt.get((IItemHandler)this.getOutput(), i), false)) continue;
            this.getOutput().setOrIncrement(i, this.outputThisTick);
            this.outputSuccessful = true;
            break;
        }
        if (!this.outputSuccessful) {
            n = this.getOutput().getSlots();
            for (i = 0; i < n; ++i) {
                if (!ItemStackKt.canMergeWith(this.outputThisTick, IItemHandlerKt.get((IItemHandler)this.getOutput(), i), true)) continue;
                this.getOutput().setOrIncrement(i, this.outputThisTick);
                this.outputSuccessful = true;
                break;
            }
        }
        if (this.outputSuccessful) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            this.outputThisTick = itemStack;
        }
    }

    @Override
    public void onProcessComplete() {
        if (this.outputBuffer.isEmpty()) {
            Object t = this.getCurrentRecipe();
            Intrinsics.checkNotNull(t);
            DissolverRecipe this_$iv = (DissolverRecipe)t;
            boolean $i$f$getOutputs = false;
            ProbabilitySet probabilitySet = this_$iv.getInternalOutputs();
            Intrinsics.checkNotNull((Object)probabilitySet);
            this.outputBuffer = CollectionsKt.toMutableList((Collection)ProbabilitySet.copy$default(probabilitySet, null, false, 0, 7, null).calculateOutput());
            TileStackHandler tileStackHandler = this.getInput();
            Object t2 = this.getCurrentRecipe();
            Intrinsics.checkNotNull(t2);
            this_$iv = (DissolverRecipe)t2;
            boolean $i$f$getInputs = false;
            ArrayList temp$iv = new ArrayList();
            if (this_$iv.getInput() != null) {
                Collection collection = temp$iv;
                Ingredient ingredient = this_$iv.getInput();
                Intrinsics.checkNotNull((Object)ingredient);
                ItemStack[] itemStackArray = ingredient.func_193365_a();
                Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getMatchingStacks(...)");
                Object[] objectArray = itemStackArray;
                Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
                CollectionsKt.addAll((Collection)collection, (Object[])objectArray2);
            }
            tileStackHandler.decrementSlot(0, ((ItemStack)((List)ListKt.toImmutable(temp$iv)).get(0)).func_190916_E());
        }
        this.tryOutput();
    }

    @Override
    public void onIdleTick() {
        super.onIdleTick();
        this.tryOutput();
    }

    @Override
    public void onWorkTick() {
        this.getEnergyStorage().extractEnergy(this.getEnergyPerTick(), false);
    }

    @Override
    public boolean shouldTick() {
        return !IItemHandlerKt.get((IItemHandler)this.getInput(), 0).func_190926_b() || !((Collection)this.outputBuffer).isEmpty();
    }

    @Override
    public boolean shouldProcess() {
        return this.getEnergyStorage().getEnergyStored() >= this.getEnergyPerTick() && (this.getCurrentRecipe() != null || !this.outputBuffer.isEmpty());
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.outputSuccessful = compound.func_74767_n("OutputSuccessful");
        NBTTagList outputBufferList = compound.func_150295_c("OutputBuffer", 10);
        int n = outputBufferList.func_74745_c();
        for (int i = 0; i < n; ++i) {
            this.outputBuffer.add(new ItemStack(outputBufferList.func_150305_b(i)));
        }
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        compound.func_74757_a("OutputSuccessful", this.outputSuccessful);
        NBTTagList outputBufferList = new NBTTagList();
        int n = ((Collection)this.outputBuffer).size();
        for (int i = 0; i < n; ++i) {
            NBTTagCompound outputBufferEntry = new NBTTagCompound();
            ItemStack tempStack = this.outputBuffer.get(i);
            tempStack.func_77955_b(outputBufferEntry);
            outputBufferList.func_74742_a((NBTBase)outputBufferEntry);
        }
        compound.func_74782_a("OutputBuffer", (NBTBase)outputBufferList);
        return compound;
    }

    @Override
    @NotNull
    public IEnergyStorage getEnergyStorage() {
        return this.$$delegate_0.getEnergyStorage();
    }

    @Override
    public void setEnergyStorage(@NotNull IEnergyStorage iEnergyStorage) {
        Intrinsics.checkNotNullParameter((Object)iEnergyStorage, (String)"<set-?>");
        this.$$delegate_0.setEnergyStorage(iEnergyStorage);
    }

    @Override
    public int energyCapacity() {
        return this.$$delegate_0.energyCapacity();
    }
}

