/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.tiles;

import io.enderdev.alchemistry.ConfigHandler;
import io.enderdev.alchemistry.recipes.ElectrolyzerRecipe;
import io.enderdev.alchemistry.recipes.register.ElectrolyzerRegister;
import io.enderdev.alchemistry.tiles.AbstractMachine;
import io.enderdev.alchemistry.tiles.TileStackHandler;
import io.enderdev.alchemistry.tiles.tags.EnergyTileImpl;
import io.enderdev.alchemistry.tiles.tags.IEnergyTile;
import io.enderdev.alchemistry.tiles.tags.IFluidTile;
import io.enderdev.alchemistry.utils.extensions.IItemHandlerKt;
import io.enderdev.alchemistry.utils.extensions.ListKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\t\u0010!\u001a\u00020\u0010H\u0096\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0018\u0010\"\u001a\u00020#X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lio/enderdev/alchemistry/tiles/TileElectrolyzer;", "Lio/enderdev/alchemistry/tiles/AbstractMachine;", "Lio/enderdev/alchemistry/recipes/ElectrolyzerRecipe;", "Lio/enderdev/alchemistry/tiles/tags/IFluidTile;", "Lio/enderdev/alchemistry/tiles/tags/IEnergyTile;", "<init>", "()V", "inputTank", "Lnet/minecraftforge/fluids/FluidTank;", "getInputTank", "()Lnet/minecraftforge/fluids/FluidTank;", "fluidTanks", "Lnet/minecraftforge/fluids/capability/templates/FluidHandlerConcatenate;", "getFluidTanks", "()Lnet/minecraftforge/fluids/capability/templates/FluidHandlerConcatenate;", "recipeTime", "", "getRecipeTime", "()I", "energyPerTick", "getEnergyPerTick", "updateRecipe", "", "onProcessComplete", "onWorkTick", "shouldTick", "", "shouldProcess", "initInventoryInputCapability", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "compound", "readFromNBT", "energyCapacity", "energyStorage", "Lnet/minecraftforge/energy/IEnergyStorage;", "getEnergyStorage", "()Lnet/minecraftforge/energy/IEnergyStorage;", "setEnergyStorage", "(Lnet/minecraftforge/energy/IEnergyStorage;)V", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nTileElectrolyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileElectrolyzer.kt\nio/enderdev/alchemistry/tiles/TileElectrolyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n295#2,2:105\n1869#2,2:107\n1740#2,3:109\n*S KotlinDebug\n*F\n+ 1 TileElectrolyzer.kt\nio/enderdev/alchemistry/tiles/TileElectrolyzer\n*L\n35#1:105,2\n47#1:107,2\n60#1:109,3\n*E\n"})
public final class TileElectrolyzer
extends AbstractMachine<ElectrolyzerRecipe>
implements IFluidTile,
IEnergyTile {
    private final /* synthetic */ EnergyTileImpl $$delegate_0;
    @NotNull
    private final FluidTank inputTank;

    public TileElectrolyzer() {
        super(ElectrolyzerRegister.Companion.getINSTANCE());
        this.$$delegate_0 = new EnergyTileImpl(ConfigHandler.ELECTROLYZER.energyCapacity);
        this.initInventoryCapability(1, 4);
        this.inputTank = new FluidTank(){

            public boolean canFillFluidType(FluidStack fluid) {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = this.getRecipeRegister();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ElectrolyzerRecipe it = (ElectrolyzerRecipe)element$iv;
                            boolean bl2 = false;
                            FluidStack fluidStack = fluid;
                            if (!Intrinsics.areEqual((Object)it.getInput().getFluid(), (Object)(fluidStack != null ? fluidStack.getFluid() : null))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            protected void onContentsChanged() {
                this.markDirtyGUI();
            }
        };
        this.inputTank.setTileEntity((TileEntity)this);
        this.inputTank.setCanFill(true);
        this.inputTank.setCanDrain(false);
    }

    @NotNull
    public final FluidTank getInputTank() {
        return this.inputTank;
    }

    @Override
    @Nullable
    public FluidHandlerConcatenate getFluidTanks() {
        IFluidHandler[] iFluidHandlerArray = new IFluidHandler[]{this.inputTank};
        return new FluidHandlerConcatenate(iFluidHandlerArray);
    }

    @Override
    public int getRecipeTime() {
        return ConfigHandler.ELECTROLYZER.processingTicks;
    }

    @Override
    public int getEnergyPerTick() {
        return ConfigHandler.ELECTROLYZER.energyPerTick;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateRecipe() {
        FluidStack inputStack;
        block4: {
            Object v1;
            TileElectrolyzer tileElectrolyzer;
            block3: {
                void $this$firstOrNull$iv;
                block5: {
                    inputStack = this.inputTank.getFluid();
                    if (inputStack == null) break block4;
                    if (this.getCurrentRecipe() == null) break block5;
                    Object t = this.getCurrentRecipe();
                    Intrinsics.checkNotNull(t);
                    if (!Intrinsics.areEqual((Object)((ElectrolyzerRecipe)t).getInput().getFluid(), (Object)inputStack.getFluid())) break block4;
                }
                Iterable iterable = this.getRecipeRegister();
                tileElectrolyzer = this;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ElectrolyzerRecipe it = (ElectrolyzerRecipe)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getInput().getFluid(), (Object)inputStack.getFluid())) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            tileElectrolyzer.setCurrentRecipe(v1);
        }
        if (inputStack == null) {
            this.setCurrentRecipe(null);
        }
    }

    @Override
    public void onProcessComplete() {
        Object t = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t);
        this.inputTank.drainInternal(((ElectrolyzerRecipe)t).getInput().amount, true);
        int n = this.field_145850_b.field_73012_v.nextInt(100);
        Object t2 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t2);
        if (n < ((ElectrolyzerRecipe)t2).getElectrolyteConsumptionChance()) {
            TileStackHandler tileStackHandler = this.getInput();
            Object t3 = this.getCurrentRecipe();
            Intrinsics.checkNotNull(t3);
            tileStackHandler.decrementSlot(0, ((ElectrolyzerRecipe)t3).getElectrolytes().get(0).func_190916_E());
        }
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, 3);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            TileStackHandler tileStackHandler = this.getOutput();
            Object t4 = this.getCurrentRecipe();
            Intrinsics.checkNotNull(t4);
            tileStackHandler.setOrIncrement(it, ((ElectrolyzerRecipe)t4).calculatedInSlot(it));
        }
    }

    @Override
    public void onWorkTick() {
        this.getEnergyStorage().extractEnergy(ConfigHandler.ELECTROLYZER.energyPerTick, false);
    }

    @Override
    public boolean shouldTick() {
        return this.inputTank.getFluidAmount() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldProcess() {
        boolean bl;
        int n = this.inputTank.getFluidAmount();
        Object t = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t);
        if (n < ((ElectrolyzerRecipe)t).getInput().amount) return false;
        int n2 = IItemHandlerKt.get((IItemHandler)this.getInput(), 0).func_190916_E();
        Object t2 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t2);
        if (n2 < ((ElectrolyzerRecipe)t2).getElectrolytes().get(0).func_190916_E()) return false;
        if (this.getEnergyStorage().getEnergyStored() < this.getEnergyPerTick()) return false;
        Iterable $this$all$iv = (Iterable)new IntRange(0, 3);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            int element$iv;
            if (!iterator.hasNext()) return true;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl2 = false;
            ItemStack outputStack = IItemHandlerKt.get((IItemHandler)this.getOutput(), it);
            Object t3 = this.getCurrentRecipe();
            Intrinsics.checkNotNull(t3);
            ItemStack recipeStack = ((ElectrolyzerRecipe)t3).getOutputs().get(it).func_77946_l();
            if (!outputStack.func_190926_b()) {
                if (!ItemStack.func_179545_c((ItemStack)outputStack, (ItemStack)recipeStack)) return false;
            }
            if (outputStack.func_190916_E() + recipeStack.func_190916_E() > recipeStack.func_77976_d()) return false;
            bl = true;
        } while (bl);
        return false;
    }

    @Override
    public void initInventoryInputCapability() {
        int n = this.getInputSlots();
        this.setInput(new TileStackHandler(this, n){
            final /* synthetic */ TileElectrolyzer this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $receiver);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                ItemStack itemStack;
                boolean bl;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    Iterable $this$any$iv = this.this$0.getRecipeRegister();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            ElectrolyzerRecipe it = (ElectrolyzerRecipe)element$iv;
                            boolean bl2 = false;
                            if (!ListKt.containsItem$default(it.getElectrolytes(), stack, false, 2, null)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    ItemStack itemStack2 = super.insertItem(slot, stack, simulate);
                    itemStack = itemStack2;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"insertItem(...)");
                } else {
                    itemStack = stack;
                }
                return itemStack;
            }
        });
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        compound.func_74782_a("InputTankNBT", (NBTBase)this.inputTank.writeToNBT(new NBTTagCompound()));
        return compound;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.inputTank.readFromNBT(compound.func_74775_l("InputTankNBT"));
    }

    @Override
    @NotNull
    public IEnergyStorage getEnergyStorage() {
        return this.$$delegate_0.getEnergyStorage();
    }

    @Override
    public void setEnergyStorage(@NotNull IEnergyStorage iEnergyStorage) {
        Intrinsics.checkNotNullParameter((Object)iEnergyStorage, (String)"<set-?>");
        this.$$delegate_0.setEnergyStorage(iEnergyStorage);
    }

    @Override
    public int energyCapacity() {
        return this.$$delegate_0.energyCapacity();
    }
}

