/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.tiles;

import io.enderdev.alchemistry.ConfigHandler;
import io.enderdev.alchemistry.blocks.ModBlocks;
import io.enderdev.alchemistry.blocks.PropertyPowerStatus;
import io.enderdev.alchemistry.blocks.machine.ReactorControllerBlock;
import io.enderdev.alchemistry.chemistry.ChemicalElement;
import io.enderdev.alchemistry.chemistry.ElementRegistry;
import io.enderdev.alchemistry.items.ModItems;
import io.enderdev.alchemistry.recipes.FusionRecipe;
import io.enderdev.alchemistry.recipes.IRecipe;
import io.enderdev.alchemistry.recipes.register.FusionRegister;
import io.enderdev.alchemistry.tiles.AbstractReactorController;
import io.enderdev.alchemistry.tiles.ReactorType;
import io.enderdev.alchemistry.tiles.TileStackHandler;
import io.enderdev.alchemistry.tiles.tags.EnergyTileImpl;
import io.enderdev.alchemistry.tiles.tags.IEnergyTile;
import io.enderdev.alchemistry.utils.extensions.IItemHandlerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020\u0011H\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020#H\u0016J\t\u0010&\u001a\u00020\u0007H\u0096\u0001R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\tR\u0014\u0010\u0018\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\tR\u0018\u0010'\u001a\u00020(X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lio/enderdev/alchemistry/tiles/TileFusionController;", "Lio/enderdev/alchemistry/tiles/AbstractReactorController;", "Lio/enderdev/alchemistry/recipes/FusionRecipe;", "Lio/enderdev/alchemistry/tiles/tags/IEnergyTile;", "<init>", "()V", "guiHeight", "", "getGuiHeight", "()I", "recipeOutput", "Lnet/minecraft/item/ItemStack;", "getRecipeOutput", "()Lnet/minecraft/item/ItemStack;", "setRecipeOutput", "(Lnet/minecraft/item/ItemStack;)V", "singleMode", "", "getSingleMode", "()Z", "setSingleMode", "(Z)V", "energyPerTick", "getEnergyPerTick", "recipeTime", "getRecipeTime", "initInventoryInputCapability", "", "updateRecipe", "onProcessComplete", "onWorkTick", "shouldTick", "shouldProcess", "onIdleTick", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "compound", "readFromNBT", "energyCapacity", "energyStorage", "Lnet/minecraftforge/energy/IEnergyStorage;", "getEnergyStorage", "()Lnet/minecraftforge/energy/IEnergyStorage;", "setEnergyStorage", "(Lnet/minecraftforge/energy/IEnergyStorage;)V", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nTileFusionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileFusionController.kt\nio/enderdev/alchemistry/tiles/TileFusionController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n295#2,2:121\n*S KotlinDebug\n*F\n+ 1 TileFusionController.kt\nio/enderdev/alchemistry/tiles/TileFusionController\n*L\n48#1:121,2\n*E\n"})
public final class TileFusionController
extends AbstractReactorController<FusionRecipe>
implements IEnergyTile {
    private final /* synthetic */ EnergyTileImpl $$delegate_0;
    @NotNull
    private ItemStack recipeOutput;
    private boolean singleMode;

    public TileFusionController() {
        super(ReactorType.FUSION, FusionRegister.Companion.getINSTANCE());
        this.$$delegate_0 = new EnergyTileImpl(ConfigHandler.FUSION.energyCapacity);
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.recipeOutput = itemStack;
        this.initInventoryCapability(2, 1);
        this.loadConfig(ConfigHandler.FUSION.moderators);
    }

    @Override
    public int getGuiHeight() {
        return 222;
    }

    @NotNull
    public final ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public final void setRecipeOutput(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.recipeOutput = itemStack;
    }

    public final boolean getSingleMode() {
        return this.singleMode;
    }

    public final void setSingleMode(boolean bl) {
        this.singleMode = bl;
    }

    @Override
    public int getEnergyPerTick() {
        return this.getModifiedEnergyCost(ConfigHandler.FUSION.energyPerTick);
    }

    @Override
    public int getRecipeTime() {
        return this.getModifiedProcessTime(ConfigHandler.FUSION.processingTicks);
    }

    @Override
    public void initInventoryInputCapability() {
        int n = this.getInputSlots();
        this.setInput(new TileStackHandler(this, n){
            final /* synthetic */ TileFusionController this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $receiver);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                ItemStack itemStack = this.this$0.getSingleMode() ? (this.getStackInSlot(slot).func_190926_b() ? super.insertItem(slot, stack, simulate) : stack) : (Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)((Object)ModItems.INSTANCE.getElements())) ? super.insertItem(slot, stack, simulate) : stack);
                Intrinsics.checkNotNull((Object)itemStack);
                return itemStack;
            }
        });
    }

    @Override
    public void updateRecipe() {
        block4: {
            Object v0;
            block3: {
                int meta1 = IItemHandlerKt.get((IItemHandler)this.getInput(), 0).func_77960_j();
                int meta2 = IItemHandlerKt.get((IItemHandler)this.getInput(), 1).func_77960_j();
                Iterable $this$firstOrNull$iv = this.getRecipeRegister();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FusionRecipe it = (FusionRecipe)element$iv;
                    boolean bl = false;
                    if (!(it.getInputMeta1() == meta1 && it.getInputMeta2() == meta2 || it.getInputMeta1() == meta2 && it.getInputMeta2() == meta1)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            FusionRecipe fusionRecipe = v0;
            if (fusionRecipe != null) {
                FusionRecipe it = fusionRecipe;
                boolean bl = false;
                this.setCurrentRecipe((IRecipe)it);
            }
            FusionRecipe fusionRecipe2 = (FusionRecipe)this.getCurrentRecipe();
            if (fusionRecipe2 == null) break block4;
            FusionRecipe it = fusionRecipe2;
            boolean bl = false;
            ChemicalElement chemicalElement = ElementRegistry.INSTANCE.get(it.getOutputMeta());
            if (chemicalElement == null || (chemicalElement = chemicalElement.toItemStack(1)) == null) {
                ItemStack itemStack = ItemStack.field_190927_a;
                chemicalElement = itemStack;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            }
            this.recipeOutput = chemicalElement;
        }
    }

    @Override
    public void onProcessComplete() {
        double productivity = this.getCurrentMultiplier().component1();
        if (productivity > 0.0) {
            ItemStack itemStack;
            int stackMultiplier = (int)productivity + (productivity - (double)((int)productivity) > this.field_145850_b.field_73012_v.nextDouble() ? 1 : 0);
            ItemStack $this$onProcessComplete_u24lambda_u243 = itemStack = this.recipeOutput.func_77946_l();
            boolean bl = false;
            $this$onProcessComplete_u24lambda_u243.func_190920_e(RangesKt.coerceIn((int)($this$onProcessComplete_u24lambda_u243.func_190916_E() * stackMultiplier), (int)0, (int)$this$onProcessComplete_u24lambda_u243.func_77976_d()));
            TileStackHandler tileStackHandler = this.getOutput();
            Intrinsics.checkNotNull((Object)$this$onProcessComplete_u24lambda_u243);
            tileStackHandler.setOrIncrement(0, $this$onProcessComplete_u24lambda_u243);
        }
        this.getInput().decrementSlot(0, 1);
        this.getInput().decrementSlot(1, 1);
    }

    @Override
    public void onWorkTick() {
        this.getEnergyStorage().extractEnergy(this.getEnergyPerTick(), false);
    }

    @Override
    public boolean shouldTick() {
        return true;
    }

    @Override
    public boolean shouldProcess() {
        return this.isMultiblockValid() && !IItemHandlerKt.get((IItemHandler)this.getInput(), 0).func_190926_b() && !IItemHandlerKt.get((IItemHandler)this.getInput(), 1).func_190926_b() && !this.recipeOutput.func_190926_b() && (ItemStack.func_179545_c((ItemStack)IItemHandlerKt.get((IItemHandler)this.getOutput(), 0), (ItemStack)this.recipeOutput) || IItemHandlerKt.get((IItemHandler)this.getOutput(), 0).func_190926_b()) && IItemHandlerKt.get((IItemHandler)this.getOutput(), 0).func_190916_E() + this.recipeOutput.func_190916_E() <= this.recipeOutput.func_77976_d() && this.getEnergyStorage().getEnergyStored() >= this.getEnergyPerTick();
    }

    @Override
    public void onIdleTick() {
        super.onIdleTick();
        this.setCheckMultiblockTicks(this.getCheckMultiblockTicks() + 1);
        if (this.getCheckMultiblockTicks() == 20) {
            this.updateMultiblock();
            this.setCheckMultiblockTicks(0);
        }
        boolean isActive = !IItemHandlerKt.get((IItemHandler)this.getInput(), 0).func_190926_b() && !IItemHandlerKt.get((IItemHandler)this.getInput(), 1).func_190926_b() && this.getEnergyStorage().getEnergyStored() >= this.getEnergyPerTick();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!Intrinsics.areEqual((Object)state.func_177230_c(), (Object)((Object)ModBlocks.INSTANCE.getFusionController()))) {
            return;
        }
        PropertyPowerStatus currentStatus = (PropertyPowerStatus)((Object)state.func_177229_b((IProperty)ReactorControllerBlock.Companion.getSTATUS()));
        if (this.isMultiblockValid()) {
            if (isActive) {
                if (currentStatus != PropertyPowerStatus.ON) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)ReactorControllerBlock.Companion.getSTATUS(), (Comparable)((Object)PropertyPowerStatus.ON)));
                }
            } else if (currentStatus != PropertyPowerStatus.STANDBY) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)ReactorControllerBlock.Companion.getSTATUS(), (Comparable)((Object)PropertyPowerStatus.STANDBY)));
            }
            this.updateModifiers();
        } else if (currentStatus != PropertyPowerStatus.OFF) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)ReactorControllerBlock.Companion.getSTATUS(), (Comparable)((Object)PropertyPowerStatus.OFF)));
        }
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        compound.func_74757_a("singleMode", this.singleMode);
        return compound;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.singleMode = compound.func_74767_n("singleMode");
        super.func_145839_a(compound);
    }

    @Override
    @NotNull
    public IEnergyStorage getEnergyStorage() {
        return this.$$delegate_0.getEnergyStorage();
    }

    @Override
    public void setEnergyStorage(@NotNull IEnergyStorage iEnergyStorage) {
        Intrinsics.checkNotNullParameter((Object)iEnergyStorage, (String)"<set-?>");
        this.$$delegate_0.setEnergyStorage(iEnergyStorage);
    }

    @Override
    public int energyCapacity() {
        return this.$$delegate_0.energyCapacity();
    }
}

