/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.tiles;

import io.enderdev.alchemistry.ConfigHandler;
import io.enderdev.alchemistry.recipes.LiquifierRecipe;
import io.enderdev.alchemistry.recipes.register.LiquifierRegister;
import io.enderdev.alchemistry.tiles.AbstractMachine;
import io.enderdev.alchemistry.tiles.TileStackHandler;
import io.enderdev.alchemistry.tiles.tags.EnergyTileImpl;
import io.enderdev.alchemistry.tiles.tags.IEnergyTile;
import io.enderdev.alchemistry.tiles.tags.IFluidTile;
import io.enderdev.alchemistry.utils.extensions.IItemHandlerKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\t\u0010!\u001a\u00020\fH\u0096\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\"\u001a\u00020#X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lio/enderdev/alchemistry/tiles/TileLiquifier;", "Lio/enderdev/alchemistry/tiles/AbstractMachine;", "Lio/enderdev/alchemistry/recipes/LiquifierRecipe;", "Lio/enderdev/alchemistry/tiles/tags/IFluidTile;", "Lio/enderdev/alchemistry/tiles/tags/IEnergyTile;", "<init>", "()V", "outputTank", "Lnet/minecraftforge/fluids/FluidTank;", "getOutputTank", "()Lnet/minecraftforge/fluids/FluidTank;", "energyPerTick", "", "getEnergyPerTick", "()I", "recipeTime", "getRecipeTime", "fluidTanks", "Lnet/minecraftforge/fluids/capability/templates/FluidHandlerConcatenate;", "getFluidTanks", "()Lnet/minecraftforge/fluids/capability/templates/FluidHandlerConcatenate;", "initInventoryInputCapability", "", "updateRecipe", "onProcessComplete", "onWorkTick", "shouldTick", "", "shouldProcess", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "compound", "readFromNBT", "energyCapacity", "energyStorage", "Lnet/minecraftforge/energy/IEnergyStorage;", "getEnergyStorage", "()Lnet/minecraftforge/energy/IEnergyStorage;", "setEnergyStorage", "(Lnet/minecraftforge/energy/IEnergyStorage;)V", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nTileLiquifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileLiquifier.kt\nio/enderdev/alchemistry/tiles/TileLiquifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n295#2,2:95\n*S KotlinDebug\n*F\n+ 1 TileLiquifier.kt\nio/enderdev/alchemistry/tiles/TileLiquifier\n*L\n59#1:95,2\n*E\n"})
public final class TileLiquifier
extends AbstractMachine<LiquifierRecipe>
implements IFluidTile,
IEnergyTile {
    private final /* synthetic */ EnergyTileImpl $$delegate_0;
    @NotNull
    private final FluidTank outputTank;

    public TileLiquifier() {
        super(LiquifierRegister.Companion.getINSTANCE());
        this.$$delegate_0 = new EnergyTileImpl(ConfigHandler.LIQUIFIER.energyCapacity);
        this.initInventoryCapability(1, 0);
        this.outputTank = new FluidTank(){

            public boolean canFillFluidType(FluidStack fluid) {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = this.getRecipeRegister();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            LiquifierRecipe it = (LiquifierRecipe)element$iv;
                            boolean bl2 = false;
                            FluidStack fluidStack = fluid;
                            if (!Intrinsics.areEqual((Object)it.getOutput().getFluid(), (Object)(fluidStack != null ? fluidStack.getFluid() : null))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            protected void onContentsChanged() {
                this.markDirtyGUI();
            }
        };
        this.outputTank.setTileEntity((TileEntity)this);
        this.outputTank.setCanFill(false);
        this.outputTank.setCanDrain(true);
    }

    @NotNull
    public final FluidTank getOutputTank() {
        return this.outputTank;
    }

    @Override
    public int getEnergyPerTick() {
        return ConfigHandler.LIQUIFIER.energyPerTick;
    }

    @Override
    public int getRecipeTime() {
        return ConfigHandler.LIQUIFIER.processingTicks;
    }

    @Override
    @Nullable
    public FluidHandlerConcatenate getFluidTanks() {
        IFluidHandler[] iFluidHandlerArray = new IFluidHandler[]{this.outputTank};
        return new FluidHandlerConcatenate(iFluidHandlerArray);
    }

    @Override
    public void initInventoryInputCapability() {
        int n = this.getInputSlots();
        this.setInput(new TileStackHandler(this, n){
            final /* synthetic */ TileLiquifier this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $receiver);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    Iterable $this$any$iv = this.this$0.getRecipeRegister();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            LiquifierRecipe it = (LiquifierRecipe)element$iv;
                            boolean bl2 = false;
                            if (!it.getInput().func_77969_a(stack)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                ItemStack itemStack = bl ? super.insertItem(slot, stack, simulate) : stack;
                Intrinsics.checkNotNull((Object)itemStack);
                return itemStack;
            }

            protected void onContentsChanged(int slot) {
                this.this$0.markDirtyGUI();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateRecipe() {
        ItemStack inputStack;
        block4: {
            Object v2;
            TileLiquifier tileLiquifier;
            block3: {
                void $this$firstOrNull$iv;
                block5: {
                    ItemStack itemStack = this.getInput().getStackInSlot(0);
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
                    inputStack = itemStack;
                    if (inputStack.func_190926_b()) break block4;
                    if (this.getCurrentRecipe() == null) break block5;
                    Object t = this.getCurrentRecipe();
                    Intrinsics.checkNotNull(t);
                    if (ItemStack.func_77989_b((ItemStack)((LiquifierRecipe)t).getInput(), (ItemStack)inputStack)) break block4;
                }
                Iterable iterable = this.getRecipeRegister();
                tileLiquifier = this;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LiquifierRecipe it = (LiquifierRecipe)element$iv;
                    boolean bl = false;
                    if (!ItemStack.func_179545_c((ItemStack)it.getInput(), (ItemStack)inputStack)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            tileLiquifier.setCurrentRecipe(v2);
        }
        if (inputStack.func_190926_b()) {
            this.setCurrentRecipe(null);
        }
    }

    @Override
    public void onProcessComplete() {
        Object t = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t);
        this.outputTank.fillInternal(((LiquifierRecipe)t).getOutput().copy(), true);
        ItemStack itemStack = IItemHandlerKt.get((IItemHandler)this.getInput(), 0);
        Object t2 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t2);
        itemStack.func_190918_g(((LiquifierRecipe)t2).getInput().func_190916_E());
    }

    @Override
    public void onWorkTick() {
        this.getEnergyStorage().extractEnergy(this.getEnergyPerTick(), false);
    }

    @Override
    public boolean shouldTick() {
        return !IItemHandlerKt.get((IItemHandler)this.getInput(), 0).func_190926_b();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldProcess() {
        Object t = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t);
        FluidStack recipeOutput = ((LiquifierRecipe)t).getOutput();
        if (this.outputTank.getCapacity() < this.outputTank.getFluidAmount() + recipeOutput.amount) return false;
        if (this.getEnergyStorage().getEnergyStored() < this.getEnergyPerTick()) return false;
        int n = IItemHandlerKt.get((IItemHandler)this.getInput(), 0).func_190916_E();
        Object t2 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t2);
        if (n < ((LiquifierRecipe)t2).getInput().func_190916_E()) return false;
        FluidStack fluidStack = this.outputTank.getFluid();
        Object object2 = fluidStack != null ? fluidStack.getFluid() : null;
        object2 = recipeOutput.getFluid();
        if (object2 == null) {
            object2 = false;
        }
        if (Intrinsics.areEqual((Object)object, (Object)object2)) return true;
        if (this.outputTank.getFluid() != null) return false;
        return true;
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        compound.func_74782_a("OutputTankNBT", (NBTBase)this.outputTank.writeToNBT(new NBTTagCompound()));
        return compound;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.outputTank.readFromNBT(compound.func_74775_l("OutputTankNBT"));
    }

    @Override
    @NotNull
    public IEnergyStorage getEnergyStorage() {
        return this.$$delegate_0.getEnergyStorage();
    }

    @Override
    public void setEnergyStorage(@NotNull IEnergyStorage iEnergyStorage) {
        Intrinsics.checkNotNullParameter((Object)iEnergyStorage, (String)"<set-?>");
        this.$$delegate_0.setEnergyStorage(iEnergyStorage);
    }

    @Override
    public int energyCapacity() {
        return this.$$delegate_0.energyCapacity();
    }
}

