/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0005J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0014J6\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019JH\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lio/enderdev/alchemistry/utils/RenderUtils;", "", "<init>", "()V", "BLOCK_TEX", "Lnet/minecraft/util/ResourceLocation;", "getBLOCK_TEX", "()Lnet/minecraft/util/ResourceLocation;", "engine", "Lnet/minecraft/client/renderer/texture/TextureManager;", "bindBlockTexture", "", "bindTexture", "string", "", "tex", "getStillTexture", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "fluid", "Lnet/minecraftforge/fluids/FluidStack;", "Lnet/minecraftforge/fluids/Fluid;", "renderGuiTank", "tank", "Lnet/minecraftforge/fluids/FluidTank;", "x", "", "y", "zLevel", "width", "height", "capacity", "", "amount", "alchemistry"})
public final class RenderUtils {
    @NotNull
    public static final RenderUtils INSTANCE = new RenderUtils();
    @NotNull
    private static final ResourceLocation BLOCK_TEX;

    private RenderUtils() {
    }

    @NotNull
    public final ResourceLocation getBLOCK_TEX() {
        return BLOCK_TEX;
    }

    @NotNull
    public final TextureManager engine() {
        TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
        Intrinsics.checkNotNullExpressionValue((Object)textureManager, (String)"renderEngine");
        return textureManager;
    }

    public final void bindBlockTexture() {
        this.engine().func_110577_a(BLOCK_TEX);
    }

    public final void bindTexture(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.engine().func_110577_a(new ResourceLocation(string));
    }

    public final void bindTexture(@NotNull ResourceLocation tex) {
        Intrinsics.checkNotNullParameter((Object)tex, (String)"tex");
        this.engine().func_110577_a(tex);
    }

    @Nullable
    public final TextureAtlasSprite getStillTexture(@Nullable FluidStack fluid) {
        TextureAtlasSprite textureAtlasSprite;
        FluidStack fluidStack = fluid;
        if (fluidStack != null && (fluidStack = fluidStack.getFluid()) != null) {
            FluidStack it = fluidStack;
            boolean bl = false;
            textureAtlasSprite = INSTANCE.getStillTexture((Fluid)it);
        } else {
            textureAtlasSprite = null;
        }
        return textureAtlasSprite;
    }

    @Nullable
    public final TextureAtlasSprite getStillTexture(@NotNull Fluid fluid) {
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        ResourceLocation resourceLocation = fluid.getStill();
        if (resourceLocation == null) {
            return null;
        }
        ResourceLocation iconKey = resourceLocation;
        return Minecraft.func_71410_x().func_147117_R().getTextureExtry(String.valueOf(iconKey));
    }

    public final void renderGuiTank(@NotNull FluidTank tank, double x, double y, double zLevel, double width, double height) {
        Intrinsics.checkNotNullParameter((Object)tank, (String)"tank");
        this.renderGuiTank(tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, zLevel, width, height);
    }

    public final void renderGuiTank(@Nullable FluidStack fluid, int capacity, int amount, double x, double y, double zLevel, double width, double height) {
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            return;
        }
        TextureAtlasSprite textureAtlasSprite = this.getStillTexture(fluid);
        if (textureAtlasSprite == null) {
            return;
        }
        TextureAtlasSprite icon = textureAtlasSprite;
        int renderAmount = (int)RangesKt.coerceIn((double)height, (double)1.0, (double)((double)amount * height / (double)capacity));
        int posY = (int)(y + height - (double)renderAmount);
        this.bindBlockTexture();
        int color = fluid.getFluid().getColor(fluid);
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
        GlStateManager.func_179147_l();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)RangesKt.coerceAtMost((double)(width - (double)i), (double)16.0);
                int drawHeight = RangesKt.coerceAtMost((int)(renderAmount - j), (int)16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                double minU = icon.func_94209_e();
                double maxU = icon.func_94212_f();
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                tes.func_181662_b((double)drawX, (double)(drawY + drawHeight), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)drawHeight / (double)16.0f).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / (double)16.0f, minV + (maxV - minV) * (double)drawHeight / (double)16.0f).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)drawY, 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / (double)16.0f, minV).func_181675_d();
                tes.func_181662_b((double)drawX, (double)drawY, 0.0).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        GlStateManager.func_179084_k();
    }

    static {
        ResourceLocation resourceLocation = TextureMap.field_110575_b;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"LOCATION_BLOCKS_TEXTURE");
        BLOCK_TEX = resourceLocation;
    }
}

