/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.utils.extensions;

import io.enderdev.alchemistry.chemistry.ChemicalCompound;
import io.enderdev.alchemistry.chemistry.ChemicalElement;
import io.enderdev.alchemistry.chemistry.CompoundRegistry;
import io.enderdev.alchemistry.chemistry.ElementRegistry;
import io.enderdev.alchemistry.chemistry.ICompoundComponent;
import io.enderdev.alchemistry.utils.extensions.BlockKt;
import io.enderdev.alchemistry.utils.extensions.ItemKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b\u001a\u001e\u0010\n\u001a\u00020\u000b*\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b\u001a\u0012\u0010\f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0006*\u00020\u0002\u001a#\u0010\u0013\u001a\u00020\u0002*\u00020\u00022\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016\u00a2\u0006\u0002\u0010\u0017\"\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"toPotion", "Lnet/minecraft/potion/Potion;", "", "toOre", "Lnet/minecraftforge/oredict/OreIngredient;", "toStack", "Lnet/minecraft/item/ItemStack;", "quantity", "", "meta", "toIngredient", "Lnet/minecraft/item/crafting/Ingredient;", "toDict", "prefix", "firstOre", "serverSide", "", "getServerSide", "()Z", "translate", "format", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 String.kt\nio/enderdev/alchemistry/utils/extensions/StringKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class StringKt {
    private static final boolean serverSide = FMLCommonHandler.instance().getEffectiveSide().isServer();

    @NotNull
    public static final Potion toPotion(@NotNull String $this$toPotion) {
        Intrinsics.checkNotNullParameter((Object)$this$toPotion, (String)"<this>");
        Potion potion = Potion.func_180142_b((String)$this$toPotion);
        Intrinsics.checkNotNull((Object)potion);
        return potion;
    }

    @NotNull
    public static final OreIngredient toOre(@NotNull String $this$toOre) {
        Intrinsics.checkNotNullParameter((Object)$this$toOre, (String)"<this>");
        return new OreIngredient($this$toOre);
    }

    @NotNull
    public static final ItemStack toStack(@NotNull String $this$toStack, int quantity, int meta) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)$this$toStack, (String)"<this>");
        ICompoundComponent iCompoundComponent = ElementRegistry.INSTANCE.get($this$toStack);
        if (iCompoundComponent != null) {
            ChemicalElement $this$toStack_u24lambda_u240 = iCompoundComponent;
            boolean bl = false;
            return $this$toStack_u24lambda_u240.toItemStack(quantity);
        }
        iCompoundComponent = CompoundRegistry.INSTANCE.get($this$toStack);
        if (iCompoundComponent != null) {
            ICompoundComponent $this$toStack_u24lambda_u241 = iCompoundComponent;
            boolean bl = false;
            return ((ChemicalCompound)$this$toStack_u24lambda_u241).toItemStack(quantity);
        }
        char[] cArray = new char[]{':'};
        List split = StringsKt.split$default((CharSequence)$this$toStack, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String string = (String)CollectionsKt.getOrNull((List)split, (int)2);
        int meta2 = string != null ? Integer.parseInt(string) : meta;
        ResourceLocation location = split.size() == 1 ? new ResourceLocation($this$toStack) : new ResourceLocation((String)split.get(0), (String)split.get(1));
        Item bl = (Item)Item.field_150901_e.func_82594_a((Object)location);
        if (bl != null) {
            Item $this$toStack_u24lambda_u242 = bl;
            boolean bl2 = false;
            return ItemKt.toStack($this$toStack_u24lambda_u242, quantity, meta2);
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)location);
        if (block != null && !Intrinsics.areEqual((Object)block, (Object)Blocks.field_150350_a) && !Intrinsics.areEqual((Object)block, (Object)Blocks.field_150355_j)) {
            itemStack = BlockKt.toStack(block, quantity, meta2);
        } else {
            ItemStack itemStack2 = ItemStack.field_190927_a;
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
        }
        return itemStack;
    }

    public static /* synthetic */ ItemStack toStack$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 1;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return StringKt.toStack(string, n, n2);
    }

    @NotNull
    public static final Ingredient toIngredient(@NotNull String $this$toIngredient, int quantity, int meta) {
        Intrinsics.checkNotNullParameter((Object)$this$toIngredient, (String)"<this>");
        ItemStack[] itemStackArray = new ItemStack[]{StringKt.toStack($this$toIngredient, quantity, meta)};
        Ingredient ingredient = Ingredient.func_193369_a((ItemStack[])itemStackArray);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"fromStacks(...)");
        return ingredient;
    }

    public static /* synthetic */ Ingredient toIngredient$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 1;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return StringKt.toIngredient(string, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toDict(@NotNull String $this$toDict, @NotNull String prefix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toDict, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        StringBuilder stringBuilder = new StringBuilder().append(prefix);
        String string2 = $this$toDict;
        if (((CharSequence)string2).length() > 0) {
            void p0;
            char c = string2.charAt(0);
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            char c2 = Character.toUpperCase((char)p0);
            stringBuilder = stringBuilder2;
            c = c2;
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string3 = string4;
            string = c + string3;
        } else {
            string = string2;
        }
        return stringBuilder.append(string).toString();
    }

    @NotNull
    public static final ItemStack firstOre(@NotNull String $this$firstOre) {
        Intrinsics.checkNotNullParameter((Object)$this$firstOre, (String)"<this>");
        NonNullList nonNullList = OreDictionary.getOres((String)$this$firstOre);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"getOres(...)");
        ItemStack itemStack = (ItemStack)CollectionsKt.firstOrNull((List)((List)nonNullList));
        if (itemStack == null) {
            ItemStack itemStack2 = ItemStack.field_190927_a;
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
        }
        return itemStack;
    }

    public static final boolean getServerSide() {
        return serverSide;
    }

    @NotNull
    public static final String translate(@NotNull String $this$translate, Object ... format) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$translate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        if (serverSide) {
            string = $this$translate;
        } else {
            String string2 = I18n.func_135052_a((String)$this$translate, (Object[])Arrays.copyOf(format, format.length));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        }
        return string;
    }
}

