/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.blocks;

import io.enderdev.alchemistry.blocks.BaseBlock;
import io.enderdev.alchemistry.items.TooltipItemBlock;
import io.enderdev.alchemistry.utils.extensions.StringKt;
import java.util.Random;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockReed;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0017J(\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\"\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0017\u00a8\u0006%"}, d2={"Lio/enderdev/alchemistry/blocks/WetSandBlock;", "Lio/enderdev/alchemistry/blocks/BaseBlock;", "<init>", "()V", "registerItemBlock", "", "event", "Lnet/minecraftforge/event/RegistryEvent$Register;", "Lnet/minecraft/item/Item;", "canSustainPlant", "", "state", "Lnet/minecraft/block/state/IBlockState;", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "direction", "Lnet/minecraft/util/EnumFacing;", "plantable", "Lnet/minecraftforge/common/IPlantable;", "onBlockAdded", "worldIn", "Lnet/minecraft/world/World;", "neighborChanged", "blockIn", "Lnet/minecraft/block/Block;", "fromPos", "updateTick", "rand", "Ljava/util/Random;", "checkFallable", "tickRate", "", "canFallThrough", "randomDisplayTick", "stateIn", "alchemistry"})
public final class WetSandBlock
extends BaseBlock {
    public WetSandBlock() {
        Material material = Material.field_151595_p;
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"SAND");
        super("wet_sand", material);
        this.func_149711_c(0.5f);
        this.func_149752_b(1.0f);
        this.func_149672_a(SoundType.field_185855_h);
    }

    @Override
    public void registerItemBlock(@NotNull RegistryEvent.Register<Item> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        event.getRegistry().register(new TooltipItemBlock(this, StringKt.translate("tile.wet_sand.tooltip", new Object[0])).setRegistryName(this.getRegistryName()));
    }

    public boolean canSustainPlant(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing direction, @NotNull IPlantable plantable) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)plantable, (String)"plantable");
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        return plant.func_177230_c() instanceof BlockCactus || plant.func_177230_c() instanceof BlockReed;
    }

    public void func_176213_c(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    @Deprecated(message="")
    public void func_189540_a(@NotNull IBlockState state, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockIn, (String)"blockIn");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (!worldIn.field_72995_K) {
            this.checkFallable(worldIn, pos);
        }
    }

    private final void checkFallable(World worldIn, BlockPos pos) {
        block12: {
            block11: {
                block10: {
                    if (worldIn.func_175623_d(pos.func_177977_b())) break block10;
                    IBlockState iBlockState = worldIn.func_180495_p(pos.func_177977_b());
                    Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getBlockState(...)");
                    if (!this.canFallThrough(iBlockState)) break block11;
                }
                if (pos.func_177956_o() >= 0) break block12;
            }
            return;
        }
        if (worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos)));
            }
        } else {
            IBlockState state = worldIn.func_180495_p(pos);
            worldIn.func_175698_g(pos);
            BlockPos blockPos = pos.func_177977_b();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"down(...)");
            BlockPos blockpos = blockPos;
            while (true) {
                if (!worldIn.func_175623_d(blockpos)) {
                    IBlockState iBlockState = worldIn.func_180495_p(blockpos);
                    Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getBlockState(...)");
                    if (!this.canFallThrough(iBlockState)) break;
                }
                if (blockpos.func_177956_o() <= 0) break;
                Intrinsics.checkNotNullExpressionValue((Object)blockpos.func_177977_b(), (String)"down(...)");
            }
            if (blockpos.func_177956_o() > 0) {
                worldIn.func_175656_a(blockpos.func_177984_a(), state);
            }
        }
    }

    public int func_149738_a(@NotNull World worldIn) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        return 2;
    }

    public final boolean canFallThrough(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@NotNull IBlockState stateIn, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)stateIn, (String)"stateIn");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (rand.nextInt(16) == 0) {
            BlockPos blockpos = pos.func_177977_b();
            IBlockState iBlockState = worldIn.func_180495_p(blockpos);
            Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getBlockState(...)");
            if (this.canFallThrough(iBlockState)) {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (double)pos.func_177956_o() - 0.05;
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                int[] nArray = new int[]{Block.func_176210_f((IBlockState)stateIn)};
                worldIn.func_175688_a(EnumParticleTypes.FALLING_DUST, d0, d1, d2, 0.0, 0.0, 0.0, nArray);
            }
        }
    }
}

