/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.client.gui;

import io.enderdev.alchemistry.client.button.PauseButton;
import io.enderdev.alchemistry.client.button.RedstoneButton;
import io.enderdev.alchemistry.client.gui.wrappers.CapabilityDisplayWrapper;
import io.enderdev.alchemistry.client.gui.wrappers.CapabilityEnergyDisplayWrapper;
import io.enderdev.alchemistry.client.gui.wrappers.CapabilityFluidDisplayWrapper;
import io.enderdev.alchemistry.network.ButtonPacket;
import io.enderdev.alchemistry.network.PacketHandler;
import io.enderdev.alchemistry.tiles.AbstractMachine;
import io.enderdev.alchemistry.tiles.TileBase;
import io.enderdev.alchemistry.tiles.tags.IGuiTile;
import io.enderdev.alchemistry.utils.RenderUtils;
import io.enderdev.alchemistry.utils.extensions.IItemHandlerKt;
import io.enderdev.alchemistry.utils.extensions.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\b&\u0018\u0000*\u0010\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u00020\u00032\u00020\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u00104\u001a\u000205H\u0016J\u0018\u00106\u001a\u0002052\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0019H\u0016J \u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u00192\u0006\u0010;\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u0019H\u0016J(\u0010=\u001a\u0002052\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020\u0019H\u0016J \u0010C\u001a\u0002052\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u00192\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u0002052\u0006\u0010G\u001a\u00020HH\u0014J2\u0010I\u001a\u0002052\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u00192\u0006\u0010M\u001a\u00020\u00192\b\b\u0002\u0010N\u001a\u00020\u00192\b\b\u0002\u0010O\u001a\u00020\u0019J \u0010P\u001a\u0002052\u0006\u0010D\u001a\u00020E2\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0019H\u0014J\u0018\u0010Q\u001a\u0002052\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0019H\u0014J6\u0010R\u001a\u0002052\u0006\u0010S\u001a\u00020\u00192\u0006\u0010T\u001a\u00020\u00192\u0006\u0010U\u001a\u00020\u00192\u0006\u0010V\u001a\u00020\u00192\u0006\u0010W\u001a\u00020\u00192\u0006\u0010X\u001a\u00020\u0019J6\u0010Y\u001a\u00020Z2\u0006\u0010S\u001a\u00020\u00192\u0006\u0010T\u001a\u00020\u00192\u0006\u0010N\u001a\u00020\u00192\u0006\u0010O\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0019R\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u0014\u0010!\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0012R\u0014\u0010#\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001bR\u0014\u0010%\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u0006["}, d2={"Lio/enderdev/alchemistry/client/gui/GuiBase;", "T", "Lio/enderdev/alchemistry/tiles/AbstractMachine;", "Lio/enderdev/alchemistry/tiles/tags/IGuiTile;", "Lnet/minecraft/client/gui/inventory/GuiContainer;", "container", "Lnet/minecraft/inventory/Container;", "tile", "guiName", "", "<init>", "(Lnet/minecraft/inventory/Container;Lio/enderdev/alchemistry/tiles/AbstractMachine;Ljava/lang/String;)V", "getTile", "()Lio/enderdev/alchemistry/tiles/AbstractMachine;", "Lio/enderdev/alchemistry/tiles/AbstractMachine;", "textureLocation", "Lnet/minecraft/util/ResourceLocation;", "getTextureLocation", "()Lnet/minecraft/util/ResourceLocation;", "displayData", "", "Lio/enderdev/alchemistry/client/gui/wrappers/CapabilityDisplayWrapper;", "getDisplayData", "()Ljava/util/List;", "powerBarX", "", "getPowerBarX", "()I", "setPowerBarX", "(I)V", "powerBarY", "getPowerBarY", "setPowerBarY", "powerBarTexture", "getPowerBarTexture", "displayNameOffset", "getDisplayNameOffset", "displayName", "getDisplayName", "()Ljava/lang/String;", "pauseButton", "Lio/enderdev/alchemistry/client/button/PauseButton;", "getPauseButton", "()Lio/enderdev/alchemistry/client/button/PauseButton;", "setPauseButton", "(Lio/enderdev/alchemistry/client/button/PauseButton;)V", "redstoneButton", "Lio/enderdev/alchemistry/client/button/RedstoneButton;", "getRedstoneButton", "()Lio/enderdev/alchemistry/client/button/RedstoneButton;", "setRedstoneButton", "(Lio/enderdev/alchemistry/client/button/RedstoneButton;)V", "initGui", "", "renderTooltips", "mouseX", "mouseY", "getBarScaled", "pixels", "count", "max", "drawPowerBar", "storage", "Lio/enderdev/alchemistry/client/gui/wrappers/CapabilityEnergyDisplayWrapper;", "texture", "textureX", "textureY", "drawScreen", "partialTicks", "", "actionPerformed", "button", "Lnet/minecraft/client/gui/GuiButton;", "drawFluidTank", "wrapper", "Lio/enderdev/alchemistry/client/gui/wrappers/CapabilityFluidDisplayWrapper;", "i", "j", "width", "height", "drawGuiContainerBackgroundLayer", "drawGuiContainerForegroundLayer", "drawProgressBar", "x", "y", "u", "v", "w", "h", "isHovered", "", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nGuiBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiBase.kt\nio/enderdev/alchemistry/client/gui/GuiBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n774#2:185\n865#2,2:186\n1869#2,2:188\n1869#2,2:190\n*S KotlinDebug\n*F\n+ 1 GuiBase.kt\nio/enderdev/alchemistry/client/gui/GuiBase\n*L\n97#1:185\n97#1:186,2\n102#1:188,2\n137#1:190,2\n*E\n"})
public abstract class GuiBase<T extends AbstractMachine<?>>
extends GuiContainer {
    @NotNull
    private final T tile;
    @NotNull
    private final ResourceLocation textureLocation;
    @NotNull
    private final List<CapabilityDisplayWrapper> displayData;
    private int powerBarX;
    private int powerBarY;
    @NotNull
    private final ResourceLocation powerBarTexture;
    private final int displayNameOffset;
    @NotNull
    private final String displayName;
    public PauseButton pauseButton;
    public RedstoneButton redstoneButton;

    public GuiBase(@NotNull Container container, @NotNull T tile, @NotNull String guiName) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(tile, (String)"tile");
        Intrinsics.checkNotNullParameter((Object)guiName, (String)"guiName");
        super(container);
        this.tile = tile;
        this.textureLocation = new ResourceLocation("alchemistry", "textures/gui/container/" + guiName + "_gui_redox.png");
        this.displayData = new ArrayList();
        this.powerBarTexture = new ResourceLocation("alchemistry", "textures/gui/container/template_redox.png");
        this.displayNameOffset = 8;
        this.displayName = StringKt.translate("tile." + guiName + ".name", new Object[0]);
        this.field_146999_f = ((IGuiTile)this.tile).getGuiWidth();
        this.field_147000_g = ((IGuiTile)this.tile).getGuiHeight();
    }

    @NotNull
    public final T getTile() {
        return this.tile;
    }

    @NotNull
    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    @NotNull
    public final List<CapabilityDisplayWrapper> getDisplayData() {
        return this.displayData;
    }

    public int getPowerBarX() {
        return this.powerBarX;
    }

    public void setPowerBarX(int n) {
        this.powerBarX = n;
    }

    public int getPowerBarY() {
        return this.powerBarY;
    }

    public void setPowerBarY(int n) {
        this.powerBarY = n;
    }

    @NotNull
    public ResourceLocation getPowerBarTexture() {
        return this.powerBarTexture;
    }

    public int getDisplayNameOffset() {
        return this.displayNameOffset;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final PauseButton getPauseButton() {
        PauseButton pauseButton = this.pauseButton;
        if (pauseButton != null) {
            return pauseButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"pauseButton");
        return null;
    }

    public final void setPauseButton(@NotNull PauseButton pauseButton) {
        Intrinsics.checkNotNullParameter((Object)((Object)pauseButton), (String)"<set-?>");
        this.pauseButton = pauseButton;
    }

    @NotNull
    public final RedstoneButton getRedstoneButton() {
        RedstoneButton redstoneButton = this.redstoneButton;
        if (redstoneButton != null) {
            return redstoneButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"redstoneButton");
        return null;
    }

    public final void setRedstoneButton(@NotNull RedstoneButton redstoneButton) {
        Intrinsics.checkNotNullParameter((Object)((Object)redstoneButton), (String)"<set-?>");
        this.redstoneButton = redstoneButton;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.setPauseButton(new PauseButton(this.field_147003_i + 175 - 20, this.field_147009_r + this.getDisplayNameOffset() - 4));
        this.field_146292_n.add(this.getPauseButton());
        this.setRedstoneButton(new RedstoneButton(this.field_147003_i + 175 - 38, this.field_147009_r + this.getDisplayNameOffset() - 4));
        this.field_146292_n.add(this.getRedstoneButton());
    }

    public void renderTooltips(int mouseX, int mouseY) {
        if (this.isHovered(this.getPauseButton().getX(), this.getPauseButton().getY(), 16, 16, mouseX, mouseY)) {
            if (((AbstractMachine)this.tile).isPaused()) {
                this.func_146283_a(CollectionsKt.listOf((Object)StringKt.translate("tooltip.paused", new Object[0])), mouseX, mouseY);
            } else {
                this.func_146283_a(CollectionsKt.listOf((Object)StringKt.translate("tooltip.running", new Object[0])), mouseX, mouseY);
            }
        }
        if (this.isHovered(this.getRedstoneButton().getX(), this.getRedstoneButton().getY(), 16, 16, mouseX, mouseY)) {
            if (((AbstractMachine)this.tile).getNeedsPower()) {
                this.func_146283_a(CollectionsKt.listOf((Object)StringKt.translate("tooltip.redstone_high", new Object[0])), mouseX, mouseY);
            } else {
                this.func_146283_a(CollectionsKt.listOf((Object)StringKt.translate("tooltip.redstone_low", new Object[0])), mouseX, mouseY);
            }
        }
    }

    public int getBarScaled(int pixels, int count, int max) {
        return count > 0 && max > 0 ? count * pixels / max : 0;
    }

    public void drawPowerBar(@NotNull CapabilityEnergyDisplayWrapper storage, @NotNull ResourceLocation texture, int textureX, int textureY) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        int i = storage.getX() + (this.field_146294_l - this.field_146999_f) / 2;
        int j = storage.getY() + (this.field_146295_m - this.field_147000_g) / 2;
        int k = this.getBarScaled(storage.getHeight(), storage.getStored(), storage.getCapacity());
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        this.func_73729_b(i, j, textureX, textureY, storage.getWidth(), storage.getHeight());
        if (storage.getStored() > 0) {
            this.func_73729_b(i, j + storage.getHeight() - k, textureX + 16, textureY, storage.getWidth(), k);
        }
        this.field_146297_k.func_110434_K().func_110577_a(this.getTextureLocation());
    }

    /*
     * WARNING - void declaration
     */
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.renderTooltips(mouseX, mouseY);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        Iterable $this$filter$iv = this.displayData;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CapabilityDisplayWrapper data = (CapabilityDisplayWrapper)element$iv$iv;
            boolean bl = false;
            if (!(mouseX >= data.getX() + x && mouseX <= data.getX() + x + data.getWidth() && mouseY >= data.getY() + y && mouseY <= data.getY() + y + data.getHeight())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CapabilityDisplayWrapper it = (CapabilityDisplayWrapper)element$iv;
            boolean bl = false;
            this.drawHoveringText(it.toStringList(), mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void func_146284_a(@NotNull GuiButton button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        if (button.field_146127_k == this.getPauseButton().field_146127_k) {
            SimpleNetworkWrapper simpleNetworkWrapper = PacketHandler.INSTANCE.getINSTANCE();
            Intrinsics.checkNotNull((Object)simpleNetworkWrapper);
            BlockPos blockPos = ((TileEntity)this.tile).func_174877_v();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
            simpleNetworkWrapper.sendToServer((IMessage)new ButtonPacket(blockPos, true, false, false, false, 28, null));
        }
        if (button.field_146127_k == this.getRedstoneButton().field_146127_k) {
            SimpleNetworkWrapper simpleNetworkWrapper = PacketHandler.INSTANCE.getINSTANCE();
            Intrinsics.checkNotNull((Object)simpleNetworkWrapper);
            BlockPos blockPos = ((TileEntity)this.tile).func_174877_v();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
            simpleNetworkWrapper.sendToServer((IMessage)new ButtonPacket(blockPos, false, true, false, false, 26, null));
        }
    }

    public final void drawFluidTank(@NotNull CapabilityFluidDisplayWrapper wrapper, int i, int j, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        if (wrapper.getStored() > 5) {
            RenderUtils.INSTANCE.bindBlockTexture();
            RenderUtils.INSTANCE.renderGuiTank(wrapper.getFluid(), wrapper.getCapacity(), wrapper.getStored(), i, j, this.field_73735_i, width, height);
        }
        int i2 = wrapper.getX() + (this.field_146294_l - this.field_146999_f) / 2;
        int j2 = wrapper.getY() + (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(this.getPowerBarTexture());
        this.func_73729_b(i2, j2, 32, 0, 16, 70);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTextureLocation());
    }

    public static /* synthetic */ void drawFluidTank$default(GuiBase guiBase, CapabilityFluidDisplayWrapper capabilityFluidDisplayWrapper, int n, int n2, int n3, int n4, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: drawFluidTank");
        }
        if ((n5 & 8) != 0) {
            n3 = 16;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 70;
        }
        guiBase.drawFluidTank(capabilityFluidDisplayWrapper, n, n2, n3, n4);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTextureLocation());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        Iterable $this$forEach$iv = this.displayData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CapabilityDisplayWrapper data = (CapabilityDisplayWrapper)element$iv;
            boolean bl = false;
            CapabilityDisplayWrapper capabilityDisplayWrapper = data;
            if (capabilityDisplayWrapper instanceof CapabilityEnergyDisplayWrapper) {
                this.drawPowerBar((CapabilityEnergyDisplayWrapper)data, this.getPowerBarTexture(), this.getPowerBarX(), this.getPowerBarY());
                continue;
            }
            if (!(capabilityDisplayWrapper instanceof CapabilityFluidDisplayWrapper)) continue;
            GuiBase.drawFluidTank$default(this, (CapabilityFluidDisplayWrapper)data, i + data.getX(), j + data.getY(), 0, 0, 24, null);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (((AbstractMachine)this.tile).isPaused()) {
            this.getPauseButton().setPaused(PauseButton.State.PAUSED);
        } else {
            this.getPauseButton().setPaused(PauseButton.State.RUNNING);
        }
        if (((AbstractMachine)this.tile).getNeedsPower()) {
            this.getRedstoneButton().setNeedsPower(RedstoneButton.State.ON);
        } else {
            this.getRedstoneButton().setNeedsPower(RedstoneButton.State.OFF);
        }
        if (((CharSequence)this.getDisplayName()).length() > 0) {
            this.field_146289_q.func_78276_b(this.getDisplayName(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.getDisplayName()) / 2, this.getDisplayNameOffset(), 0x404040);
        }
    }

    public final void drawProgressBar(int x, int y, int u, int v, int w, int h) {
        this.field_146297_k.func_110434_K().func_110577_a(this.getTextureLocation());
        int i = this.field_146294_l - this.field_146999_f >> 1;
        int j = this.field_146295_m - this.field_147000_g >> 1;
        if (((AbstractMachine)this.tile).getRecipeTime() == 0 && !IItemHandlerKt.get((IItemHandler)((TileBase)((Object)this.tile)).getInput(), 0).func_190926_b()) {
            this.func_73729_b(x + i, y + j, u, v, w, h);
        } else if (((AbstractMachine)this.tile).getProgressTicks() > 0) {
            int k = this.getBarScaled(w, ((AbstractMachine)this.tile).getProgressTicks(), ((AbstractMachine)this.tile).getRecipeTime());
            this.func_73729_b(x + i, y + j, u, v, k, h);
        }
    }

    public final boolean isHovered(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }
}

