/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.crafting;

import io.enderdev.alchemistry.chemistry.ChemicalCompound;
import io.enderdev.alchemistry.chemistry.CompoundRegistry;
import io.enderdev.alchemistry.items.ItemCompound;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/enderdev/alchemistry/crafting/SaltyFoodHandler;", "Lnet/minecraftforge/registries/IForgeRegistryEntry$Impl;", "Lnet/minecraft/item/crafting/IRecipe;", "<init>", "()V", "resultItem", "Lnet/minecraft/item/ItemStack;", "kotlin.jvm.PlatformType", "canFit", "", "width", "", "height", "getRecipeOutput", "getCraftingResult", "inv", "Lnet/minecraft/inventory/InventoryCrafting;", "isDynamic", "matches", "world", "Lnet/minecraft/world/World;", "alchemistry"})
public final class SaltyFoodHandler
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private ItemStack resultItem;

    public SaltyFoodHandler() {
        this.setRegistryName("alchemistry", "salty_food_handler");
        this.resultItem = ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public ItemStack func_77571_b() {
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull InventoryCrafting inv) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        ItemStack itemStack = this.resultItem.func_77946_l();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        return itemStack;
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_77569_a(@NotNull InventoryCrafting inv, @Nullable World world) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        ItemStack food = ItemStack.field_190927_a;
        int countSalt = 0;
        int n = inv.func_70302_i_();
        for (int i = 0; i < n; ++i) {
            ItemStack currentStack = inv.func_70301_a(i);
            if (currentStack.func_190926_b()) continue;
            if (currentStack.func_77973_b() instanceof ItemFood && currentStack.func_77942_o()) {
                NBTTagCompound nBTTagCompound = currentStack.func_77978_p();
                if (nBTTagCompound != null ? nBTTagCompound.func_74764_b("alchemistryPotion") : false) {
                    food = currentStack;
                    continue;
                }
            }
            if (currentStack.func_77973_b() instanceof ItemCompound) {
                int n2 = currentStack.func_77960_j();
                ChemicalCompound chemicalCompound = CompoundRegistry.INSTANCE.get("sodium_chloride");
                Intrinsics.checkNotNull((Object)chemicalCompound);
                if (n2 == chemicalCompound.getMeta()) {
                    ++countSalt;
                    continue;
                }
            }
            return false;
        }
        if (!food.func_190926_b() && countSalt == 8) {
            ItemStack itemStack = food.func_77946_l();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            ItemStack tempResult = itemStack;
            tempResult.func_190920_e(1);
            NBTTagCompound nBTTagCompound = tempResult.func_77978_p();
            Intrinsics.checkNotNull((Object)nBTTagCompound);
            nBTTagCompound.func_74757_a("alchemistrySalted", true);
            this.resultItem = tempResult;
            return true;
        }
        return false;
    }
}

