/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.tiles;

import io.enderdev.alchemistry.Alchemistry;
import io.enderdev.alchemistry.ConfigHandler;
import io.enderdev.alchemistry.blocks.machine.ReactorControllerBlock;
import io.enderdev.alchemistry.client.BlockHighlighter;
import io.enderdev.alchemistry.recipes.IRecipe;
import io.enderdev.alchemistry.recipes.register.AbstractRecipeRegister;
import io.enderdev.alchemistry.tiles.AbstractMachine;
import io.enderdev.alchemistry.tiles.ReactorShapeHandler;
import io.enderdev.alchemistry.tiles.ReactorType;
import io.enderdev.alchemistry.tiles.tags.IEnergyTile;
import io.enderdev.alchemistry.utils.BlockMeta;
import io.enderdev.alchemistry.utils.ConfigUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004:\u0001?B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010'\u001a\u0004\u0018\u00010(J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u001dJ\u0006\u0010,\u001a\u00020*J\u0019\u0010-\u001a\u00020*2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020/0.\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020\"J\u000e\u00103\u001a\u00020\"2\u0006\u00102\u001a\u00020\"J\u001e\u00104\u001a\u00020\u001d2\n\u00105\u001a\u0006\u0012\u0002\b\u0003062\b\u00107\u001a\u0004\u0018\u00010(H\u0016J1\u00108\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0001\u0010\u0001*\u0002092\f\u00105\u001a\b\u0012\u0004\u0012\u0002H\u0001062\b\u00107\u001a\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<H\u0016J\u0010\u0010>\u001a\u00020*2\u0006\u0010=\u001a\u00020<H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006@"}, d2={"Lio/enderdev/alchemistry/tiles/AbstractReactorController;", "T", "Lio/enderdev/alchemistry/recipes/IRecipe;", "Lio/enderdev/alchemistry/tiles/AbstractMachine;", "Lio/enderdev/alchemistry/tiles/tags/IEnergyTile;", "reactorType", "Lio/enderdev/alchemistry/tiles/ReactorType;", "recipeRegister", "Lio/enderdev/alchemistry/recipes/register/AbstractRecipeRegister;", "<init>", "(Lio/enderdev/alchemistry/tiles/ReactorType;Lio/enderdev/alchemistry/recipes/register/AbstractRecipeRegister;)V", "getReactorType", "()Lio/enderdev/alchemistry/tiles/ReactorType;", "shapeHandler", "Lio/enderdev/alchemistry/tiles/ReactorShapeHandler;", "getShapeHandler", "()Lio/enderdev/alchemistry/tiles/ReactorShapeHandler;", "moderators", "", "Lio/enderdev/alchemistry/utils/BlockMeta;", "Lio/enderdev/alchemistry/tiles/AbstractReactorController$Multiplier;", "getModerators", "()Ljava/util/Map;", "currentMultiplier", "getCurrentMultiplier", "()Lio/enderdev/alchemistry/tiles/AbstractReactorController$Multiplier;", "setCurrentMultiplier", "(Lio/enderdev/alchemistry/tiles/AbstractReactorController$Multiplier;)V", "isMultiblockValid", "", "()Z", "setMultiblockValid", "(Z)V", "checkMultiblockTicks", "", "getCheckMultiblockTicks", "()I", "setCheckMultiblockTicks", "(I)V", "getFacing", "Lnet/minecraft/util/EnumFacing;", "updateMultiblock", "", "validateMultiblock", "updateModifiers", "loadConfig", "", "", "([Ljava/lang/String;)V", "getModifiedProcessTime", "default", "getModifiedEnergyCost", "hasCapability", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "getCapability", "", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "compound", "readFromNBT", "Multiplier", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nAbstractReactorController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractReactorController.kt\nio/enderdev/alchemistry/tiles/AbstractReactorController\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,124:1\n126#2:125\n153#2,2:126\n155#2:130\n1869#3,2:128\n13472#4,2:131\n*S KotlinDebug\n*F\n+ 1 AbstractReactorController.kt\nio/enderdev/alchemistry/tiles/AbstractReactorController\n*L\n42#1:125\n42#1:126,2\n42#1:130\n43#1:128,2\n69#1:131,2\n*E\n"})
public abstract class AbstractReactorController<T extends IRecipe>
extends AbstractMachine<T>
implements IEnergyTile {
    @NotNull
    private final ReactorType reactorType;
    @NotNull
    private final ReactorShapeHandler shapeHandler;
    @NotNull
    private final Map<BlockMeta, Multiplier> moderators;
    @NotNull
    private Multiplier currentMultiplier;
    private boolean isMultiblockValid;
    private int checkMultiblockTicks;

    public AbstractReactorController(@NotNull ReactorType reactorType, @NotNull AbstractRecipeRegister<T> recipeRegister) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactorType), (String)"reactorType");
        Intrinsics.checkNotNullParameter(recipeRegister, (String)"recipeRegister");
        super(recipeRegister);
        this.reactorType = reactorType;
        this.shapeHandler = new ReactorShapeHandler(this);
        this.moderators = new LinkedHashMap();
        this.currentMultiplier = new Multiplier(0.0, 0.0, 0.0, 7, null);
    }

    @NotNull
    public final ReactorType getReactorType() {
        return this.reactorType;
    }

    @NotNull
    public final ReactorShapeHandler getShapeHandler() {
        return this.shapeHandler;
    }

    @NotNull
    public final Map<BlockMeta, Multiplier> getModerators() {
        return this.moderators;
    }

    @NotNull
    public final Multiplier getCurrentMultiplier() {
        return this.currentMultiplier;
    }

    public final void setCurrentMultiplier(@NotNull Multiplier multiplier) {
        Intrinsics.checkNotNullParameter((Object)multiplier, (String)"<set-?>");
        this.currentMultiplier = multiplier;
    }

    public final boolean isMultiblockValid() {
        return this.isMultiblockValid;
    }

    public final void setMultiblockValid(boolean bl) {
        this.isMultiblockValid = bl;
    }

    public final int getCheckMultiblockTicks() {
        return this.checkMultiblockTicks;
    }

    public final void setCheckMultiblockTicks(int n) {
        this.checkMultiblockTicks = n;
    }

    @Nullable
    public final EnumFacing getFacing() {
        World world = this.field_145850_b;
        return world != null && (world = world.func_180495_p(this.field_174879_c)) != null ? (EnumFacing)world.func_177229_b((IProperty)ReactorControllerBlock.Companion.getFACING()) : null;
    }

    /*
     * Unable to fully structure code
     */
    public final void updateMultiblock() {
        if (this.isMultiblockValid) ** GOTO lbl-1000
        v0 = this.field_145850_b;
        v1 = v0 != null ? v0.field_72995_K : false;
        if (v1 && this.shapeHandler.getFailPos() != null && Intrinsics.areEqual((Object)BlockHighlighter.Companion.getPos(), (Object)this.shapeHandler.getFailPos())) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        highlight = v2;
        this.isMultiblockValid = this.validateMultiblock();
        if (!this.isMultiblockValid && highlight && !Intrinsics.areEqual((Object)BlockHighlighter.Companion.getPos(), (Object)this.shapeHandler.getFailPos())) {
            this.shapeHandler.highlightIncorrect();
        }
    }

    public final boolean validateMultiblock() {
        return this.shapeHandler.validate();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateModifiers() {
        void $this$mapTo$iv$iv;
        Map<IBlockState, Integer> blocks = this.shapeHandler.countInside();
        this.currentMultiplier.reset();
        Map<IBlockState, Integer> $this$map$iv = blocks;
        boolean $i$f$map = false;
        Map<IBlockState, Integer> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IBlockState state = (IBlockState)entry.getKey();
            int cnt = ((Number)entry.getValue()).intValue();
            Iterable $this$forEach$iv = this.moderators.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry2 = (Map.Entry)element$iv;
                boolean bl2 = false;
                BlockMeta wanted = (BlockMeta)entry2.getKey();
                Multiplier mod = (Multiplier)entry2.getValue();
                if (!Intrinsics.areEqual((Object)wanted, (Object)state)) continue;
                Multiplier multiplier = this.currentMultiplier;
                multiplier.setProductivity(multiplier.getProductivity() + mod.getProductivity() * (double)cnt);
                multiplier = this.currentMultiplier;
                multiplier.setProcessingTime(multiplier.getProcessingTime() + mod.getProcessingTime() * (double)cnt);
                multiplier = this.currentMultiplier;
                multiplier.setEnergy(multiplier.getEnergy() + mod.getEnergy() * (double)cnt);
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    public final void loadConfig(@NotNull String[] moderators) {
        Intrinsics.checkNotNullParameter((Object)moderators, (String)"moderators");
        this.moderators.clear();
        String[] $this$forEach$iv = moderators;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            StringTokenizer tokenizer = new StringTokenizer(it, ";");
            try {
                BlockMeta block;
                String string2 = tokenizer.nextToken();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextToken(...)");
                if (ConfigUtils.INSTANCE.parseBlock(string2) == null) continue;
                String string3 = tokenizer.nextToken();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"nextToken(...)");
                double d = Double.parseDouble(string3);
                String string4 = tokenizer.nextToken();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"nextToken(...)");
                double d2 = Double.parseDouble(string4);
                String string5 = tokenizer.nextToken();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"nextToken(...)");
                this.moderators.put(block, new Multiplier(d, d2, Double.parseDouble(string5)));
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                Logger logger = Alchemistry.INSTANCE.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("Invalid ");
                string = this.reactorType.name();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string6 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                logger.error(stringBuilder.append(string6).append(" moderator entry, expected 4 columns separated by semicolons `;` but got: '").append(it).append('\'').toString());
                if (!StringsKt.contains$default((CharSequence)it, (char)',', (boolean)false, (int)2, null)) continue;
                Alchemistry.INSTANCE.getLogger().error("(You're most likely accidentally using commas `,` instead of semicolons `;`)");
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                Logger logger = Alchemistry.INSTANCE.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("Invalid ");
                string = this.reactorType.name();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string7 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                logger.error(stringBuilder.append(string7).append(" moderator entry, expected 3 last columns to be numbers but got: '").append(it).append('\'').toString());
            }
        }
    }

    public final int getModifiedProcessTime(int n) {
        return RangesKt.coerceAtLeast((int)MathKt.roundToInt((double)((double)n * this.currentMultiplier.getProcessingTime())), (int)0);
    }

    public final int getModifiedEnergyCost(int n) {
        return RangesKt.coerceAtLeast((int)MathKt.roundToInt((double)((double)n * this.currentMultiplier.getEnergy())), (int)(this.reactorType == ReactorType.FISSION ? ConfigHandler.FISSION.minEnergyPerTick : ConfigHandler.FUSION.minEnergyPerTick));
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        return this.isMultiblockValid ? super.hasCapability(capability, facing) : false;
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        return this.isMultiblockValid ? (T)super.getCapability(capability, facing) : null;
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        compound.func_74768_a("ProgressTicks", this.getProgressTicks());
        compound.func_74780_a("productivityMult", this.currentMultiplier.getProductivity());
        compound.func_74780_a("processingTimeMult", this.currentMultiplier.getProcessingTime());
        compound.func_74780_a("energyMult", this.currentMultiplier.getEnergy());
        return compound;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.setProgressTicks(compound.func_74762_e("ProgressTicks"));
        this.currentMultiplier = new Multiplier(compound.func_74769_h("productivityMult"), compound.func_74769_h("processingTimeMult"), compound.func_74769_h("energyMult"));
        this.updateMultiblock();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lio/enderdev/alchemistry/tiles/AbstractReactorController$Multiplier;", "", "productivity", "", "processingTime", "energy", "<init>", "(DDD)V", "getProductivity", "()D", "setProductivity", "(D)V", "getProcessingTime", "setProcessingTime", "getEnergy", "setEnergy", "reset", "", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "alchemistry"})
    public static final class Multiplier {
        private double productivity;
        private double processingTime;
        private double energy;

        public Multiplier(double productivity, double processingTime, double energy) {
            this.productivity = productivity;
            this.processingTime = processingTime;
            this.energy = energy;
        }

        public /* synthetic */ Multiplier(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                d = 1.0;
            }
            if ((n & 2) != 0) {
                d2 = 1.0;
            }
            if ((n & 4) != 0) {
                d3 = 1.0;
            }
            this(d, d2, d3);
        }

        public final double getProductivity() {
            return this.productivity;
        }

        public final void setProductivity(double d) {
            this.productivity = d;
        }

        public final double getProcessingTime() {
            return this.processingTime;
        }

        public final void setProcessingTime(double d) {
            this.processingTime = d;
        }

        public final double getEnergy() {
            return this.energy;
        }

        public final void setEnergy(double d) {
            this.energy = d;
        }

        public final void reset() {
            this.productivity = 1.0;
            this.processingTime = 1.0;
            this.energy = 1.0;
        }

        public final double component1() {
            return this.productivity;
        }

        public final double component2() {
            return this.processingTime;
        }

        public final double component3() {
            return this.energy;
        }

        @NotNull
        public final Multiplier copy(double productivity, double processingTime, double energy) {
            return new Multiplier(productivity, processingTime, energy);
        }

        public static /* synthetic */ Multiplier copy$default(Multiplier multiplier, double d, double d2, double d3, int n, Object object) {
            if ((n & 1) != 0) {
                d = multiplier.productivity;
            }
            if ((n & 2) != 0) {
                d2 = multiplier.processingTime;
            }
            if ((n & 4) != 0) {
                d3 = multiplier.energy;
            }
            return multiplier.copy(d, d2, d3);
        }

        @NotNull
        public String toString() {
            return "Multiplier(productivity=" + this.productivity + ", processingTime=" + this.processingTime + ", energy=" + this.energy + ')';
        }

        public int hashCode() {
            int result = Double.hashCode(this.productivity);
            result = result * 31 + Double.hashCode(this.processingTime);
            result = result * 31 + Double.hashCode(this.energy);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Multiplier)) {
                return false;
            }
            Multiplier multiplier = (Multiplier)other;
            if (Double.compare(this.productivity, multiplier.productivity) != 0) {
                return false;
            }
            if (Double.compare(this.processingTime, multiplier.processingTime) != 0) {
                return false;
            }
            return Double.compare(this.energy, multiplier.energy) == 0;
        }

        public Multiplier() {
            this(0.0, 0.0, 0.0, 7, null);
        }
    }
}

