/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.tiles;

import io.enderdev.alchemistry.ConfigHandler;
import io.enderdev.alchemistry.tiles.TileStackHandler;
import io.enderdev.alchemistry.tiles.WrappedItemHandler;
import io.enderdev.alchemistry.tiles.tags.IEnergyTile;
import io.enderdev.alchemistry.tiles.tags.IFluidTile;
import io.enderdev.alchemistry.tiles.tags.IItemTile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u0000 ]2\u00020\u0001:\u0001]B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J(\u00100\u001a\u00020-2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0016J\u0016\u00108\u001a\u0002092\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\b\u0010:\u001a\u000209H\u0016J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020>H\u0016J\u0018\u0010?\u001a\u0002092\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020>H\u0016J\u0006\u0010C\u001a\u000209J\u000e\u0010D\u001a\u0002092\u0006\u0010E\u001a\u00020\u0005J\u000e\u0010F\u001a\u0002092\u0006\u0010E\u001a\u00020\u0005J\u0006\u0010G\u001a\u000209J\u000e\u0010H\u001a\u0002092\u0006\u0010E\u001a\u00020\u0005J\u0010\u0010I\u001a\u0002092\u0006\u0010J\u001a\u00020<H\u0016J\u0010\u0010K\u001a\u00020<2\u0006\u0010J\u001a\u00020<H\u0016JP\u0010L\u001a\u00020-2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010M\u001a\u0002062\u0006\u0010.\u001a\u00020/2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020S2\u0006\u0010U\u001a\u00020SH\u0016J\u001e\u0010V\u001a\u00020-2\n\u0010W\u001a\u0006\u0012\u0002\b\u00030X2\b\u0010P\u001a\u0004\u0018\u00010QH\u0016J1\u0010Y\u001a\u0004\u0018\u0001HZ\"\b\b\u0000\u0010Z*\u00020[2\f\u0010W\u001a\b\u0012\u0004\u0012\u0002HZ0X2\b\u0010P\u001a\u0004\u0018\u00010QH\u0016\u00a2\u0006\u0002\u0010\\R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\tR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010\u0017R\u001a\u0010!\u001a\u00020\u0019X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006^"}, d2={"Lio/enderdev/alchemistry/tiles/TileBase;", "Lnet/minecraft/tileentity/TileEntity;", "<init>", "()V", "inputSlots", "", "getInputSlots", "()I", "setInputSlots", "(I)V", "outputSlots", "getOutputSlots", "setOutputSlots", "SIZE", "getSIZE", "dirtyTicks", "getDirtyTicks", "setDirtyTicks", "input", "Lio/enderdev/alchemistry/tiles/TileStackHandler;", "getInput", "()Lio/enderdev/alchemistry/tiles/TileStackHandler;", "setInput", "(Lio/enderdev/alchemistry/tiles/TileStackHandler;)V", "automationInput", "Lnet/minecraftforge/items/IItemHandlerModifiable;", "getAutomationInput", "()Lnet/minecraftforge/items/IItemHandlerModifiable;", "setAutomationInput", "(Lnet/minecraftforge/items/IItemHandlerModifiable;)V", "output", "getOutput", "setOutput", "automationOutput", "getAutomationOutput", "setAutomationOutput", "inventory", "Lnet/minecraftforge/items/IItemHandler;", "getInventory", "()Lnet/minecraftforge/items/IItemHandler;", "automationInvHandler", "Lnet/minecraftforge/items/wrapper/CombinedInvWrapper;", "getAutomationInvHandler", "()Lnet/minecraftforge/items/wrapper/CombinedInvWrapper;", "canInteractWith", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "shouldRefresh", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "oldState", "Lnet/minecraft/block/state/IBlockState;", "newState", "initInventoryCapability", "", "initInventoryInputCapability", "getUpdateTag", "Lnet/minecraft/nbt/NBTTagCompound;", "getUpdatePacket", "Lnet/minecraft/network/play/server/SPacketUpdateTileEntity;", "onDataPacket", "net", "Lnet/minecraft/network/NetworkManager;", "pkt", "markDirtyClient", "markDirtyClientEvery", "ticks", "markDirtyEvery", "markDirtyGUI", "markDirtyGUIEvery", "readFromNBT", "compound", "writeToNBT", "onBlockActivated", "state", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "hasCapability", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "getCapability", "T", "", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "Companion", "alchemistry"})
public abstract class TileBase
extends TileEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int inputSlots;
    private int outputSlots;
    private int dirtyTicks;
    public TileStackHandler input;
    protected IItemHandlerModifiable automationInput;
    public TileStackHandler output;
    protected IItemHandlerModifiable automationOutput;
    @NotNull
    private static final Capability<IEnergyStorage> ENERGY_CAP;
    @NotNull
    private static final Capability<IItemHandler> ITEM_CAP;
    @NotNull
    private static final Capability<IFluidHandler> FLUID_CAP;

    public final int getInputSlots() {
        return this.inputSlots;
    }

    public final void setInputSlots(int n) {
        this.inputSlots = n;
    }

    public final int getOutputSlots() {
        return this.outputSlots;
    }

    public final void setOutputSlots(int n) {
        this.outputSlots = n;
    }

    public int getSIZE() {
        return this.getInventory().getSlots();
    }

    public final int getDirtyTicks() {
        return this.dirtyTicks;
    }

    public final void setDirtyTicks(int n) {
        this.dirtyTicks = n;
    }

    @NotNull
    public final TileStackHandler getInput() {
        TileStackHandler tileStackHandler = this.input;
        if (tileStackHandler != null) {
            return tileStackHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"input");
        return null;
    }

    public final void setInput(@NotNull TileStackHandler tileStackHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)tileStackHandler), (String)"<set-?>");
        this.input = tileStackHandler;
    }

    @NotNull
    protected final IItemHandlerModifiable getAutomationInput() {
        IItemHandlerModifiable iItemHandlerModifiable = this.automationInput;
        if (iItemHandlerModifiable != null) {
            return iItemHandlerModifiable;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"automationInput");
        return null;
    }

    protected final void setAutomationInput(@NotNull IItemHandlerModifiable iItemHandlerModifiable) {
        Intrinsics.checkNotNullParameter((Object)iItemHandlerModifiable, (String)"<set-?>");
        this.automationInput = iItemHandlerModifiable;
    }

    @NotNull
    public final TileStackHandler getOutput() {
        TileStackHandler tileStackHandler = this.output;
        if (tileStackHandler != null) {
            return tileStackHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"output");
        return null;
    }

    public final void setOutput(@NotNull TileStackHandler tileStackHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)tileStackHandler), (String)"<set-?>");
        this.output = tileStackHandler;
    }

    @NotNull
    protected final IItemHandlerModifiable getAutomationOutput() {
        IItemHandlerModifiable iItemHandlerModifiable = this.automationOutput;
        if (iItemHandlerModifiable != null) {
            return iItemHandlerModifiable;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"automationOutput");
        return null;
    }

    protected final void setAutomationOutput(@NotNull IItemHandlerModifiable iItemHandlerModifiable) {
        Intrinsics.checkNotNullParameter((Object)iItemHandlerModifiable, (String)"<set-?>");
        this.automationOutput = iItemHandlerModifiable;
    }

    @NotNull
    public IItemHandler getInventory() {
        IItemHandlerModifiable[] iItemHandlerModifiableArray = new IItemHandlerModifiable[]{this.getInput(), this.getOutput()};
        return (IItemHandler)new CombinedInvWrapper(iItemHandlerModifiableArray);
    }

    @NotNull
    public CombinedInvWrapper getAutomationInvHandler() {
        IItemHandlerModifiable[] iItemHandlerModifiableArray = new IItemHandlerModifiable[]{this.getAutomationInput(), this.getAutomationOutput()};
        return new CombinedInvWrapper(iItemHandlerModifiableArray);
    }

    public final boolean canInteractWith(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return !this.func_145837_r() && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean shouldRefresh(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState oldState, @NotNull IBlockState newState) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        return !Intrinsics.areEqual((Object)oldState.func_177230_c(), (Object)newState.func_177230_c());
    }

    public final void initInventoryCapability(int inputSlots, int outputSlots) {
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.initInventoryInputCapability();
        TileStackHandler tileStackHandler = this.getInput();
        this.setAutomationInput(new WrappedItemHandler(tileStackHandler){

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }
        });
        this.setOutput(new TileStackHandler(outputSlots, this){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return stack;
            }
        });
        tileStackHandler = this.getOutput();
        this.setAutomationOutput(new WrappedItemHandler(tileStackHandler){

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return !this.getStackInSlot(slot).func_190926_b() ? super.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
            }
        });
    }

    public void initInventoryInputCapability() {
        this.setInput(new TileStackHandler(this.inputSlots, this));
    }

    @NotNull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @NotNull
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(@NotNull NetworkManager net, @NotNull SPacketUpdateTileEntity pkt) {
        Intrinsics.checkNotNullParameter((Object)net, (String)"net");
        Intrinsics.checkNotNullParameter((Object)pkt, (String)"pkt");
        NBTTagCompound nBTTagCompound = pkt.func_148857_g();
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"getNbtCompound(...)");
        this.func_145839_a(nBTTagCompound);
    }

    public final void markDirtyClient() {
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public final void markDirtyClientEvery(int ticks) {
        int n = this.dirtyTicks;
        this.dirtyTicks = n + 1;
        if (this.dirtyTicks >= ticks) {
            this.markDirtyClient();
            this.dirtyTicks = 0;
        }
    }

    public final void markDirtyEvery(int ticks) {
        int n = this.dirtyTicks;
        this.dirtyTicks = n + 1;
        if (this.dirtyTicks >= ticks) {
            this.func_70296_d();
            this.dirtyTicks = 0;
        }
    }

    public final void markDirtyGUI() {
        block0: {
            this.func_70296_d();
            World world = this.field_145850_b;
            if (world == null) break block0;
            World it = world;
            boolean bl = false;
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 6);
        }
    }

    public final void markDirtyGUIEvery(int ticks) {
        int n = this.dirtyTicks;
        this.dirtyTicks = n + 1;
        if (this.dirtyTicks >= ticks) {
            this.markDirtyGUI();
            this.dirtyTicks = 0;
        }
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        if (this instanceof IEnergyTile) {
            int energyStored = compound.func_74762_e("EnergyStored");
            ((IEnergyTile)((Object)this)).setEnergyStorage((IEnergyStorage)new EnergyStorage(((IEnergyTile)((Object)this)).energyCapacity()));
            ((IEnergyTile)((Object)this)).getEnergyStorage().receiveEnergy(energyStored, false);
        }
        if (this instanceof IItemTile) {
            this.getInput().deserializeNBT(compound.func_74775_l("input"));
            this.getOutput().deserializeNBT(compound.func_74775_l("output"));
        }
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        if (this instanceof IEnergyTile) {
            compound.func_74768_a("EnergyStored", ((IEnergyTile)((Object)this)).getEnergyStorage().getEnergyStored());
        }
        if (this instanceof IItemTile) {
            compound.func_74782_a("input", (NBTBase)this.getInput().serializeNBT());
            compound.func_74782_a("output", (NBTBase)this.getOutput().serializeNBT());
        }
        return compound;
    }

    public boolean onBlockActivated(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        if (this instanceof IFluidTile && (heldItem = player.func_184586_b(hand)).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing)) {
            boolean didInteract = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)facing);
            this.func_70296_d();
            return didInteract;
        }
        return false;
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        boolean bl;
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        if (Intrinsics.areEqual(capability, ITEM_CAP) && !ConfigHandler.GENERAL.enableAutomation) {
            bl = false;
        } else {
            Capability<?> capability2 = capability;
            if (Intrinsics.areEqual(capability2, ENERGY_CAP)) {
                return this instanceof IEnergyTile;
            }
            if (Intrinsics.areEqual(capability2, FLUID_CAP)) {
                return this instanceof IFluidTile;
            }
            if (Intrinsics.areEqual(capability2, ITEM_CAP)) {
                return this instanceof IItemTile;
            }
            bl = super.hasCapability(capability, facing);
        }
        return bl;
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Object object;
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        if (Intrinsics.areEqual(capability, ITEM_CAP) && !ConfigHandler.GENERAL.enableAutomation) {
            object = null;
        } else {
            Capability<T> capability2 = capability;
            if (Intrinsics.areEqual(capability2, ENERGY_CAP)) {
                if (this instanceof IEnergyTile) {
                    return (T)ENERGY_CAP.cast((Object)((IEnergyTile)((Object)this)).getEnergyStorage());
                }
            } else if (Intrinsics.areEqual(capability2, FLUID_CAP)) {
                if (this instanceof IFluidTile) {
                    return (T)FLUID_CAP.cast((Object)((IFluidTile)((Object)this)).getFluidTanks());
                }
            } else if (Intrinsics.areEqual(capability2, ITEM_CAP) && this instanceof IItemTile) {
                return (T)ITEM_CAP.cast((Object)this.getAutomationInvHandler());
            }
            object = super.getCapability(capability, facing);
        }
        return (T)object;
    }

    static {
        Capability capability = CapabilityEnergy.ENERGY;
        Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"ENERGY");
        ENERGY_CAP = capability;
        Capability capability2 = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue((Object)capability2, (String)"ITEM_HANDLER_CAPABILITY");
        ITEM_CAP = capability2;
        Capability capability3 = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue((Object)capability3, (String)"FLUID_HANDLER_CAPABILITY");
        FLUID_CAP = capability3;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/enderdev/alchemistry/tiles/TileBase$Companion;", "", "<init>", "()V", "ENERGY_CAP", "Lnet/minecraftforge/common/capabilities/Capability;", "Lnet/minecraftforge/energy/IEnergyStorage;", "getENERGY_CAP", "()Lnet/minecraftforge/common/capabilities/Capability;", "ITEM_CAP", "Lnet/minecraftforge/items/IItemHandler;", "getITEM_CAP", "FLUID_CAP", "Lnet/minecraftforge/fluids/capability/IFluidHandler;", "getFLUID_CAP", "alchemistry"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Capability<IEnergyStorage> getENERGY_CAP() {
            return ENERGY_CAP;
        }

        @NotNull
        public final Capability<IItemHandler> getITEM_CAP() {
            return ITEM_CAP;
        }

        @NotNull
        public final Capability<IFluidHandler> getFLUID_CAP() {
            return FLUID_CAP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

