/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.tiles;

import io.enderdev.alchemistry.Alchemistry;
import io.enderdev.alchemistry.ConfigHandler;
import io.enderdev.alchemistry.recipes.EvaporatorRecipe;
import io.enderdev.alchemistry.recipes.register.EvaporatorRegister;
import io.enderdev.alchemistry.tiles.AbstractMachine;
import io.enderdev.alchemistry.tiles.TileStackHandler;
import io.enderdev.alchemistry.tiles.tags.IFluidTile;
import io.enderdev.alchemistry.utils.BlockMeta;
import io.enderdev.alchemistry.utils.ConfigUtils;
import io.enderdev.alchemistry.utils.extensions.IItemHandlerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001#B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u000e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bJ\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lio/enderdev/alchemistry/tiles/TileEvaporator;", "Lio/enderdev/alchemistry/tiles/AbstractMachine;", "Lio/enderdev/alchemistry/recipes/EvaporatorRecipe;", "Lio/enderdev/alchemistry/tiles/tags/IFluidTile;", "<init>", "()V", "inputTank", "Lnet/minecraftforge/fluids/FluidTank;", "getInputTank", "()Lnet/minecraftforge/fluids/FluidTank;", "energyPerTick", "", "getEnergyPerTick", "()I", "recipeTime", "getRecipeTime", "fluidTanks", "Lnet/minecraftforge/fluids/capability/templates/FluidHandlerConcatenate;", "getFluidTanks", "()Lnet/minecraftforge/fluids/capability/templates/FluidHandlerConcatenate;", "updateRecipe", "", "onProcessComplete", "onWorkTick", "shouldTick", "", "shouldProcess", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "compound", "readFromNBT", "calculateProcessingTime", "config", "getHeat", "", "Companion", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nTileEvaporator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileEvaporator.kt\nio/enderdev/alchemistry/tiles/TileEvaporator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,114:1\n295#2,2:115\n774#2:123\n865#2,2:124\n13472#3,2:117\n11228#3:119\n11563#3,3:120\n37#4:126\n36#4,3:127\n*S KotlinDebug\n*F\n+ 1 TileEvaporator.kt\nio/enderdev/alchemistry/tiles/TileEvaporator\n*L\n50#1:115,2\n111#1:123\n111#1:124,2\n93#1:117,2\n102#1:119\n102#1:120,3\n111#1:126\n111#1:127,3\n*E\n"})
public final class TileEvaporator
extends AbstractMachine<EvaporatorRecipe>
implements IFluidTile {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final FluidTank inputTank;
    @NotNull
    private static final Pair<BlockMeta, Double>[] heatSources;

    public TileEvaporator() {
        super(EvaporatorRegister.Companion.getINSTANCE());
        this.initInventoryCapability(0, 1);
        this.inputTank = new FluidTank(){

            public boolean canFillFluidType(FluidStack fluid) {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = this.getRecipeRegister();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            EvaporatorRecipe it = (EvaporatorRecipe)element$iv;
                            boolean bl2 = false;
                            FluidStack fluidStack = fluid;
                            if (!Intrinsics.areEqual((Object)it.getInput().getFluid(), (Object)(fluidStack != null ? fluidStack.getFluid() : null))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            protected void onContentsChanged() {
                this.markDirtyClient();
            }
        };
        this.inputTank.setTileEntity((TileEntity)this);
        this.inputTank.setCanFill(true);
        this.inputTank.setCanDrain(false);
    }

    @NotNull
    public final FluidTank getInputTank() {
        return this.inputTank;
    }

    @Override
    public int getEnergyPerTick() {
        return 0;
    }

    @Override
    public int getRecipeTime() {
        return this.calculateProcessingTime(ConfigHandler.EVAPORATOR.processingTicks);
    }

    @Override
    @Nullable
    public FluidHandlerConcatenate getFluidTanks() {
        IFluidHandler[] iFluidHandlerArray = new IFluidHandler[]{this.inputTank};
        return new FluidHandlerConcatenate(iFluidHandlerArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateRecipe() {
        FluidStack inputStack;
        block4: {
            Object v1;
            TileEvaporator tileEvaporator;
            block3: {
                void $this$firstOrNull$iv;
                block5: {
                    inputStack = this.inputTank.getFluid();
                    if (inputStack == null) break block4;
                    if (this.getCurrentRecipe() == null) break block5;
                    Object t = this.getCurrentRecipe();
                    Intrinsics.checkNotNull(t);
                    if (!Intrinsics.areEqual((Object)((EvaporatorRecipe)t).getInput().getFluid(), (Object)inputStack.getFluid())) break block4;
                }
                Iterable iterable = this.getRecipeRegister();
                tileEvaporator = this;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EvaporatorRecipe it = (EvaporatorRecipe)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getInput().getFluid(), (Object)inputStack.getFluid())) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            tileEvaporator.setCurrentRecipe(v1);
        }
        if (inputStack == null) {
            this.setCurrentRecipe(null);
        }
    }

    @Override
    public void onProcessComplete() {
        TileStackHandler tileStackHandler = this.getOutput();
        Object t = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t);
        ItemStack itemStack = ((EvaporatorRecipe)t).getOutput().func_77946_l();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        tileStackHandler.setOrIncrement(0, itemStack);
        Object t2 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t2);
        this.inputTank.drainInternal(((EvaporatorRecipe)t2).getInput().amount, true);
    }

    @Override
    public void onWorkTick() {
    }

    @Override
    public boolean shouldTick() {
        return this.inputTank.getFluidAmount() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldProcess() {
        Object t = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t);
        ItemStack recipeOutput = ((EvaporatorRecipe)t).getOutput();
        int n = this.inputTank.getFluidAmount();
        Object t2 = this.getCurrentRecipe();
        Intrinsics.checkNotNull(t2);
        if (n < ((EvaporatorRecipe)t2).getInput().amount) return false;
        if (this.inputTank.getFluid() != null) {
            FluidStack fluidStack = this.inputTank.getFluid();
            Intrinsics.checkNotNull((Object)fluidStack);
            Fluid fluid = fluidStack.getFluid();
            Object t3 = this.getCurrentRecipe();
            Intrinsics.checkNotNull(t3);
            if (!Intrinsics.areEqual((Object)fluid, (Object)((EvaporatorRecipe)t3).getInput().getFluid())) return false;
        }
        if (!IItemHandlerKt.get((IItemHandler)this.getOutput(), 0).func_190926_b()) {
            Item item = IItemHandlerKt.get((IItemHandler)this.getOutput(), 0).func_77973_b();
            Object t4 = this.getCurrentRecipe();
            Intrinsics.checkNotNull(t4);
            if (!Intrinsics.areEqual((Object)item, (Object)((EvaporatorRecipe)t4).getOutput().func_77973_b())) return false;
        }
        if (IItemHandlerKt.get((IItemHandler)this.getOutput(), 0).func_190916_E() + recipeOutput.func_190916_E() > recipeOutput.func_77976_d()) return false;
        return true;
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        compound.func_74782_a("InputTankNBT", (NBTBase)this.inputTank.writeToNBT(new NBTTagCompound()));
        return compound;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.inputTank.readFromNBT(compound.func_74775_l("InputTankNBT"));
    }

    public final int calculateProcessingTime(int config) {
        return MathKt.roundToInt((double)((double)config / this.getHeat()));
    }

    public final double getHeat() {
        double heat = 0.0;
        heat = 1.0;
        if (!BiomeDictionary.hasType((Biome)this.field_145850_b.getBiomeForCoordsBody(this.field_174879_c), (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            heat = 0.5;
        }
        IBlockState below = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        Pair<BlockMeta, Double>[] $this$forEach$iv = heatSources;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Pair<BlockMeta, Double> element$iv;
            Pair<BlockMeta, Double> pair = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            BlockMeta block = (BlockMeta)pair.component1();
            double speed = ((Number)pair.component2()).doubleValue();
            if (!Intrinsics.areEqual((Object)block, (Object)below)) continue;
            heat *= speed;
        }
        return heat;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Companion = new Companion(null);
        String[] $this$map$iv = ConfigHandler.EVAPORATOR.heatSources;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Pair pair;
            void it;
            void item$iv$iv;
            void var8_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            char[] cArray = new char[]{';', ','};
            List split = StringsKt.split$default((CharSequence)((CharSequence)it), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (split.size() != 2) {
                Alchemistry.INSTANCE.getLogger().error("Malformed evaporator heat source - expected 2 sections but found " + split.size() + ": " + (String)it);
                pair = null;
            } else if (ConfigUtils.INSTANCE.parseBlock((String)split.get(0)) == null) {
                pair = null;
            } else {
                BlockMeta block;
                double multiplier = Double.parseDouble((String)split.get(1));
                pair = TuplesKt.to((Object)block, (Object)multiplier);
            }
            collection.add(pair);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)var3_3;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        heatSources = thisCollection$iv.toArray(new Pair[0]);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R+\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005\u00a2\u0006\u0010\n\u0002\u0010\f\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lio/enderdev/alchemistry/tiles/TileEvaporator$Companion;", "", "<init>", "()V", "heatSources", "", "Lkotlin/Pair;", "Lio/enderdev/alchemistry/utils/BlockMeta;", "", "getHeatSources$annotations", "getHeatSources", "()[Lkotlin/Pair;", "[Lkotlin/Pair;", "alchemistry"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<BlockMeta, Double>[] getHeatSources() {
            return heatSources;
        }

        public static /* synthetic */ void getHeatSources$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

