/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.tiles;

import io.enderdev.alchemistry.tiles.TileBase;
import io.enderdev.alchemistry.utils.extensions.IItemHandlerKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0014J\u0006\u0010\r\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lio/enderdev/alchemistry/tiles/TileStackHandler;", "Lnet/minecraftforge/items/ItemStackHandler;", "size", "", "tile", "Lio/enderdev/alchemistry/tiles/TileBase;", "<init>", "(ILio/enderdev/alchemistry/tiles/TileBase;)V", "getTile", "()Lio/enderdev/alchemistry/tiles/TileBase;", "onContentsChanged", "", "slot", "clear", "incrementSlot", "amountToAdd", "setOrIncrement", "stackToSet", "Lnet/minecraft/item/ItemStack;", "decrementSlot", "amount", "eject", "", "direction", "Lnet/minecraft/util/EnumFacing;", "alchemistry"})
@SourceDebugExtension(value={"SMAP\nTileStackHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileStackHandler.kt\nio/enderdev/alchemistry/tiles/TileStackHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1869#2,2:56\n*S KotlinDebug\n*F\n+ 1 TileStackHandler.kt\nio/enderdev/alchemistry/tiles/TileStackHandler\n*L\n20#1:56,2\n*E\n"})
public class TileStackHandler
extends ItemStackHandler {
    @NotNull
    private final TileBase tile;

    public TileStackHandler(int size, @NotNull TileBase tile) {
        Intrinsics.checkNotNullParameter((Object)((Object)tile), (String)"tile");
        this.tile = tile;
        this.setSize(size);
    }

    @NotNull
    public final TileBase getTile() {
        return this.tile;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.tile.func_70296_d();
    }

    public final void clear() {
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.getSlots());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            this.setStackInSlot(it, ItemStack.field_190927_a);
        }
    }

    public final void incrementSlot(int slot, int amountToAdd) {
        ItemStack temp = IItemHandlerKt.get((IItemHandler)this, slot);
        if (temp.func_190916_E() + amountToAdd <= temp.func_77976_d()) {
            temp.func_190920_e(temp.func_190916_E() + amountToAdd);
        }
        this.setStackInSlot(slot, temp);
    }

    public final void setOrIncrement(int slot, @NotNull ItemStack stackToSet) {
        Intrinsics.checkNotNullParameter((Object)stackToSet, (String)"stackToSet");
        if (!stackToSet.func_190926_b()) {
            if (IItemHandlerKt.get((IItemHandler)this, slot).func_190926_b()) {
                this.setStackInSlot(slot, stackToSet);
            } else {
                this.incrementSlot(slot, stackToSet.func_190916_E());
            }
        }
    }

    public final void decrementSlot(int slot, int amount) {
        ItemStack temp = IItemHandlerKt.get((IItemHandler)this, slot);
        if (temp.func_190926_b()) {
            return;
        }
        if (temp.func_190916_E() - amount < 0) {
            return;
        }
        temp.func_190918_g(amount);
        if (temp.func_190916_E() <= 0) {
            this.setStackInSlot(slot, ItemStack.field_190927_a);
        } else {
            this.setStackInSlot(slot, temp);
        }
    }

    public final boolean eject(@NotNull EnumFacing direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        IItemHandler originHandler = this.tile.getCapability(TileBase.Companion.getITEM_CAP(), direction);
        TileEntity tileEntity = this.tile.func_145831_w().func_175625_s(this.tile.func_174877_v().func_177972_a(direction));
        IItemHandler targetHandler = tileEntity != null ? (IItemHandler)tileEntity.getCapability(TileBase.Companion.getITEM_CAP(), direction.func_176734_d()) : null;
        return originHandler != null && targetHandler != null ? IItemHandlerKt.tryInsertInto(originHandler, targetHandler) : false;
    }
}

