/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.alchemistry.utils;

import io.enderdev.alchemistry.Alchemistry;
import io.enderdev.alchemistry.utils.BlockMeta;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/enderdev/alchemistry/utils/ConfigUtils;", "", "<init>", "()V", "parseBlock", "Lio/enderdev/alchemistry/utils/BlockMeta;", "blockStr", "", "alchemistry"})
public final class ConfigUtils {
    @NotNull
    public static final ConfigUtils INSTANCE = new ConfigUtils();

    private ConfigUtils() {
    }

    @Nullable
    public final BlockMeta parseBlock(@NotNull String blockStr) {
        Intrinsics.checkNotNullParameter((Object)blockStr, (String)"blockStr");
        StringTokenizer tokenizer = new StringTokenizer(blockStr, ":");
        String mod = null;
        String name = null;
        Integer meta = null;
        try {
            Integer n;
            String string = tokenizer.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextToken(...)");
            mod = string;
            String string2 = tokenizer.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextToken(...)");
            name = string2;
            if (tokenizer.hasMoreTokens()) {
                String string3 = tokenizer.nextToken();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"nextToken(...)");
                n = Integer.parseInt(string3);
            } else {
                n = null;
            }
            meta = n;
        }
        catch (NoSuchElementException noSuchElementException) {
            Alchemistry.INSTANCE.getLogger().error("Invalid block specification, expected at least 2 sections: '" + blockStr + '\'');
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            Alchemistry.INSTANCE.getLogger().error("Invalid block specification, expected meta (column 3) to be a number or empty: '" + blockStr + '\'');
            return null;
        }
        ResourceLocation location = new ResourceLocation(mod, name);
        if (!Block.field_149771_c.func_148741_d((Object)location)) {
            Alchemistry.INSTANCE.getLogger().error("Invalid block, doesn't exist: '" + blockStr + '\'');
            return null;
        }
        Object object = Block.field_149771_c.func_82594_a((Object)location);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObject(...)");
        return new BlockMeta((Block)object, meta);
    }
}

