/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor;

import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.CursorTypeRegistrar;
import io.github.fishstiz.minecraftcursor.api.ElementRegistrar;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursorTracker;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.config.ConfigLoader;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.cursor.resolver.CursorTypeResolver;
import io.github.fishstiz.minecraftcursor.cursor.resolver.ElementWalker;
import io.github.fishstiz.minecraftcursor.impl.CursorControllerImpl;
import io.github.fishstiz.minecraftcursor.impl.MinecraftCursorInitializerImpl;
import io.github.fishstiz.minecraftcursor.platform.Services;
import io.github.fishstiz.minecraftcursor.provider.CursorControllerProvider;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinecraftCursor {
    public static final String MOD_ID = "minecraft-cursor";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"minecraft-cursor");
    public static final Config CONFIG = ConfigLoader.load(Services.PLATFORM.getConfigDir().resolve("minecraft-cursor.json").toFile());
    private static final CursorControllerImpl CONTROLLER = new CursorControllerImpl();
    @Nullable
    private static CursorType deferredCursorType;

    private MinecraftCursor() {
    }

    static void init() {
        new MinecraftCursorInitializerImpl().init(CursorManager.INSTANCE, CursorTypeResolver.INSTANCE);
        Services.PLATFORM.getEntrypoints().forEach(entrypoint -> {
            try {
                entrypoint.init((CursorTypeRegistrar)CursorManager.INSTANCE, (ElementRegistrar)CursorTypeResolver.INSTANCE);
            }
            catch (Exception | LinkageError e) {
                LOGGER.error("[minecraft-cursor] Skipping invalid implementation of MinecraftCursorInitializer", e);
            }
        });
        for (String blacklisted : CONFIG.getBlacklist()) {
            CursorTypeResolver.INSTANCE.register(blacklisted, (e, x, y) -> CursorType.DEFAULT_FORCE);
        }
        CursorControllerProvider.init((CursorController)CONTROLLER);
    }

    static void afterClientTick(class_310 minecraft) {
        if (!ExternalCursorTracker.get().isCustom()) {
            if (minecraft.field_1755 == null && deferredCursorType == null) {
                CursorManager.INSTANCE.setCurrentCursor(CursorType.firstNonDefault((CursorType[])new CursorType[]{ExternalCursorTracker.get().getCursorOrDefault(), CONTROLLER.consumeTransientCursor(), CONTROLLER.consumeTransientFallbackCursor()}));
            } else if (deferredCursorType != null && MinecraftCursor.shouldApplyDeferredCursorType(minecraft)) {
                CursorManager.INSTANCE.setCurrentCursor(deferredCursorType);
            }
            deferredCursorType = null;
        }
    }

    public static void afterScreenRender(class_310 minecraft, class_437 screen, class_332 guiGraphics, int mouseX, int mouseY) {
        if (MinecraftCursor.shouldApplyDeferredCursorType(minecraft)) {
            CursorTypeResolver.INSTANCE.getInspector().render(minecraft, screen, guiGraphics, mouseX, mouseY);
            if (!ExternalCursorTracker.get().isCustom()) {
                deferredCursorType = MinecraftCursor.resolveWithFallback(screen, mouseX, mouseY);
            }
        }
    }

    static void afterCurrentScreenRender(class_310 minecraft, class_437 currentScreen, class_332 guiGraphics, int mouseX, int mouseY) {
        CursorTypeResolver.INSTANCE.getInspector().render(minecraft, currentScreen, guiGraphics, mouseX, mouseY);
        if (!ExternalCursorTracker.get().isCustom()) {
            CursorManager.INSTANCE.setCurrentCursor(MinecraftCursor.resolveWithFallback(currentScreen, mouseX, mouseY));
        }
        deferredCursorType = null;
    }

    private static boolean shouldApplyDeferredCursorType(class_310 minecraft) {
        return minecraft.field_1755 == null && !minecraft.field_1729.method_1613();
    }

    @NotNull
    private static CursorType resolveWithFallback(class_437 screen, double mouseX, double mouseY) {
        return CursorType.firstNonDefault((CursorType[])new CursorType[]{MinecraftCursor.resolveCursorType(screen, mouseX, mouseY), CONTROLLER.consumeTransientFallbackCursor()});
    }

    private static CursorType resolveCursorType(class_437 screen, double mouseX, double mouseY) {
        if (!CursorManager.INSTANCE.isAdaptive()) {
            return CursorType.DEFAULT;
        }
        CursorType cursorType = CursorType.firstNonDefault((CursorType[])new CursorType[]{ExternalCursorTracker.get().getCursorOrDefault(), CONTROLLER.consumeTransientCursor()});
        if (!cursorType.isDefault()) {
            return cursorType;
        }
        if (CursorTypeUtil.isGrabbing()) {
            return CursorType.GRABBING;
        }
        CursorType resolved = CursorTypeResolver.INSTANCE.resolve((class_364)screen, mouseX, mouseY);
        if (!resolved.isDefault()) {
            return resolved;
        }
        class_364 child = ElementWalker.findFirst((class_4069)screen, mouseX, mouseY);
        if (child != null) {
            return CursorTypeResolver.INSTANCE.resolve(child, mouseX, mouseY);
        }
        return CursorType.DEFAULT;
    }

    public static class_2960 loc(String path) {
        return new class_2960(MOD_ID, path);
    }
}

