/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor;

import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface CursorRenderer {
    public void setCursor(@NotNull Cursor var1);

    public void resetCursor();

    public void render(class_310 var1, class_332 var2, int var3, int var4);

    public static final class Virtual
    implements CursorRenderer {
        private static final float Z = 5000.0f;
        private class_2960 textureLocation;
        private int textureWidth;
        private int textureHeight;
        private int vOffset;
        private double xhot;
        private double yhot;
        private double size;

        Virtual() {
        }

        @Override
        public void setCursor(@NotNull Cursor cursor) {
            this.textureLocation = cursor.getLocation();
            this.textureWidth = cursor.getTextureWidth();
            this.textureHeight = cursor.getTextureHeight();
            this.vOffset = this.textureWidth * cursor.getTextureIndex();
            double scale = SettingsUtil.getAutoScale(cursor.getScale());
            this.xhot = (double)cursor.getXHot() * scale;
            this.yhot = (double)cursor.getYHot() * scale;
            this.size = (double)this.textureWidth * scale;
        }

        @Override
        public void resetCursor() {
            GLFW.glfwSetInputMode((long)CursorTypeUtil.WINDOW, (int)208897, (int)212993);
            this.textureLocation = null;
        }

        @Override
        public void render(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
            if (!minecraft.field_1729.method_1613() && this.textureLocation != null) {
                int guiScale = (int)minecraft.method_22683().method_4495();
                int scaledSize = (int)Math.round(this.size / (double)guiScale);
                int x = mouseX - (int)Math.round(this.xhot / (double)guiScale);
                int y = mouseY - (int)Math.round(this.yhot / (double)guiScale);
                GLFW.glfwSetInputMode((long)CursorTypeUtil.WINDOW, (int)208897, (int)212994);
                class_4587 poseStack = guiGraphics.method_51448();
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 0.0f, 5000.0f);
                guiGraphics.method_25293(this.textureLocation, x, y, scaledSize, scaledSize, 0.0f, (float)this.vOffset, this.textureWidth, this.textureWidth, this.textureWidth, this.textureHeight);
                poseStack.method_22909();
            }
        }
    }

    public static final class Native
    implements CursorRenderer {
        Native() {
        }

        @Override
        public void setCursor(@NotNull Cursor cursor) {
            GLFW.glfwSetCursor((long)CursorTypeUtil.WINDOW, (long)cursor.getId());
        }

        @Override
        public void resetCursor() {
            GLFW.glfwSetCursor((long)CursorTypeUtil.WINDOW, (long)0L);
        }

        @Override
        public void render(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
        }
    }
}

