/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.widget;

import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;

public abstract class AbstractListWidget<E extends Entry>
extends ContainerObjectSelectionList<E> {
    protected final int rowGap;

    protected AbstractListWidget(Minecraft minecraft, int width, int y, int height, int itemHeight) {
        super(minecraft, width, y, height, itemHeight);
        this.rowGap = 0;
    }

    protected AbstractListWidget(Minecraft minecraft, int width, int y, int height, int itemHeight, int rowGap) {
        super(minecraft, width, y, height, itemHeight + rowGap);
        this.rowGap = rowGap;
    }

    public int maxScrollAmount() {
        return Math.max(0, super.maxScrollAmount());
    }

    public void setClampedScrollAmount(double scrollAmount) {
        this.setScrollAmount(SettingsUtil.clamp(scrollAmount, 0.0, (double)this.maxScrollAmount()));
    }

    public void clampScrollAmount() {
        this.setClampedScrollAmount(this.scrollAmount());
    }

    protected int scrollBarX() {
        return this.getRight() - 6;
    }

    public int getRowWidth() {
        return this.scrollbarVisible() ? this.getWidth() - 6 : this.getWidth();
    }

    public int getRowLeft() {
        return this.getX();
    }

    public int getRowTop(int index) {
        return this.getY() - (int)this.scrollAmount() + index * this.defaultEntryHeight;
    }

    public void setHeight(int height) {
        super.setHeight(height);
        this.clampScrollAmount();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.clampScrollAmount();
    }

    protected int contentHeight() {
        return this.getItemCount() * this.defaultEntryHeight - this.rowGap;
    }

    protected abstract class Entry
    extends ContainerObjectSelectionList.Entry<E> {
        private final int index;

        protected Entry(int index) {
            this.index = index;
        }

        protected Entry() {
            this(this$0.children().size());
        }

        public int getX() {
            return AbstractListWidget.this.getRowLeft();
        }

        public int getY() {
            return AbstractListWidget.this.getRowTop(this.index);
        }

        public int getWidth() {
            return AbstractListWidget.this.getRowWidth();
        }

        public int getHeight() {
            return AbstractListWidget.this.defaultEntryHeight - AbstractListWidget.this.rowGap;
        }

        public int getRight() {
            return this.getX() + this.getWidth();
        }

        public int getBottom() {
            return this.getY() + this.getHeight();
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.getX() && mouseX <= (double)this.getRight() && mouseY >= (double)this.getY() && mouseY <= (double)(this.getBottom() + AbstractListWidget.this.rowGap);
        }
    }
}

