/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.widget;

import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorProvider;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class CursorWidget
extends AbstractWidget
implements CursorProvider {
    public static final int DEFAULT_HEIGHT = 32;
    public static final int DEFAULT_WIDTH = 32;
    private static final int BACKGROUND_SIZE = 128;
    private static final int BORDER_COLOR = -16777216;
    private static final int FOCUSED_BORDER_COLOR = -1;
    private final ResourceLocation background128;
    private final Cursor cursor;
    private boolean renderRuler = true;

    protected CursorWidget(int x, int y, int width, int height, @NotNull Component message, @NotNull Cursor cursor, @NotNull ResourceLocation background128) {
        super(x, y, width, height, message);
        this.cursor = cursor;
        this.background128 = background128;
    }

    protected CursorWidget(@NotNull Component message, @NotNull Cursor cursor, @NotNull ResourceLocation background128) {
        this(0, 0, 32, 32, message, cursor, background128);
    }

    protected void renderCursor(@NotNull GuiGraphics guiGraphics, @NotNull Cursor cursor) {
    }

    protected abstract void renderRuler(@NotNull GuiGraphics var1, int var2, int var3);

    protected void renderBackground(@NotNull GuiGraphics guiGraphics) {
        if (!this.isOverflowing()) {
            DrawUtil.drawCheckerboard(guiGraphics, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getCellWidth(), this.getCellHeight(), this.background128, 128);
        }
    }

    protected void renderBorder(@NotNull GuiGraphics guiGraphics) {
        int color = this.isFocused() && this.active ? -1 : -16777216;
        DrawUtil.renderOutline(guiGraphics, this.getX(), this.getY(), this.getWidth(), this.getHeight(), color);
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.cursor.hasTexture()) {
            this.renderBackground(guiGraphics);
            this.renderCursor(guiGraphics, this.cursor);
            if (this.isRenderRuler()) {
                this.renderRuler(guiGraphics, mouseX, mouseY);
            }
        }
        this.renderBorder(guiGraphics);
    }

    public void setRenderRuler(boolean renderRuler) {
        this.renderRuler = renderRuler;
    }

    public boolean isRenderRuler() {
        return this.renderRuler;
    }

    @NotNull
    protected Cursor getCursor() {
        return this.cursor;
    }

    protected float getCellWidth() {
        CursorTexture texture = this.getCursor().getTexture();
        if (texture == null) {
            return 0.0f;
        }
        int spriteWidth = texture.spriteWidth();
        int spriteHeight = texture.spriteHeight();
        float scale = (float)this.getWidth() / (float)Math.max(spriteWidth, spriteHeight);
        int drawWidth = Math.round((float)spriteWidth * scale);
        return (float)drawWidth / (float)spriteWidth;
    }

    protected float getCellHeight() {
        CursorTexture texture = this.getCursor().getTexture();
        if (texture == null) {
            return 0.0f;
        }
        int spriteWidth = texture.spriteWidth();
        int spriteHeight = texture.spriteHeight();
        float scale = (float)this.getHeight() / (float)Math.max(spriteWidth, spriteHeight);
        int drawHeight = Math.round((float)spriteHeight * scale);
        return (float)drawHeight / (float)spriteHeight;
    }

    protected boolean isOverflowing() {
        CursorTexture texture = this.getCursor().getTexture();
        return texture == null || texture.spriteWidth() > 128 || texture.spriteHeight() > 128;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
    }
}

