/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.util;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.cursor.CursorType;
import com.mojang.blaze3d.platform.cursor.CursorTypes;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class CursorTypeUtil {
    private static final Window WINDOW = Minecraft.getInstance().getWindow();

    private CursorTypeUtil() {
    }

    public static boolean nameEquals(CursorType a, CursorType b) {
        return Objects.equals(a.toString(), b.toString());
    }

    public static boolean canShift() {
        Cursor shiftCursor = CursorsExtended.getInstance().getRegistry().get(CursorTypesExt.SHIFT);
        return shiftCursor.isEnabled() && CursorsExtended.CONFIG.getOrCreateSettings(shiftCursor).enabled() && (InputConstants.isKeyDown((Window)WINDOW, (int)340) || InputConstants.isKeyDown((Window)WINDOW, (int)344));
    }

    public static boolean isLeftClickHeld() {
        return GLFW.glfwGetMouseButton((long)WINDOW.handle(), (int)0) == 1;
    }

    public static boolean isHeld(CursorType lastCursorType) {
        return CursorTypesExt.isHoldType(lastCursorType) && CursorsExtended.getInstance().getRegistry().get(lastCursorType).isEnabled() && CursorTypeUtil.isLeftClickHeld();
    }

    public static boolean nonDefault(CursorType cursorType) {
        return cursorType != null && !CursorTypeUtil.nameEquals(cursorType, CursorType.DEFAULT);
    }

    public static CursorType arrowIfDefault(CursorType cursorType) {
        return CursorTypeUtil.nameEquals(cursorType, CursorType.DEFAULT) ? CursorTypes.ARROW : cursorType;
    }

    public static boolean isHovered(GuiEventListener guiEventListener, double mouseX, double mouseY) {
        if (guiEventListener instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            return widget.visible && widget.isHovered() && mouseX >= (double)widget.getX() && mouseY >= (double)widget.getY() && mouseX < (double)widget.getRight() && mouseY < (double)widget.getBottom();
        }
        return guiEventListener.isMouseOver(mouseX, mouseY);
    }

    @Nullable
    public static CursorType mapStandardCursor(int shape) {
        return switch (shape) {
            case 221185 -> CursorType.DEFAULT;
            case 221188 -> CursorTypes.POINTING_HAND;
            case 221186 -> CursorTypes.IBEAM;
            case 221187 -> CursorTypes.CROSSHAIR;
            case 221189 -> CursorTypes.RESIZE_EW;
            case 221190 -> CursorTypes.RESIZE_NS;
            case 221191 -> CursorTypesExt.RESIZE_NWSE;
            case 221192 -> CursorTypesExt.RESIZE_NESW;
            case 221193 -> CursorTypes.RESIZE_ALL;
            case 221194 -> CursorTypes.NOT_ALLOWED;
            default -> null;
        };
    }

    @Nullable
    public static String mapStandardCursorName(int shape) {
        return switch (shape) {
            case 221185 -> "default";
            case 221188 -> "pointing_hand";
            case 221186 -> "ibeam";
            case 221187 -> "crosshair";
            case 221189 -> "resize_ew";
            case 221190 -> "resize_ns";
            case 221191 -> "resize_nwse";
            case 221192 -> "resize_nesw";
            case 221193 -> "resize_all";
            case 221194 -> "not_allowed";
            default -> null;
        };
    }
}

