package io.github.fishstiz.minecraftcursor;

import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

class CursorResourceReloadListener implements IdentifiableResourceReloadListener {
    @Override
    public class_2960 getFabricId() {
        return CursorResourceLoader.getDirectory();
    }

    @Override
    public @NotNull CompletableFuture<Void> method_25931(
            class_4045 barrier,
            class_3300 manager,
            Executor backgroundExecutor,
            Executor gameExecutor
    ) {
        return CompletableFuture.runAsync(() -> CursorResourceLoader.reloadSettings(manager), backgroundExecutor)
                .thenCompose(barrier::method_18352)
                .thenRunAsync(CursorResourceLoader::onReload, gameExecutor);
    }
}
