package io.github.fishstiz.minecraftcursor;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class MinecraftCursorFabric implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        MinecraftCursor.init();
        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(new CursorResourceReloadListener());
        FabricLoader.getInstance().getModContainer(MinecraftCursor.MOD_ID).ifPresent(modContainer ->
                ResourceManagerHelper.registerBuiltinResourcePack(
                        MinecraftCursor.loc("cursors_extended"),
                        modContainer,
                        class_2561.method_43470("Cursors Extended"),
                        ResourcePackActivationType.NORMAL
                )
        );
        ClientTickEvents.END_CLIENT_TICK.register(MinecraftCursor::afterClientTick);
        ScreenEvents.BEFORE_INIT.register(this::onScreenInit);
    }

    private void onScreenInit(class_310 minecraft, class_437 screen, int width, int height) {
        ScreenEvents.afterRender(screen).register(this::onScreenRender);
    }

    private void onScreenRender(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        MinecraftCursor.afterCurrentScreenRender(class_310.method_1551(), screen, guiGraphics, mouseX, mouseY);
    }
}
