/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.AnimatedCursorConfig;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.config.CursorConfigLoader;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class CursorLoader {
    private static final String IMG_TYPE = ".png";
    private static final String ANIMATION_TYPE = ".png.mcmeta";
    private static final String CONFIG_PATH = "atlases/cursors.json";
    private static final String CURSORS_DIR = "textures/cursors/";
    private static CursorConfig resourceConfig;

    private CursorLoader() {
    }

    public static void resetConfig() {
        if (resourceConfig != null) {
            MinecraftCursor.CONFIG.set_hash(resourceConfig.get_hash());
            MinecraftCursor.CONFIG.layerSettings(resourceConfig.getSettings());
            for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
                cursor.applySettings(MinecraftCursor.CONFIG.getOrCreateCursorSettings(cursor.getType()).copy());
            }
        } else {
            MinecraftCursor.LOGGER.error("Failed to apply resource config: Not Found.");
        }
    }

    public static ResourceLocation getLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft-cursor", (String)CURSORS_DIR);
    }

    public static void applyDefaultCursor() {
        CursorManager.INSTANCE.setCurrentCursor(CursorType.DEFAULT);
    }

    public static void reload(ResourceManager manager) {
        CursorLoader.applyDefaultCursor();
        CursorLoader.loadConfig(manager);
        CursorLoader.loadCursorTextures(manager);
        Minecraft.getInstance().execute(CursorLoader::applyDefaultCursor);
    }

    private static void loadConfig(ResourceManager manager) {
        List configResources = manager.getResourceStack(ResourceLocation.fromNamespaceAndPath((String)"minecraft-cursor", (String)CONFIG_PATH));
        if (configResources.isEmpty()) {
            return;
        }
        CursorLoader.getConfigFromResources(configResources).ifPresent(config -> {
            if (!config.get_hash().equals(MinecraftCursor.CONFIG.get_hash())) {
                MinecraftCursor.LOGGER.info("[minecraft-cursor] New resource pack settings detected, updating config...");
                MinecraftCursor.CONFIG.set_hash(config.get_hash());
                MinecraftCursor.CONFIG.mergeSettings(config.getSettings());
                MinecraftCursor.CONFIG.getGlobal().setActiveAll(false);
                MinecraftCursor.CONFIG.save();
            }
            resourceConfig = config;
        });
    }

    private static Optional<CursorConfig> getConfigFromResources(List<Resource> configResources) {
        CursorConfig combinedConfig = null;
        for (Resource configResource : configResources) {
            try {
                InputStream stream = configResource.open();
                try {
                    CursorConfig loadedConfig = CursorConfigLoader.fromStream(stream);
                    if (combinedConfig == null) {
                        combinedConfig = loadedConfig;
                        continue;
                    }
                    combinedConfig.layerSettings(loadedConfig.getSettings());
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to load settings of resource pack '{}'", (Object)configResource.sourcePackId());
            }
        }
        return Optional.ofNullable(combinedConfig);
    }

    private static void loadCursorTextures(ResourceManager manager) {
        for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
            CursorLoader.loadCursorTexture(manager, cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCursorTexture(ResourceManager manager, Cursor cursor) {
        String basePath = CURSORS_DIR + cursor.getType().getKey();
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"minecraft-cursor", (String)(basePath + IMG_TYPE));
        Resource cursorResource = manager.getResource(location).orElse(null);
        if (cursorResource == null) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Cursor Type: '{}' not found", (Object)cursor.getType().getKey());
            return;
        }
        Image image = null;
        try (InputStream cursorStream = cursorResource.open();){
            image = ImageIO.read(cursorStream);
            if (image == null) {
                MinecraftCursor.LOGGER.error("[minecraft-cursor] Invalid file for cursor type '{}'", (Object)cursor.getType().getKey());
                return;
            }
            AnimatedCursorConfig animation = CursorLoader.loadAnimation(manager, basePath, cursorResource);
            CursorManager.INSTANCE.loadCursor(cursor, location, (BufferedImage)image, animation);
        }
        catch (IOException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to load cursor image for '{}'", (Object)basePath);
        }
        finally {
            if (image != null) {
                image.flush();
            }
        }
    }

    private static AnimatedCursorConfig loadAnimation(ResourceManager manager, String basePath, Resource cursorResource) {
        Resource animationResource = manager.getResource(ResourceLocation.fromNamespaceAndPath((String)"minecraft-cursor", (String)(basePath + ANIMATION_TYPE))).orElse(null);
        if (animationResource != null && animationResource.sourcePackId().equals(cursorResource.sourcePackId())) {
            AnimatedCursorConfig animatedCursorConfig;
            block9: {
                InputStream stream = animationResource.open();
                try {
                    animatedCursorConfig = CursorConfigLoader.getAnimationConfig(stream);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to load animation config for '{}'", (Object)basePath);
                    }
                }
                stream.close();
            }
            return animatedCursorConfig;
        }
        return null;
    }
}

