/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.CursorTypeRegistrar;
import io.github.fishstiz.minecraftcursor.config.AnimatedCursorConfig;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.AnimationState;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public final class CursorManager
implements CursorTypeRegistrar {
    public static final CursorManager INSTANCE = new CursorManager();
    private final LinkedHashMap<String, Cursor> cursors = new LinkedHashMap();
    private final TreeMap<Integer, String> overrides = new TreeMap();
    private final AnimationState animationState = new AnimationState();
    @NotNull
    private Cursor currentCursor = new Cursor(CursorType.of((String)""), null);

    private CursorManager() {
    }

    public void register(CursorType ... cursorTypes) {
        for (CursorType cursorType : cursorTypes) {
            this.register(cursorType);
        }
    }

    public CursorType register(String key) {
        return this.register(CursorType.of((String)key));
    }

    private CursorType register(CursorType cursorType) {
        String key = cursorType.getKey();
        if (key.isEmpty()) {
            throw new NullPointerException("Cursor type key cannot be empty.");
        }
        if (this.cursors.containsKey(key)) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Cursor type '{}' is already registered.", (Object)key);
            return cursorType;
        }
        this.cursors.put(key, new Cursor(cursorType, this::onLoad));
        return cursorType;
    }

    public void loadCursor(Cursor cursor, ResourceLocation sprite, BufferedImage image, @Nullable AnimatedCursorConfig animation) throws IOException {
        boolean animated;
        boolean bl = animated = animation != null;
        if (animated != cursor instanceof AnimatedCursor) {
            cursor.destroy();
            cursor = animated ? new AnimatedCursor(cursor.getType(), this::onLoad) : new Cursor(cursor.getType(), this::onLoad);
            this.cursors.put(cursor.getType().getKey(), cursor);
        }
        CursorConfig.Settings settings = this.getCursorSettings(cursor);
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            animatedCursor.loadImage(sprite, image, settings, animation);
        } else {
            cursor.loadImage(sprite, image, settings);
        }
    }

    private void onLoad(Cursor cursor) {
        Cursor appliedCursor = this.getAppliedCursor();
        if (appliedCursor.isLoaded() && appliedCursor.getId() == cursor.getId()) {
            this.reapplyCursor();
        }
    }

    private CursorConfig.Settings getCursorSettings(Cursor cursor) {
        CursorConfig.Settings settings = new CursorConfig.Settings();
        CursorConfig.Settings base = MinecraftCursor.CONFIG.getOrCreateCursorSettings(cursor.getType());
        CursorConfig.GlobalSettings global = MinecraftCursor.CONFIG.getGlobal();
        settings.update(global.isScaleActive() ? global.getScale() : base.getScale(), global.isXHotActive() ? global.getXHot() : base.getXHot(), global.isYHotActive() ? global.getYHot() : base.getYHot(), base.isEnabled());
        if (base.isAnimated() != null) {
            settings.setAnimated(base.isAnimated());
        }
        return settings;
    }

    void setCurrentCursor(@NotNull CursorType type) {
        Cursor cursor;
        Cursor override = this.getOverride().orElse(null);
        Cursor cursor2 = cursor = override != null ? override : this.cursors.get(type.getKey());
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            if (cursor.getId() != 0L) {
                this.handleCursorAnimation(animatedCursor);
                return;
            }
        }
        if (cursor == null || !type.isDefault() && cursor.getId() == 0L || !cursor.isEnabled()) {
            cursor = this.getCursor(CursorType.DEFAULT);
        }
        this.updateCursor(cursor);
    }

    private void handleCursorAnimation(AnimatedCursor cursor) {
        if (!this.getAppliedCursor().getType().isKey(cursor.getType())) {
            this.animationState.reset();
        } else {
            this.animationState.nextFrame(cursor);
        }
        Cursor currentFrameCursor = cursor.getFrame(this.animationState.getCurrentFrame()).cursor();
        this.updateCursor(currentFrameCursor.getId() != 0L ? currentFrameCursor : cursor);
    }

    private void updateCursor(Cursor cursor) {
        if (cursor == null || cursor.getId() == this.currentCursor.getId()) {
            return;
        }
        this.currentCursor = cursor;
        GLFW.glfwSetCursor((long)CursorTypeUtil.WINDOW, (long)this.currentCursor.getId());
    }

    public void reapplyCursor() {
        GLFW.glfwSetCursor((long)CursorTypeUtil.WINDOW, (long)this.getAppliedCursor().getId());
    }

    public void overrideCurrentCursor(CursorType type, int index) {
        Cursor cursor = this.getCursor(type);
        if (cursor != null && cursor.isEnabled()) {
            this.overrides.put(index, type.getKey());
        } else {
            this.overrides.remove(index);
        }
    }

    public void removeOverride(int index) {
        this.overrides.remove(index);
    }

    public Optional<Cursor> getOverride() {
        while (!this.overrides.isEmpty()) {
            Map.Entry<Integer, String> lastEntry = this.overrides.lastEntry();
            Cursor cursor = this.cursors.get(lastEntry.getValue());
            if (cursor == null || cursor.getId() == 0L) {
                this.overrides.remove(lastEntry.getKey());
                continue;
            }
            return Optional.of(cursor);
        }
        return Optional.empty();
    }

    @NotNull
    public Cursor getAppliedCursor() {
        Cursor cursor;
        Cursor override = this.getOverride().orElse(null);
        Cursor cursor2 = cursor = override != null ? override : this.currentCursor;
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            return animatedCursor.getFrame(this.animationState.getCurrentFrame()).cursor();
        }
        return cursor;
    }

    @Nullable
    public Cursor getCursor(CursorType type) {
        return this.cursors.get(type.getKey());
    }

    public long getId(CursorType type) {
        Cursor cursor = this.cursors.get(type.getKey());
        return cursor != null ? cursor.getId() : 0L;
    }

    public long getCurrentId() {
        return this.getAppliedCursor().getId();
    }

    public Collection<Cursor> getCursors() {
        return this.cursors.values();
    }

    public List<Cursor> getLoadedCursors() {
        ArrayList<Cursor> loadedCursors = new ArrayList<Cursor>();
        for (Cursor cursor : this.cursors.values()) {
            if (!cursor.isLoaded()) continue;
            loadedCursors.add(cursor);
        }
        return loadedCursors;
    }

    public boolean isAdaptive() {
        for (Cursor cursor : this.cursors.values()) {
            if (!cursor.isEnabled() || cursor.getType().isDefault()) continue;
            return true;
        }
        return false;
    }

    public void setIsAdaptive(boolean isAdaptive) {
        this.cursors.values().forEach(cursor -> {
            if (!cursor.getType().isDefault()) {
                cursor.enable(isAdaptive);
            }
        });
    }

    public boolean hasAnimations() {
        for (Cursor cursor : this.cursors.values()) {
            if (!(cursor instanceof AnimatedCursor)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnimated() {
        for (Cursor cursor : this.cursors.values()) {
            AnimatedCursor animatedCursor;
            if (!(cursor instanceof AnimatedCursor) || !(animatedCursor = (AnimatedCursor)cursor).isAnimated()) continue;
            return true;
        }
        return false;
    }

    public void setIsAnimated(boolean isAnimated) {
        this.cursors.values().forEach(cursor -> {
            if (cursor instanceof AnimatedCursor) {
                AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
                animatedCursor.setAnimated(isAnimated);
            }
        });
    }

    public void reloadCursors() {
        this.cursors.values().forEach(Cursor::reload);
    }
}

