/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorHandler;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.ElementRegistrar;
import io.github.fishstiz.minecraftcursor.inspect.ElementInspector;
import io.github.fishstiz.minecraftcursor.platform.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;

class CursorTypeResolver
implements ElementRegistrar {
    private final List<ElementEntry<? extends GuiEventListener>> registry = new ArrayList<ElementEntry<? extends GuiEventListener>>();
    private final HashMap<String, ElementRegistrar.CursorTypeFunction<? extends GuiEventListener>> cachedRegistry = new HashMap();
    private ElementInspector inspector = new ElementInspector(this){};
    String lastFailedElement;

    CursorTypeResolver() {
    }

    public <T extends GuiEventListener> void register(CursorHandler<T> cursorHandler) {
        CursorHandler.TargetElement targetElement = cursorHandler.getTargetElement();
        if (targetElement.elementClass().isPresent()) {
            this.register((Class)targetElement.elementClass().get(), (arg_0, arg_1, arg_2) -> cursorHandler.getCursorType(arg_0, arg_1, arg_2));
        } else if (targetElement.fullyQualifiedClassName().isPresent()) {
            this.register((String)targetElement.fullyQualifiedClassName().get(), (arg_0, arg_1, arg_2) -> cursorHandler.getCursorType(arg_0, arg_1, arg_2));
        } else {
            throw new NullPointerException("Could not register cursor handler: " + cursorHandler.getClass().getName() + " - Target Element Class and FQCN not present");
        }
    }

    public <T extends GuiEventListener> void register(String binaryName, ElementRegistrar.CursorTypeFunction<T> elementToCursorType) {
        try {
            Class<?> elementClass = Class.forName(Services.PLATFORM.mapClassName("intermediary", binaryName));
            if (!GuiEventListener.class.isAssignableFrom(elementClass)) {
                throw new ClassCastException(binaryName + " is not a subclass of Element");
            }
            this.register(elementClass, elementToCursorType);
        }
        catch (ClassNotFoundException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Error registering element. Class not found: {}", (Object)binaryName);
        }
        catch (ClassCastException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Error registering element. Invalid class: {}", (Object)e.getMessage());
        }
    }

    public <T extends GuiEventListener> void register(Class<T> elementClass, ElementRegistrar.CursorTypeFunction<T> elementToCursorType) {
        this.registry.add(new ElementEntry<T>(elementClass, elementToCursorType));
    }

    public <T extends GuiEventListener> CursorType resolve(T element, double mouseX, double mouseY) {
        String elementName = element.getClass().getName();
        try {
            CursorProvider cursorProvider;
            CursorType providedCursorType;
            if (element instanceof CursorProvider && (providedCursorType = (cursorProvider = (CursorProvider)element).getCursorType(mouseX, mouseY)) != null && !providedCursorType.isDefault()) {
                return providedCursorType;
            }
            ElementRegistrar.CursorTypeFunction<? extends GuiEventListener> mapper = this.cachedRegistry.get(elementName);
            if (mapper == null) {
                mapper = this.resolveMapper(element);
                if (!this.inspector.setHovered(element, true)) {
                    this.cachedRegistry.put(elementName, mapper);
                }
            }
            return mapper.getCursorType(element, mouseX, mouseY);
        }
        catch (Exception | LinkageError e) {
            if (!elementName.equals(this.lastFailedElement)) {
                this.lastFailedElement = elementName;
                MinecraftCursor.LOGGER.error("Could not get cursor type for element: {}", (Object)Services.PLATFORM.unmapClassName("intermediary", elementName));
            }
            return CursorType.DEFAULT;
        }
    }

    private ElementRegistrar.CursorTypeFunction<? extends GuiEventListener> resolveMapper(GuiEventListener element) {
        for (int i = this.registry.size() - 1; i >= 0; --i) {
            if (!this.registry.get((int)i).element.isInstance(element)) continue;
            this.inspector.setHovered(element, true);
            return this.registry.get((int)i).mapper;
        }
        if (element instanceof ContainerEventHandler) {
            return this::resolveChild;
        }
        return ElementRegistrar::elementToDefault;
    }

    private <T extends ContainerEventHandler> CursorType resolveChild(T parent, double mouseX, double mouseY) {
        Optional child = parent.getChildAt(mouseX, mouseY);
        if (child.isPresent()) {
            ContainerEventHandler nestedParent;
            CursorType cursorType;
            GuiEventListener hoveredElement = (GuiEventListener)child.get();
            if (hoveredElement instanceof ContainerEventHandler && !(cursorType = this.resolveChild(nestedParent = (ContainerEventHandler)hoveredElement, mouseX, mouseY)).isDefault()) {
                return cursorType;
            }
            this.inspector.setHovered(hoveredElement, false);
            return this.resolve(hoveredElement, mouseX, mouseY);
        }
        return CursorType.DEFAULT;
    }

    public ElementInspector getInspector() {
        return this.inspector;
    }

    public void toggleInspector() {
        this.inspector = ElementInspector.toggle(this.inspector);
        this.cachedRegistry.clear();
    }

    record ElementEntry<T extends GuiEventListener>(Class<T> element, ElementRegistrar.CursorTypeFunction<T> mapper) {
    }
}

