/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.compat;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.compat.CursorTracker;
import io.github.fishstiz.minecraftcursor.compat.DefaultCursorTracker;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursor;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalCursorTracker
implements CursorTracker {
    private static boolean tracking = false;
    private final StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private final Map<Long, ExternalCursor> externalCursors = new HashMap<Long, ExternalCursor>();
    private final Map<Integer, CursorTimestamp> currentCursors = new HashMap<Integer, CursorTimestamp>();
    private final LongOpenHashSet addresses = new LongOpenHashSet();

    private ExternalCursorTracker() {
    }

    private void updateCursorTimestamp(int caller, CursorType cursorType) {
        if (cursorType == null) {
            return;
        }
        CursorTimestamp cursorTimestamp = this.currentCursors.get(caller);
        if (cursorTimestamp == null) {
            this.currentCursors.put(caller, new CursorTimestamp(cursorType));
        } else {
            cursorTimestamp.update(cursorType);
        }
    }

    private CursorType getLatestCursorOrDefault() {
        CursorTimestamp latestCursorTimestamp = null;
        for (CursorTimestamp cursorTimestamp : this.currentCursors.values()) {
            if (cursorTimestamp.cursorType == ExternalCursor.PLACEHOLDER_CUSTOM && (latestCursorTimestamp == null || latestCursorTimestamp.cursorType != ExternalCursor.PLACEHOLDER_CUSTOM || cursorTimestamp.timestamp > latestCursorTimestamp.timestamp)) {
                latestCursorTimestamp = cursorTimestamp;
                continue;
            }
            if (latestCursorTimestamp != null && latestCursorTimestamp.cursorType == ExternalCursor.PLACEHOLDER_CUSTOM || latestCursorTimestamp != null && latestCursorTimestamp.cursorType != CursorType.DEFAULT && (cursorTimestamp.timestamp <= latestCursorTimestamp.timestamp || cursorTimestamp.cursorType == CursorType.DEFAULT)) continue;
            latestCursorTimestamp = cursorTimestamp;
        }
        return latestCursorTimestamp != null ? latestCursorTimestamp.cursorType : CursorType.DEFAULT;
    }

    @Override
    @Nullable
    public ExternalCursor getTrackedCursor(long cursor) {
        return this.externalCursors.get(cursor);
    }

    @Override
    public void untrackCursor(long cursor) {
        this.externalCursors.remove(cursor);
    }

    @Override
    public void updateCursor(int caller, CursorType cursorType) {
        this.updateCursorTimestamp(caller, cursorType);
    }

    @Override
    public boolean isTracking(long cursor) {
        return this.externalCursors.containsKey(cursor);
    }

    @Override
    public void storeAddress(long address) {
        this.addresses.add(address);
    }

    @Override
    public boolean consumeAddress(long address) {
        return this.addresses.removeIf(a -> a == address);
    }

    @Override
    @NotNull
    public CursorType getCursorOrDefault() {
        return this.getLatestCursorOrDefault();
    }

    @Override
    public boolean isCustom() {
        return this.getCursorOrDefault() == ExternalCursor.PLACEHOLDER_CUSTOM;
    }

    public static boolean isTracking() {
        return tracking;
    }

    public static CursorTracker get() {
        if (!ExternalCursorTracker.isTracking()) {
            return DefaultCursorTracker.getInstance();
        }
        return Holder.INSTANCE;
    }

    public static StackWalker getWalker() {
        return Holder.INSTANCE.walker;
    }

    public static void trackCursor(long cursor, int caller, CursorType cursorType) {
        Holder.INSTANCE.externalCursors.computeIfAbsent(cursor, c -> new ExternalCursor(caller, cursorType)).update(cursorType);
    }

    public static void trackCursor(long cursor, int caller) {
        Holder.INSTANCE.externalCursors.putIfAbsent(cursor, new ExternalCursor(caller));
    }

    private static class CursorTimestamp {
        CursorType cursorType;
        long timestamp;

        public CursorTimestamp(CursorType cursorType) {
            this.cursorType = cursorType;
            this.timestamp = Util.getMillis();
        }

        public void update(CursorType cursorType) {
            if (this.cursorType != cursorType) {
                this.timestamp = Util.getMillis();
            }
            this.cursorType = cursorType;
        }
    }

    private static class Holder {
        private static final ExternalCursorTracker INSTANCE = new ExternalCursorTracker();

        private Holder() {
        }

        static {
            tracking = true;
            MinecraftCursor.LOGGER.info("[minecraft-cursor] Tracking cursors from other mods...");
        }
    }
}

