/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor;

import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.AnimationMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;

public class AnimationState {
    private static final Random RANDOM = new Random();
    private long lastFrameTime = Util.getMillis();
    private int currentFrame = 0;
    private boolean oscillateReversed = false;
    private List<Integer> remainingFrames;

    public boolean nextFrame(AnimatedCursor cursor) {
        boolean isNextFrame;
        long currentTime = Util.getMillis();
        boolean bl = isNextFrame = currentTime - this.lastFrameTime >= (long)cursor.getFrame(this.currentFrame).time() * 50L;
        if (isNextFrame) {
            this.next(cursor, currentTime);
        }
        return isNextFrame;
    }

    public int next(AnimatedCursor cursor, long currentTime) {
        this.lastFrameTime = currentTime;
        this.currentFrame = switch (cursor.getMode()) {
            default -> throw new MatchException(null, null);
            case AnimationMode.LOOP, AnimationMode.LOOP_REVERSE -> (this.currentFrame + 1) % cursor.getFrameCount();
            case AnimationMode.FORWARDS, AnimationMode.REVERSE -> Math.min(this.currentFrame + 1, cursor.getFrameCount() - 1);
            case AnimationMode.OSCILLATE -> {
                boolean v1 = this.oscillateReversed = this.currentFrame != 0 && (this.currentFrame == cursor.getFrameCount() - 1 || this.oscillateReversed);
                if (this.oscillateReversed) {
                    yield this.currentFrame - 1;
                }
                yield this.currentFrame + 1;
            }
            case AnimationMode.RANDOM -> {
                int newFrame;
                while ((newFrame = RANDOM.nextInt(cursor.getFrameCount())) == this.currentFrame) {
                }
                yield newFrame;
            }
            case AnimationMode.RANDOM_CYCLE -> {
                if (this.remainingFrames == null || this.remainingFrames.isEmpty()) {
                    this.remainingFrames = new ArrayList<Integer>(cursor.getFrameCount());
                    for (int i = 0; i < cursor.getFrameCount(); ++i) {
                        this.remainingFrames.add(i);
                    }
                }
                yield this.remainingFrames.remove(RANDOM.nextInt(this.remainingFrames.size()));
            }
        };
        return this.currentFrame;
    }

    public void reset() {
        this.lastFrameTime = Util.getMillis();
        this.currentFrame = 0;
        this.oscillateReversed = false;
        this.remainingFrames = null;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }
}

