/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.api.CursorHandler;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.mixin.access.AbstractFurnaceScreenAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.CraftingScreenAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.InventoryScreenAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeAlternativesWidgetAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeBookResultsAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeBookWidgetAccessor;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.OverlayRecipeComponent;
import net.minecraft.world.inventory.RecipeBookMenu;

public class RecipeBookScreenCursorHandler<T extends AbstractContainerScreen<? extends RecipeBookMenu<?, ?>>>
implements CursorHandler<T> {
    public static final RecipeBookScreenCursorHandler<InventoryScreen> INVENTORY = new RecipeBookScreenCursorHandler();
    public static final RecipeBookScreenCursorHandler<CraftingScreen> CRAFTING = new RecipeBookScreenCursorHandler();
    public static final RecipeBookScreenCursorHandler<AbstractFurnaceScreen<?>> FURNACE = new RecipeBookScreenCursorHandler();

    public CursorType getCursorType(T recipeBookScreen, double mouseX, double mouseY) {
        RecipeBookWidgetAccessor recipeBook = this.getRecipeBook((AbstractContainerScreen<?>)recipeBookScreen);
        if (recipeBook == null || !recipeBook.invokeIsOpen()) {
            return CursorType.DEFAULT;
        }
        RecipeBookResultsAccessor recipesArea = (RecipeBookResultsAccessor)recipeBook.getRecipesArea();
        OverlayRecipeComponent alternatesWidget = recipesArea.getAlternatesWidget();
        if (alternatesWidget.isVisible()) {
            return this.getAlternatesWidgetCursor((RecipeAlternativesWidgetAccessor)alternatesWidget);
        }
        if (recipesArea.getHoveredResultButton() != null && CursorTypeUtil.canShift()) {
            return CursorType.SHIFT;
        }
        if (this.isButtonHovered(recipeBook, recipesArea) || recipesArea.getHoveredResultButton() != null) {
            return CursorType.POINTER;
        }
        if (recipeBook.getSearchField().isHovered()) {
            return CursorType.TEXT;
        }
        return this.getTabCursor(recipeBook);
    }

    private RecipeBookWidgetAccessor getRecipeBook(AbstractContainerScreen<?> screen) {
        AbstractContainerScreen<?> abstractContainerScreen = screen;
        Objects.requireNonNull(abstractContainerScreen);
        AbstractContainerScreen<?> abstractContainerScreen2 = abstractContainerScreen;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InventoryScreen.class, CraftingScreen.class, AbstractFurnaceScreen.class}, abstractContainerScreen2, n)) {
            case 0 -> {
                InventoryScreen inventory = (InventoryScreen)abstractContainerScreen2;
                yield (RecipeBookWidgetAccessor)((InventoryScreenAccessor)inventory).getRecipeBook();
            }
            case 1 -> {
                CraftingScreen crafting = (CraftingScreen)abstractContainerScreen2;
                yield (RecipeBookWidgetAccessor)((CraftingScreenAccessor)crafting).getRecipeBook();
            }
            case 2 -> {
                AbstractFurnaceScreen furnace = (AbstractFurnaceScreen)abstractContainerScreen2;
                yield (RecipeBookWidgetAccessor)((AbstractFurnaceScreenAccessor)furnace).getRecipeBook();
            }
            default -> null;
        };
    }

    private CursorType getAlternatesWidgetCursor(RecipeAlternativesWidgetAccessor alternatesWidget) {
        return alternatesWidget.getAlternativeButtons().stream().anyMatch(AbstractWidget::isHovered) ? (CursorTypeUtil.canShift() ? CursorType.SHIFT : CursorType.POINTER) : CursorType.DEFAULT_FORCE;
    }

    private boolean isButtonHovered(RecipeBookWidgetAccessor recipeBook, RecipeBookResultsAccessor recipesArea) {
        return recipesArea.getPrevPageButton().isHovered() && recipesArea.getPrevPageButton().visible || recipesArea.getNextPageButton().isHovered() && recipesArea.getNextPageButton().visible || recipeBook.getToggleCraftableButton().isHovered();
    }

    private CursorType getTabCursor(RecipeBookWidgetAccessor recipeBook) {
        return recipeBook.getTabButtons().stream().anyMatch(btn -> btn.isHovered() && btn != recipeBook.getCurrentTab()) ? CursorType.POINTER : CursorType.DEFAULT;
    }
}

