/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.CursorAnimationHelper;
import io.github.fishstiz.minecraftcursor.gui.screen.MoreOptionsScreen;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsHandler;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class CursorOptionsScreen
extends Screen {
    private static final Component TITLE_TEXT = Component.translatable((String)"minecraft-cursor.options");
    private static final int CURSORS_COLUMN_WIDTH = 96;
    private static final int SELECTED_CURSOR_COLUMN_WIDTH = 200;
    private static final int COLUMN_GAP = 8;
    final Screen previousScreen;
    public final CursorAnimationHelper animationHelper = new CursorAnimationHelper();
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final List<Cursor> cursors;
    private Cursor selectedCursor;
    private CursorListWidget list;
    @Nullable
    CursorOptionsWidget options;

    public CursorOptionsScreen(Screen previousScreen) {
        super(TITLE_TEXT);
        this.previousScreen = previousScreen;
        this.cursors = CursorManager.INSTANCE.getLoadedCursors();
    }

    protected void init() {
        this.selectedCursor = this.cursors.getFirst();
        this.layout.addTitleHeader(this.title, this.font);
        this.layout.addToContents((LayoutElement)this.initContents(LinearLayout.horizontal().spacing(8)));
        this.layout.addToFooter((LayoutElement)this.initFooter(LinearLayout.horizontal().spacing(8)));
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected LinearLayout initContents(LinearLayout contents) {
        this.list = (CursorListWidget)contents.addChild((LayoutElement)new CursorListWidget(this.minecraft, 96, this.layout.getContentHeight(), this.layout.getHeaderHeight(), this));
        this.options = (CursorOptionsWidget)contents.addChild((LayoutElement)new CursorOptionsWidget(0, 200, this.layout.getContentHeight(), this.layout.getHeaderHeight(), this));
        return contents;
    }

    protected LinearLayout initFooter(LinearLayout footer) {
        footer.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"minecraft-cursor.options.more").append("..."), btn -> this.toMoreOptions()).build());
        footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onClose()).build());
        return footer;
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        this.list.setHeight(this.layout.getContentHeight());
        this.list.setY(this.layout.getHeaderHeight());
        if (this.options != null) {
            this.options.setHeight(this.layout.getContentHeight());
            this.options.setY(this.layout.getHeaderHeight());
        }
    }

    public void selectCursor(Cursor cursor) {
        this.updateSelectedCursorConfig();
        this.selectedCursor = cursor;
        if (this.options != null) {
            this.options.refresh();
        }
    }

    private void updateSelectedCursorConfig() {
        if (this.options != null) {
            this.options.save();
        }
    }

    public Cursor getSelectedCursor() {
        return this.selectedCursor;
    }

    public List<Cursor> getCursors() {
        return this.cursors;
    }

    public void toMoreOptions() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new MoreOptionsScreen(this));
        }
    }

    public void onClose() {
        CursorOptionsHandler.removeScaleOverride();
        MinecraftCursor.CONFIG.save();
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.previousScreen);
        }
    }
}

