/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorOptionsScreen;
import io.github.fishstiz.minecraftcursor.gui.widget.MoreOptionsListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorHotspotWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoreOptionsScreen
extends Screen {
    private static final int FOOTER_SPACING = 8;
    private static final int HOTSPOT_WIDGET_SIZE = 96;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final Screen previousScreen;
    @Nullable
    private SelectedCursorHotspotWidget hotspotWidget;
    private MoreOptionsListWidget list;

    protected MoreOptionsScreen(Screen previousScreen) {
        super((Component)Component.translatable((String)"minecraft-cursor.options.more"));
        this.previousScreen = previousScreen;
    }

    protected void init() {
        this.list = new MoreOptionsListWidget(this.minecraft, this.width, this.layout.getContentHeight(), this.layout.getHeaderHeight());
        Screen screen = this.previousScreen;
        if (screen instanceof CursorOptionsScreen) {
            CursorOptionsScreen optionsScreen = (CursorOptionsScreen)screen;
            if (optionsScreen.options != null) {
                this.hotspotWidget = new SelectedCursorHotspotWidget(96, optionsScreen.options);
                this.hotspotWidget.visible = false;
                this.hotspotWidget.setChangeEventListener(this.list::handleChangeHotspotWidget);
                this.addWidget((GuiEventListener)this.hotspotWidget);
            }
        }
        this.layout.addTitleHeader(this.title, this.font);
        this.layout.addToContents((LayoutElement)this.list);
        this.layout.addToFooter((LayoutElement)this.createFooter());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private LinearLayout createFooter() {
        LinearLayout footer = LinearLayout.horizontal().spacing(8);
        ResourceLocation inspectIcon = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/icon/search.png");
        int iconSize = 12;
        int inspectSize = 20;
        SelectedCursorButtonWidget inspect = new SelectedCursorButtonWidget(inspectIcon, iconSize, iconSize, MinecraftCursor::toggleInspect);
        inspect.setSize(inspectSize, inspectSize);
        footer.addChild((LayoutElement)inspect);
        footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onClose()).build());
        return footer;
    }

    protected void repositionElements() {
        if (this.list != null) {
            this.layout.arrangeElements();
            this.list.updateSize(this.width, this.layout);
        }
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        if (this.list == null || this.hotspotWidget == null) {
            return;
        }
        if (this.list.isEditingHotspot()) {
            int rowGap = this.list.getRowGap();
            int x = this.list.getRowLeft() - this.hotspotWidget.getWidth() - rowGap;
            int y = this.list.getYEntry(1) + rowGap / 2;
            this.hotspotWidget.setPosition(x, y);
            this.hotspotWidget.visible = true;
            this.hotspotWidget.active = true;
            context.enableScissor(x, this.layout.getHeaderHeight(), this.list.getRowLeft(), this.layout.getHeaderHeight() + this.layout.getContentHeight());
            this.hotspotWidget.render(context, mouseX, mouseY, delta);
            context.disableScissor();
        } else {
            this.hotspotWidget.visible = false;
            this.hotspotWidget.active = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onClose() {
        this.list.applyConfig();
        if (this.minecraft == null) return;
        Screen screen = this.previousScreen;
        if (screen instanceof CursorOptionsScreen) {
            CursorOptionsScreen previous = (CursorOptionsScreen)screen;
            if (previous.options != null) {
                CursorOptionsScreen optionsScreen = new CursorOptionsScreen(previous.previousScreen);
                optionsScreen.selectCursor(previous.getSelectedCursor());
                this.minecraft.setScreen((Screen)optionsScreen);
                return;
            }
        }
        this.minecraft.setScreen(this.previousScreen);
    }
}

