/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorOptionsScreen;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorListWidget
extends ContainerObjectSelectionList<CursorEntry> {
    private static final int ITEM_HEIGHT = 32;
    private static final int SCROLLBAR_OFFSET = 6;
    private static final int ROW_GAP = 1;
    private final CursorOptionsScreen optionsScreen;

    public CursorListWidget(Minecraft client, int width, int height, int y, CursorOptionsScreen optionsScreen) {
        super(client, width + 6, height, y, 33);
        this.optionsScreen = optionsScreen;
        this.populateEntries();
    }

    public void populateEntries() {
        for (Cursor cursor : this.optionsScreen.getCursors()) {
            CursorEntry entry = new CursorEntry(cursor, this.getX(), this.getY() + this.itemHeight * this.getItemCount(), this.width - 6, 32);
            this.addEntry((AbstractSelectionList.Entry)entry);
        }
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getY()) + 1 * this.getItemCount() - 1);
    }

    protected int getScrollbarPosition() {
        return this.getRight() - 6;
    }

    protected int getRowTop(int index) {
        return this.getY() + (this.itemHeight + 1) * index - (int)this.getScrollAmount();
    }

    protected int getRowIndex(double y) {
        int index = ((int)Math.floor(y - (double)this.getY()) + (int)this.getScrollAmount()) / (this.itemHeight + 1);
        return index >= 0 && index < this.getItemCount() ? index : -1;
    }

    @Nullable
    protected CursorEntry getEntryAtPosition(double mouseX, double mouseY) {
        int index = this.getRowIndex(mouseY);
        return index >= 0 && this.isMouseOver(mouseX, mouseY) ? (CursorEntry)this.getEntry(index) : null;
    }

    protected void renderListSeparators(@NotNull GuiGraphics context) {
    }

    public void renderListBackground(@NotNull GuiGraphics context) {
    }

    public class CursorEntry
    extends ContainerObjectSelectionList.Entry<CursorEntry> {
        public final CursorButtonWidget button;

        public CursorEntry(Cursor cursor, int x, int y, int width, int height) {
            this.button = new CursorButtonWidget(x, y, width, height, cursor);
        }

        public void render(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.button.setX(CursorListWidget.this.getX());
            this.button.setY(CursorListWidget.this.getY() + (CursorListWidget.this.itemHeight + 1) * index - (int)Math.round(CursorListWidget.this.getScrollAmount()));
            this.button.render(context, mouseX, mouseY, delta);
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.button);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of(this.button);
        }
    }

    public class CursorButtonWidget
    extends AbstractButton {
        private static final String PREFIX_TEXT_KEY = "minecraft-cursor.options.cursor-type.";
        private static final int TEXTURE_SIZE = 16;
        private static final int PADDING_LEFT = 8;
        private static final int BACKGROUND_COLOR = 0x7F000000;
        private static final int TEXT_COLOR = -1;
        private static final int TEXT_DISABLED_COLOR = -11184811;
        private static final int BORDER_COLOR = -16777216;
        private static final int SELECTED_BORDER_COLOR = -1;
        private static final int HOVERED_BORDER_COLOR = -11184811;
        private final Cursor cursor;

        CursorButtonWidget(int x, int y, int width, int height, Cursor cursor) {
            super(x, y, width, height, (Component)Component.empty());
            this.cursor = cursor;
        }

        public void onPress() {
            CursorListWidget.this.optionsScreen.selectCursor(this.cursor);
        }

        protected void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
            this.renderBox(context);
            this.renderTexture(context);
            this.renderMessage(context);
            this.renderBorder(context);
        }

        private void renderBorder(GuiGraphics context) {
            int borderColor = -16777216;
            if (this.cursor == CursorListWidget.this.optionsScreen.getSelectedCursor()) {
                borderColor = -1;
            } else if (this.isHoveredOrFocused()) {
                borderColor = -11184811;
            }
            context.renderOutline(this.getX(), this.getY(), this.getWidth(), this.getHeight(), borderColor);
        }

        private void renderBox(GuiGraphics context) {
            int x2 = this.getX() + this.getWidth();
            int y2 = this.getY() + this.getHeight();
            context.fill(this.getX(), this.getY(), x2, y2, 0x7F000000);
        }

        private void renderTexture(GuiGraphics context) {
            int x = this.getX() + 8;
            int y = this.getY() + this.getHeight() / 2 - 8;
            CursorListWidget.this.optionsScreen.animationHelper.drawSprite(context, this.cursor, x, y, 16);
        }

        private void renderMessage(GuiGraphics context) {
            MutableComponent message = Component.translatable((String)(PREFIX_TEXT_KEY + this.cursor.getType().getKey()));
            int color = this.cursor.isEnabled() ? -1 : -11184811;
            int x = this.getX() + 16 + 16;
            int endX = this.getX() + this.getWidth() - 6;
            int endY = this.getY() + this.getHeight();
            DrawUtil.drawScrollableTextLeftAlign(context, ((CursorListWidget)CursorListWidget.this).minecraft.font, (Component)message, x, this.getY(), endX, endY, color);
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput builder) {
        }
    }
}

