/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SelectedCursorButtonWidget
extends Button {
    private ResourceLocation icon;
    private int iconWidth;
    private int iconHeight;

    public SelectedCursorButtonWidget(ResourceLocation icon, int iconWidth, int iconHeight, Runnable onPress) {
        this((Component)Component.empty(), onPress);
        this.icon = icon;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
    }

    public SelectedCursorButtonWidget(Component message, Runnable onPress) {
        super(0, 0, 150, 20, message, b -> onPress.run(), Button.DEFAULT_NARRATION);
    }

    public void onRelease(double mouseX, double mouseY) {
        super.onRelease(mouseX, mouseY);
        this.setFocused(false);
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderWidget(context, mouseX, mouseY, delta);
        if (this.icon != null) {
            int iconX = this.getX() + (this.getWidth() - this.iconWidth) / 2;
            int iconY = this.getY() + (this.getHeight() - this.iconHeight) / 2;
            context.blit(this.icon, iconX, iconY, 0.0f, 0.0f, this.iconWidth, this.iconHeight, this.iconWidth, this.iconHeight);
        }
    }
}

