/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import io.github.fishstiz.minecraftcursor.util.MouseEvent;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SelectedCursorHotspotWidget
extends AbstractWidget
implements CursorProvider {
    private static final CursorConfig.GlobalSettings global = MinecraftCursor.CONFIG.getGlobal();
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minecraft-cursor", (String)"textures/gui/hotspot_background.png");
    private static final int CURSOR_SIZE = 32;
    private static final int RULER_COLOR = -65536;
    private static final int OVERRIDE_RULER_COLOR = -16711936;
    private final CursorOptionsWidget options;
    private boolean rulerRendered = true;
    private float rulerAlpha = 1.0f;
    private MouseEventListener changeEventListener;

    public SelectedCursorHotspotWidget(int size, CursorOptionsWidget options) {
        super(options.getX(), options.getY(), size, size, (Component)Component.empty());
        this.options = options;
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.blit(BACKGROUND, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        if (!this.active) {
            context.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), -1358954496);
        }
        this.drawCursorTexture(context);
        this.renderRuler(context, mouseX, mouseY);
        context.renderOutline(this.getX(), this.getY(), this.getWidth(), this.getHeight(), -16777216);
    }

    private void drawCursorTexture(GuiGraphics context) {
        this.options.parent().animationHelper.drawSprite(context, this.options.parent().getSelectedCursor(), this.getX(), this.getY(), this.width);
    }

    private void renderRuler(GuiGraphics context, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.setRulerRendered(true, false);
        }
        this.rulerAlpha = Mth.lerp((float)0.3f, (float)this.rulerAlpha, (float)(this.rulerRendered ? 1.0f : 0.0f));
        if (this.rulerAlpha <= 0.01f) {
            return;
        }
        boolean isGlobalX = global.isXHotActive();
        boolean isGlobalY = global.isYHotActive();
        int xhot = isGlobalX ? global.getXHot() : (int)this.options.xhotSlider.getTranslatedValue();
        int yhot = isGlobalY ? global.getYHot() : (int)this.options.yhotSlider.getTranslatedValue();
        int rulerSize = this.getRulerSize();
        int xhotX1 = this.getX() + xhot * rulerSize;
        int xhotX2 = this.getX() + xhot * rulerSize + rulerSize;
        int yhotY1 = this.getY() + yhot * rulerSize;
        int yhotY2 = this.getY() + yhot * rulerSize + rulerSize;
        int alpha = (int)(this.rulerAlpha * 255.0f);
        int blendedColorX = this.getBlendedColor(isGlobalX ? -16711936 : -65536, alpha);
        int blendedColorY = this.getBlendedColor(isGlobalY ? -16711936 : -65536, alpha);
        if (isGlobalX && !isGlobalY || isGlobalX == isGlobalY) {
            context.fill(this.getX(), yhotY1, this.getRight(), yhotY2, blendedColorY);
            context.fill(xhotX1, this.getY(), xhotX2, this.getBottom(), blendedColorX);
        } else {
            context.fill(xhotX1, this.getY(), xhotX2, this.getBottom(), blendedColorX);
            context.fill(this.getX(), yhotY1, this.getRight(), yhotY2, blendedColorY);
        }
    }

    public int getBlendedColor(int color, int alpha) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public void onClick(double mouseX, double mouseY) {
        this.setHotspots(MouseEvent.CLICK, mouseX, mouseY);
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setHotspots(MouseEvent.DRAG, mouseX, mouseY);
    }

    public void setHotspots(MouseEvent mouseEvent, double mouseX, double mouseY) {
        if (this.changeEventListener != null) {
            int rulerSize = this.getRulerSize();
            int x = ((int)mouseX - this.getX()) / rulerSize;
            int y = ((int)mouseY - this.getY()) / rulerSize;
            this.changeEventListener.onChange(mouseEvent, x, y);
        }
        this.setRulerRendered(true, true);
    }

    private int getRulerSize() {
        return this.getWidth() / 32;
    }

    public void setRulerRendered(boolean rulerRendered, boolean immediate) {
        if (immediate) {
            this.rulerAlpha = rulerRendered ? 1.0f : 0.0f;
        }
        this.rulerRendered = rulerRendered;
    }

    public CursorType getCursorType(double mouseX, double mouseY) {
        if (!this.active) {
            return CursorType.DEFAULT;
        }
        if (this.isFocused() && (CursorTypeUtil.isLeftClickHeld() || CursorTypeUtil.isGrabbing())) {
            return CursorType.GRABBING;
        }
        return CursorType.POINTER;
    }

    public void setChangeEventListener(BiConsumer<Integer, Integer> changeEventListener) {
        this.setChangeEventListener((MouseEvent mouseEvent, int x, int y) -> changeEventListener.accept(x, y));
    }

    public void setChangeEventListener(MouseEventListener changeEventListener) {
        this.changeEventListener = changeEventListener;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.visible && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)this.getRight() && mouseY < (double)this.getBottom();
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isFocused()) {
            this.setHotspots(MouseEvent.RELEASE, mouseX, mouseY);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }

    @FunctionalInterface
    public static interface MouseEventListener {
        public void onChange(MouseEvent var1, int var2, int var3);
    }
}

