/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorButtonWidget;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class SelectedCursorSliderWidget
extends AbstractSliderButton {
    private final Component prefix;
    private final double min;
    private final double max;
    private final double step;
    private final String suffix;
    private final Consumer<Double> onApply;
    @Nullable
    private final Runnable onRelease;
    private double translatedValue;
    private SelectedCursorButtonWidget inactiveHelperButton;
    private TextMapper textMapper;

    public SelectedCursorSliderWidget(Component text, double defaultValue, double min, double max, double step, Consumer<Double> onApply, Runnable onRelease) {
        this(text, defaultValue, min, max, step, "", onApply, onRelease);
    }

    public SelectedCursorSliderWidget(Component text, double defaultValue, double min, double max, double step, String suffix, Consumer<Double> onApply) {
        this(text, defaultValue, min, max, step, suffix, onApply, null);
    }

    public SelectedCursorSliderWidget(Component text, double defaultValue, double min, double max, double step, String suffix, Consumer<Double> onApply, @Nullable Runnable onRelease) {
        super(0, 0, 0, 0, text, defaultValue);
        this.prefix = text;
        this.min = min;
        this.max = max;
        this.step = step;
        this.suffix = suffix;
        this.onApply = onApply;
        this.onRelease = onRelease;
        this.value = this.translatedValueToValue(defaultValue);
        this.translateValue();
        this.updateMessage();
    }

    private double translatedValueToValue(double translatedValue) {
        double clampedValue = Math.max(this.min, Math.min(translatedValue, this.max));
        return (clampedValue - this.min) / (this.max - this.min);
    }

    public void setTextMapper(TextMapper mapper) {
        this.textMapper = mapper;
        this.updateMessage();
    }

    public void update(double translatedValue, boolean active) {
        this.setTranslatedValue(translatedValue);
        this.active = active;
    }

    public void setTranslatedValue(double translatedValue) {
        this.value = this.translatedValueToValue(translatedValue);
        this.applyValue();
        this.updateMessage();
    }

    private void translateValue() {
        double scaledValue = this.min + this.value * (this.max - this.min);
        this.translatedValue = (double)Math.round(scaledValue / this.step) * this.step;
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        boolean isHelperButtonPresent;
        super.renderWidget(context, mouseX, mouseY, delta);
        SelectedCursorButtonWidget helperButton = this.getInactiveHelperButton();
        boolean bl = isHelperButtonPresent = helperButton != null;
        if (isHelperButtonPresent) {
            boolean bl2 = helperButton.active = !this.active;
            if (this.isMouseOverInactive(mouseX, mouseY)) {
                PoseStack poseStack = context.pose();
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, 1.0f);
                helperButton.render(context, mouseX, mouseY, delta);
                poseStack.popPose();
            }
        }
        this.isHovered = this.isMouseOver(mouseX, mouseY);
    }

    protected void applyValue() {
        double previousTranslatedValue = this.translatedValue;
        this.translateValue();
        if (this.isFocused() && previousTranslatedValue != this.translatedValue) {
            this.onApply.accept(this.translatedValue);
        }
    }

    protected void updateMessage() {
        Component mappedText;
        MutableComponent label = this.prefix.copy().append(": ");
        MutableComponent message = null;
        if (this.textMapper != null && (mappedText = this.textMapper.getText(this.translatedValue)) != null) {
            message = label.append(mappedText);
        }
        if (message == null) {
            String formattedValue = String.format(this.step % 1.0 == 0.0 ? "%.0f" : "%.2f", this.translatedValue);
            message = label.append(formattedValue + this.suffix);
        }
        this.setMessage((Component)message);
    }

    public double getTranslatedValue() {
        return this.translatedValue;
    }

    public void onRelease(double mouseX, double mouseY) {
        super.onRelease(mouseX, mouseY);
        this.setFocused(false);
        if (this.onRelease != null) {
            this.onRelease.run();
        }
    }

    @Nullable
    public SelectedCursorButtonWidget getInactiveHelperButton() {
        if (this.inactiveHelperButton == null) {
            return null;
        }
        int marginRight = 2;
        int x = this.getX() + this.getWidth() - this.inactiveHelperButton.getWidth() - marginRight;
        int y = this.getY() + (this.getHeight() - this.inactiveHelperButton.getHeight()) / 2;
        this.inactiveHelperButton.setPosition(x, y);
        return this.inactiveHelperButton;
    }

    public void setInactiveHelperButton(SelectedCursorButtonWidget helperButton, int width, int height) {
        this.inactiveHelperButton = helperButton;
        this.inactiveHelperButton.setSize(width, height);
    }

    public Component getPrefix() {
        return this.prefix;
    }

    public boolean isMouseOverInactive(int mouseX, int mouseY) {
        return !this.active && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getRight() && mouseY < this.getBottom();
    }

    @FunctionalInterface
    public static interface TextMapper {
        @Nullable
        public Component getText(double var1);
    }
}

