/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SelectedCursorTestWidget
extends AbstractWidget
implements CursorProvider {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minecraft-cursor", (String)"textures/gui/test_background.png");
    private static final int HOTSPOT_RULER_COLOR = -16711936;
    private static final Button BUTTON = Button.builder((Component)Component.empty(), b -> b.setFocused(false)).size(20, 20).build();
    private final CursorOptionsWidget options;

    public SelectedCursorTestWidget(int size, CursorOptionsWidget optionsWidget) {
        super(optionsWidget.getX(), optionsWidget.getY(), size, size, (Component)Component.empty());
        this.options = optionsWidget;
        this.active = false;
    }

    private void placeButton() {
        int x = this.getX() + (this.getWidth() / 2 - BUTTON.getWidth() / 2);
        int y = this.getY() + (this.getHeight() / 2 - BUTTON.getHeight() / 2);
        BUTTON.setPosition(x, y);
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.blit(BACKGROUND, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        if (this.options.parent().getSelectedCursor().isEnabled()) {
            BUTTON.render(context, mouseX, mouseY, delta);
            this.renderRuler(context, mouseX, mouseY);
        } else {
            context.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), 0x7F000000);
        }
        context.renderOutline(this.getX(), this.getY(), this.getWidth(), this.getHeight(), -16777216);
        this.placeButton();
    }

    private void renderRuler(GuiGraphics context, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            context.hLine(this.getX(), this.getRight() - 1, mouseY, -16711936);
            context.vLine(mouseX, this.getY(), this.getBottom(), -16711936);
        }
    }

    public CursorType getCursorType(double mouseX, double mouseY) {
        return this.options.parent().getSelectedCursor().getType();
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)this.getRight() && mouseY < (double)this.getBottom();
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }
}

